/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.cache;

import com.yahoo.elide.datastores.aggregation.cache.Cache;
import com.yahoo.elide.datastores.aggregation.query.QueryResult;
import org.springframework.util.SerializationUtils;
import redis.clients.jedis.UnifiedJedis;

public class RedisCache
implements Cache {
    private UnifiedJedis jedis;
    private long defaultExprirationMinutes;

    public RedisCache(UnifiedJedis jedis, long defaultExprirationMinutes) {
        this.jedis = jedis;
        this.defaultExprirationMinutes = defaultExprirationMinutes;
    }

    @Override
    public QueryResult get(Object key) {
        return (QueryResult)SerializationUtils.deserialize((byte[])this.jedis.get(SerializationUtils.serialize((Object)key)));
    }

    @Override
    public void put(Object key, QueryResult result) {
        byte[] keyBytes = SerializationUtils.serialize((Object)key);
        this.jedis.set(keyBytes, SerializationUtils.serialize((Object)result));
        this.jedis.expire(keyBytes, this.defaultExprirationMinutes * 60L);
    }

    public void setJedis(UnifiedJedis jedis) {
        this.jedis = jedis;
    }

    public void setDefaultExprirationMinutes(long defaultExprirationMinutes) {
        this.defaultExprirationMinutes = defaultExprirationMinutes;
    }
}

