/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.dynamic;

import com.yahoo.elide.core.exceptions.InvalidParameterizedAttributeException;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.type.Field;
import com.yahoo.elide.core.type.ParameterizedModel;
import com.yahoo.elide.core.type.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Optional;

public class FieldType
implements Field {
    private static final long serialVersionUID = -1358950447581934754L;
    private transient Map<Class<? extends Annotation>, Annotation> annotations;
    private String name;
    private Type type;

    public FieldType(String name, Type type, Map<Class<? extends Annotation>, Annotation> annotations) {
        this.name = name;
        this.annotations = annotations;
        this.type = type;
    }

    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!ParameterizedModel.class.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Class is not a dynamic type: " + obj.getClass());
        }
        ParameterizedModel model = (ParameterizedModel)obj;
        try {
            return model.invoke(Attribute.builder().name(this.name).type(this.type).alias(this.name).build());
        }
        catch (InvalidParameterizedAttributeException e) {
            return null;
        }
    }

    public Type<?> getType() {
        return this.type;
    }

    public Type<?> getParameterizedType(Type<?> parentType, Optional<Integer> index) {
        return this.type;
    }

    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (!ParameterizedModel.class.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Class is not a dynamic type: " + obj.getClass());
        }
        ParameterizedModel model = (ParameterizedModel)obj;
        model.addAttributeValue(Attribute.builder().name(this.name).type(this.type).alias(this.name).build(), value);
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotations.containsKey(annotationClass);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.annotations.containsKey(annotationClass)) {
            return (T)this.annotations.get(annotationClass);
        }
        return null;
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        if (this.annotations.containsKey(annotationClass)) {
            Annotation[] result = (Annotation[])Array.newInstance(annotationClass, 1);
            result[0] = this.annotations.get(annotationClass);
            return result;
        }
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[0]);
    }

    public int getModifiers() {
        return 1;
    }
}

