/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.query;

import com.google.common.collect.Streams;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.QueryVisitor;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.ConnectionDetails;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLJoin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Queryable {
    public Queryable getSource();

    default public String getAlias() {
        return this.getSource().getAlias() + "_" + (this.hashCode() & Integer.MAX_VALUE);
    }

    default public String getName() {
        return this.getAlias();
    }

    default public String getVersion() {
        return "";
    }

    default public ColumnProjection getColumnProjection(String name) {
        return this.getColumnProjections().stream().filter(dim -> dim.getAlias().equals(name)).findFirst().orElse(null);
    }

    default public ColumnProjection getColumnProjection(String name, Map<String, Argument> arguments, boolean isProjected) {
        return this.getColumnProjections().stream().filter(dim -> dim.isProjected() == isProjected).filter(dim -> dim.getAlias().equals(name) && dim.getArguments().equals(arguments)).findFirst().orElse(null);
    }

    default public ColumnProjection getColumnProjection(String name, Map<String, Argument> arguments) {
        return this.getColumnProjections().stream().filter(dim -> dim.getAlias().equals(name) && dim.getArguments().equals(arguments)).findFirst().orElse(null);
    }

    default public ColumnProjection getColumnProjection(Predicate<ColumnProjection> filterPredicate) {
        return this.getColumnProjections().stream().filter(filterPredicate).findFirst().orElse(null);
    }

    default public DimensionProjection getDimensionProjection(String name) {
        return this.getDimensionProjections().stream().filter(dim -> dim.getAlias().equals(name)).findFirst().orElse(null);
    }

    public List<DimensionProjection> getDimensionProjections();

    default public MetricProjection getMetricProjection(String name) {
        return this.getMetricProjections().stream().filter(metric -> metric.getAlias().equals(name)).findFirst().orElse(null);
    }

    public List<MetricProjection> getMetricProjections();

    default public TimeDimensionProjection getTimeDimensionProjection(String name) {
        return this.getTimeDimensionProjections().stream().filter(dim -> dim.getAlias().equals(name)).findFirst().orElse(null);
    }

    public List<TimeDimensionProjection> getTimeDimensionProjections();

    default public List<ColumnProjection> getColumnProjections() {
        return Streams.concat((Stream[])new Stream[]{this.getTimeDimensionProjections().stream(), this.getDimensionProjections().stream(), this.getMetricProjections().stream()}).collect(Collectors.toList());
    }

    default public <T extends ColumnProjection> List<T> getFilterProjections(FilterExpression expression, Class<T> columnType) {
        return this.getFilterProjections(expression).stream().filter(columnType::isInstance).map(columnType::cast).collect(Collectors.toList());
    }

    default public FilterExpression getWhereFilter() {
        return null;
    }

    default public List<ColumnProjection> getFilterProjections(FilterExpression expression) {
        ArrayList<ColumnProjection> results = new ArrayList<ColumnProjection>();
        if (expression == null) {
            return results;
        }
        Collection predicates = (Collection)expression.accept((FilterExpressionVisitor)new PredicateExtractionVisitor());
        predicates.stream().forEach(predicate -> {
            HashMap<String, Argument> arguments = new HashMap<String, Argument>();
            ((Path.PathElement)predicate.getPath().lastElement().get()).getArguments().forEach(argument -> arguments.put(argument.getName(), (Argument)argument));
            ColumnProjection projection = this.getSource().getColumnProjection(predicate.getField(), arguments);
            results.add(projection);
        });
        return results;
    }

    default public ConnectionDetails getConnectionDetails() {
        return this.getRoot().getConnectionDetails();
    }

    default public <T> T accept(QueryVisitor<T> visitor) {
        return visitor.visitQueryable(this);
    }

    default public boolean isNested() {
        Queryable source = this.getSource();
        return source != null && source.getSource() != source;
    }

    default public Queryable getRoot() {
        Queryable current = this;
        while (current.isNested()) {
            current = current.getSource();
        }
        return current.getSource();
    }

    default public boolean isRoot() {
        return this == this.getRoot();
    }

    default public int nestDepth() {
        int depth = 0;
        Queryable current = this;
        while (current.isNested()) {
            ++depth;
            current = current.getSource();
        }
        return depth;
    }

    default public Map<String, SQLJoin> getJoins() {
        return this.getRoot().getJoins();
    }

    default public SQLJoin getJoin(String joinName) {
        return this.getJoins().get(joinName);
    }

    default public boolean hasJoin(String joinName) {
        return this.getJoins().containsKey(joinName);
    }

    default public SQLDialect getDialect() {
        return this.getConnectionDetails().getDialect();
    }

    public static Set<ColumnProjection> extractFilterProjections(Queryable query, FilterExpression expression) {
        if (expression == null) {
            return new LinkedHashSet<ColumnProjection>();
        }
        Collection predicates = (Collection)expression.accept((FilterExpressionVisitor)new PredicateExtractionVisitor());
        LinkedHashSet<ColumnProjection> filterProjections = new LinkedHashSet<ColumnProjection>();
        predicates.stream().forEach(predicate -> {
            HashMap<String, Argument> arguments = new HashMap<String, Argument>();
            ((Path.PathElement)predicate.getPath().lastElement().get()).getArguments().forEach(argument -> arguments.put(argument.getName(), (Argument)argument));
            ColumnProjection projection = query.getSource().getColumnProjection(predicate.getField(), arguments);
            if (projection != null) {
                filterProjections.add(projection);
            }
        });
        return filterProjections;
    }

    default public Map<String, Argument> getArguments() {
        return Collections.emptyMap();
    }
}

