/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.timegrains;

import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.aggregation.metadata.enums.TimeGrain;
import com.yahoo.elide.datastores.aggregation.timegrains.Hour;
import com.yahoo.elide.datastores.aggregation.timegrains.Minute;
import com.yahoo.elide.datastores.aggregation.timegrains.Month;
import com.yahoo.elide.datastores.aggregation.timegrains.Second;
import com.yahoo.elide.datastores.aggregation.timegrains.Year;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Time
extends Date {
    public static Type<Time> TIME_TYPE = ClassType.of(Time.class);
    protected final Serializer serializer;
    protected final boolean supportsYear;
    protected final boolean supportsMonth;
    protected final boolean supportsDay;
    protected final boolean supportsHour;
    protected final boolean supportsMinute;
    protected final boolean supportsSecond;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Time time = (Time)o;
        return this.supportsYear == time.supportsYear && this.supportsMonth == time.supportsMonth && this.supportsDay == time.supportsDay && this.supportsHour == time.supportsHour && this.supportsMinute == time.supportsMinute && this.supportsSecond == time.supportsSecond && this.getTime() == time.getTime();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.supportsYear, this.supportsMonth, this.supportsDay, this.supportsHour, this.supportsMinute, this.supportsSecond, this.getTime());
    }

    public Time(LocalDateTime copy, boolean supportsYear, boolean supportsMonth, boolean supportsDay, boolean supportsHour, boolean supportsMinute, boolean supportsSecond, Serializer formatter) {
        super(TimeUnit.SECONDS.toMillis(copy.atZone(ZoneOffset.systemDefault()).toEpochSecond()));
        this.supportsYear = supportsYear;
        this.supportsMonth = supportsMonth;
        this.supportsDay = supportsDay;
        this.supportsHour = supportsHour;
        this.supportsMinute = supportsMinute;
        this.supportsSecond = supportsSecond;
        this.serializer = formatter;
    }

    public Time(Date copy, boolean supportsYear, boolean supportsMonth, boolean supportsDay, boolean supportsHour, boolean supportsMinute, boolean supportsSecond, Serializer serializer) {
        super(copy.getTime());
        this.supportsYear = supportsYear;
        this.supportsMonth = supportsMonth;
        this.supportsDay = supportsDay;
        this.supportsHour = supportsHour;
        this.supportsMinute = supportsMinute;
        this.supportsSecond = supportsSecond;
        this.serializer = serializer;
    }

    @Override
    public String toString() {
        return this.serializer.format(this);
    }

    public static Serializer getSerializer(TimeGrain grain) {
        return time -> {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(time.toInstant(), ZoneOffset.systemDefault());
            return (switch (grain) {
                case TimeGrain.SECOND -> Second.FORMATTER;
                case TimeGrain.MINUTE -> Minute.FORMATTER;
                case TimeGrain.HOUR -> Hour.FORMATTER;
                case TimeGrain.MONTH, TimeGrain.QUARTER -> Month.FORMATTER;
                case TimeGrain.YEAR -> Year.FORMATTER;
                default -> DateTimeFormatter.ISO_LOCAL_DATE;
            }).format(localDateTime);
        };
    }

    public Time(Serializer serializer, boolean supportsYear, boolean supportsMonth, boolean supportsDay, boolean supportsHour, boolean supportsMinute, boolean supportsSecond) {
        this.serializer = serializer;
        this.supportsYear = supportsYear;
        this.supportsMonth = supportsMonth;
        this.supportsDay = supportsDay;
        this.supportsHour = supportsHour;
        this.supportsMinute = supportsMinute;
        this.supportsSecond = supportsSecond;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public boolean isSupportsYear() {
        return this.supportsYear;
    }

    public boolean isSupportsMonth() {
        return this.supportsMonth;
    }

    public boolean isSupportsDay() {
        return this.supportsDay;
    }

    public boolean isSupportsHour() {
        return this.supportsHour;
    }

    public boolean isSupportsMinute() {
        return this.supportsMinute;
    }

    public boolean isSupportsSecond() {
        return this.supportsSecond;
    }

    @FunctionalInterface
    public static interface Serializer
    extends Serializable {
        public String format(Time var1);
    }

    @ElideTypeConverter(type=Time.class, name="Time")
    public static class TimeSerde
    implements Serde<Object, Time> {
        private static final String SECOND_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
        private static final String MINUTE_PATTERN = "yyyy-MM-dd'T'HH:mm";
        private static final String HOUR_PATTERN = "yyyy-MM-dd'T'HH";
        private static final String DATE_PATTERN = "yyyy-MM-dd";
        private static final String MONTH_PATTERN = "yyyy-MM";
        private static final String YEAR_PATTERN = "yyyy";
        private static final String ALL_PATTERNS = String.format("[%s][%s][%s][%s][%s][%s]", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH", "yyyy-MM-dd", "yyyy-MM", "yyyy");
        private DateTimeFormatter formatter = DateTimeFormatter.ofPattern(ALL_PATTERNS);

        public Time deserialize(Object val) {
            try {
                TemporalAccessor parsed = this.formatter.parse(val.toString());
                boolean supportsYear = true;
                boolean supportsMonth = parsed.isSupported(ChronoField.MONTH_OF_YEAR);
                boolean supportsDay = parsed.isSupported(ChronoField.DAY_OF_MONTH);
                boolean supportsHour = parsed.isSupported(ChronoField.HOUR_OF_DAY);
                boolean supportsMinute = parsed.isSupported(ChronoField.MINUTE_OF_HOUR);
                boolean supportsSecond = parsed.isSupported(ChronoField.SECOND_OF_MINUTE);
                return new Time(LocalDateTime.of(parsed.get(ChronoField.YEAR), supportsMonth ? parsed.get(ChronoField.MONTH_OF_YEAR) : 1, supportsDay ? parsed.get(ChronoField.DAY_OF_MONTH) : 1, supportsHour ? parsed.get(ChronoField.HOUR_OF_DAY) : 0, supportsMinute ? parsed.get(ChronoField.MINUTE_OF_HOUR) : 0, supportsSecond ? parsed.get(ChronoField.SECOND_OF_MINUTE) : 0), supportsYear, supportsMonth, supportsDay, supportsHour, supportsMinute, supportsSecond, time -> val.toString());
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("String must be formatted as " + ALL_PATTERNS);
            }
        }

        public String serialize(Time val) {
            return val.serializer.format(val);
        }
    }
}

