/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.expression;

import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.google.common.base.Preconditions;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.core.JoinPath;
import com.yahoo.elide.datastores.aggregation.metadata.ColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ColumnType;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ColumnArgReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.JoinReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.LogicalReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.PhysicalReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.TableArgReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ExpressionParser {
    private static final Pattern REFERENCE_PARENTHESES = Pattern.compile("\\{\\{\\[?(.+?)\\]?}}");
    private static final String SQL_HELPER_PREFIX = "sql ";
    private static final String COLUMN_ARGS_PREFIX = "$$column.args.";
    private static final String TABLE_ARGS_PREFIX = "$$table.args.";
    private static final String COLUMN_EXPR = "$$column.expr";
    private MetaDataStore metaDataStore;
    private EntityDictionary dictionary;
    private final Handlebars handlebars = new Handlebars().with(EscapingStrategy.NOOP).registerHelper("sql", (context, options) -> {
        String from = (String)options.hash("from");
        String column = (String)options.hash("column");
        return StringUtils.isEmpty((CharSequence)from) ? column : from + "." + column;
    });

    public ExpressionParser(MetaDataStore store) {
        this.dictionary = store.getMetadataDictionary();
        this.metaDataStore = store;
    }

    public List<Reference> parse(Queryable source, ColumnProjection column) {
        return this.parse(source, column.getExpression(), column.getArguments());
    }

    public List<Reference> parse(Queryable source, String expression) {
        return this.parse(source, expression, Collections.emptyMap());
    }

    public List<Reference> parse(Queryable source, String expression, Map<String, Argument> callingColumnArgs) {
        List<String> referenceNames = ExpressionParser.resolveFormulaReferences(expression);
        ArrayList<Reference> results = new ArrayList<Reference>();
        HashMap<String, Argument> fixedArguments = new HashMap();
        for (String referenceName : referenceNames) {
            if (referenceName.startsWith(SQL_HELPER_PREFIX)) {
                try {
                    Template template = this.handlebars.compileInline(ExpressionParser.toFormulaReference(referenceName));
                    referenceName = template.apply(Collections.emptyMap());
                    int argsIndex = referenceName.indexOf(91);
                    if (argsIndex >= 0) {
                        fixedArguments = Argument.getArgumentMapFromString((String)referenceName.substring(argsIndex));
                        referenceName = referenceName.substring(0, argsIndex);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            if (referenceName.equals(COLUMN_EXPR)) continue;
            if (referenceName.startsWith(COLUMN_ARGS_PREFIX)) {
                results.add(ColumnArgReference.builder().argName(referenceName.substring(COLUMN_ARGS_PREFIX.length())).build());
                continue;
            }
            if (referenceName.startsWith(TABLE_ARGS_PREFIX)) {
                results.add(TableArgReference.builder().argName(referenceName.substring(TABLE_ARGS_PREFIX.length())).build());
                continue;
            }
            if (referenceName.startsWith("$")) {
                results.add(PhysicalReference.builder().source(source).name(referenceName.substring(1)).build());
                continue;
            }
            if (referenceName.contains(".")) {
                results.add(this.buildJoin(source, referenceName, callingColumnArgs, fixedArguments));
                continue;
            }
            ColumnProjection referencedColumn = source.getColumnProjection(referenceName);
            Preconditions.checkNotNull((Object)referencedColumn, (Object)String.format("Couldn't find column: '%s' for table: '%s'", referenceName, source.getName()));
            ColumnProjection newColumn = referencedColumn.withArguments(ColumnContext.mergedArgumentMap(referencedColumn.getArguments(), callingColumnArgs, fixedArguments));
            List<Reference> references = this.buildReferenceForColumn(source, newColumn);
            results.add(LogicalReference.builder().source(source).column(newColumn).references(references).build());
        }
        return results;
    }

    private List<Reference> buildReferenceForColumn(Queryable source, ColumnProjection column) {
        if (column.getColumnType() == ColumnType.FIELD) {
            return Arrays.asList(PhysicalReference.builder().source(source).name(column.getName()).build());
        }
        return this.parse(source, column);
    }

    private JoinReference buildJoin(Queryable source, String referenceName, Map<String, Argument> callingColumnArgs, Map<String, Argument> fixedArguments) {
        Reference reference;
        Queryable root = source.getRoot();
        Type tableClass = this.dictionary.getEntityClass(root.getName(), root.getVersion());
        JoinPath joinPath = new JoinPath(tableClass, this.metaDataStore, referenceName);
        Path.PathElement lastElement = (Path.PathElement)joinPath.lastElement().get();
        Queryable joinSource = (Queryable)this.metaDataStore.getTable(lastElement.getType());
        String fieldName = lastElement.getFieldName();
        if (fieldName.startsWith("$")) {
            reference = PhysicalReference.builder().source(joinSource).name(fieldName.substring(1)).build();
        } else {
            ColumnProjection referencedColumn = joinSource.getColumnProjection(fieldName);
            ColumnProjection newColumn = referencedColumn.withArguments(ColumnContext.mergedArgumentMap(referencedColumn.getArguments(), callingColumnArgs, fixedArguments));
            reference = LogicalReference.builder().source(joinSource).column(newColumn).references(this.buildReferenceForColumn(joinSource, newColumn)).build();
        }
        return JoinReference.builder().path(joinPath).source(source).reference(reference).build();
    }

    private static List<String> resolveFormulaReferences(String expression) {
        ArrayList<String> references = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)expression)) {
            Matcher matcher = REFERENCE_PARENTHESES.matcher(expression);
            while (matcher.find()) {
                references.add(matcher.group(1).trim());
            }
        }
        return references;
    }

    private static String toFormulaReference(String reference) {
        return "{{" + reference + "}}";
    }
}

