/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata;

import com.yahoo.elide.core.dictionary.EntityBinding;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.annotation.Join;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ColumnType;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.ArgumentDefinition;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.Dimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.Metric;
import com.yahoo.elide.datastores.aggregation.metadata.models.Namespace;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.metadata.models.TimeDimension;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.MetricProjectionMaker;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.query.TableSQLMaker;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.ConnectionDetails;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromSubquery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromTable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLJoin;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLMetricProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLTimeDimensionProjection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Subselect;

public class SQLTable
extends Table
implements Queryable {
    private ConnectionDetails connectionDetails;
    private Map<String, SQLJoin> joins;
    private Map<String, Argument> arguments;
    private Type<?> cls;

    public SQLTable(Namespace namespace, Type<?> cls, EntityDictionary dictionary, ConnectionDetails connectionDetails) {
        super(namespace, cls, dictionary);
        this.connectionDetails = connectionDetails;
        this.joins = new HashMap<String, SQLJoin>();
        this.cls = cls;
        this.arguments = SQLTable.prepareArgMap(this.getArgumentDefinitions());
        EntityBinding binding = dictionary.getEntityBinding(cls);
        binding.fieldsToValues.forEach((name, field) -> {
            if (field.isAnnotationPresent(Join.class)) {
                Join join = (Join)field.getAnnotation(Join.class);
                this.joins.put((String)name, SQLJoin.builder().name((String)name).joinType(join.type()).joinExpression(join.value()).joinTableType(dictionary.getParameterizedType(cls, name)).toOne(join.toOne()).build());
            }
        });
    }

    public SQLTable(Namespace namespace, Type<?> cls, EntityDictionary dictionary) {
        this(namespace, cls, dictionary, null);
    }

    @Override
    protected Metric constructMetric(String fieldName, EntityDictionary dictionary) {
        if (dictionary.getIdFieldName(this.getModel()).equals(fieldName)) {
            MetricProjectionMaker maker = (metric, alias, arguments) -> SQLMetricProjection.builder().projected(true).alias(fieldName).name(fieldName).expression("").valueType(ValueType.ID).columnType(ColumnType.FIELD).arguments(new HashMap<String, Argument>()).build();
            return new Metric(maker, this, fieldName, dictionary);
        }
        return new Metric(this, fieldName, dictionary);
    }

    @Override
    public Queryable toQueryable() {
        return this;
    }

    @Override
    public MetricProjection getMetricProjection(String fieldName) {
        return this.getMetricProjection(fieldName, Collections.emptyMap());
    }

    public MetricProjection getMetricProjection(String fieldName, String alias) {
        return this.getMetricProjection(fieldName, alias, Collections.emptyMap());
    }

    public MetricProjection getMetricProjection(String fieldName, Map<String, Argument> arguments) {
        return this.getMetricProjection(fieldName, fieldName, arguments);
    }

    public MetricProjection getMetricProjection(String fieldName, String alias, Map<String, Argument> arguments) {
        Metric metric = super.getMetric(fieldName);
        if (metric == null) {
            return null;
        }
        return this.getMetricProjection(metric, alias, arguments);
    }

    public MetricProjection getMetricProjection(Metric metric, String alias, Map<String, Argument> arguments) {
        return metric.getMetricProjectionMaker().make(metric, alias, arguments);
    }

    @Override
    public List<MetricProjection> getMetricProjections() {
        return super.getAllMetrics().stream().map(metric -> this.getMetricProjection((Metric)metric, metric.getName(), SQLTable.prepareArgMap(metric.getArgumentDefinitions()))).collect(Collectors.toList());
    }

    @Override
    public DimensionProjection getDimensionProjection(String fieldName) {
        return this.getDimensionProjection(fieldName, Collections.emptyMap());
    }

    public DimensionProjection getDimensionProjection(String fieldName, String alias) {
        return this.getDimensionProjection(fieldName, alias, Collections.emptyMap());
    }

    public DimensionProjection getDimensionProjection(String fieldName, Map<String, Argument> arguments) {
        return this.getDimensionProjection(fieldName, fieldName, arguments);
    }

    public DimensionProjection getDimensionProjection(String fieldName, String alias, Map<String, Argument> arguments) {
        Dimension dimension = super.getDimension(fieldName);
        if (dimension == null) {
            return null;
        }
        return this.getDimensionProjection(dimension, alias, arguments);
    }

    public DimensionProjection getDimensionProjection(Dimension dimension, String alias, Map<String, Argument> arguments) {
        return new SQLDimensionProjection(dimension, alias, arguments, true);
    }

    @Override
    public List<DimensionProjection> getDimensionProjections() {
        return super.getAllDimensions().stream().map(dimension -> this.getDimensionProjection((Dimension)dimension, dimension.getName(), SQLTable.prepareArgMap(dimension.getArgumentDefinitions()))).collect(Collectors.toList());
    }

    @Override
    public TimeDimensionProjection getTimeDimensionProjection(String fieldName) {
        return this.getTimeDimensionProjection(fieldName, new HashMap<String, Argument>());
    }

    public TimeDimensionProjection getTimeDimensionProjection(String fieldName, Map<String, Argument> arguments) {
        return this.getTimeDimensionProjection(fieldName, fieldName, arguments);
    }

    public TimeDimensionProjection getTimeDimensionProjection(String fieldName, Set<Argument> arguments) {
        Map<String, Argument> argumentMap = arguments.stream().collect(Collectors.toMap(Argument::getName, argument -> argument));
        return this.getTimeDimensionProjection(fieldName, fieldName, argumentMap);
    }

    public TimeDimensionProjection getTimeDimensionProjection(String fieldName, String alias, Map<String, Argument> arguments) {
        TimeDimension dimension = super.getTimeDimension(fieldName);
        if (dimension == null) {
            return null;
        }
        return this.getTimeDimensionProjection(dimension, alias, arguments);
    }

    public TimeDimensionProjection getTimeDimensionProjection(TimeDimension dimension, String alias, Map<String, Argument> arguments) {
        return new SQLTimeDimensionProjection(dimension, dimension.getTimezone(), alias, arguments, true);
    }

    @Override
    public List<TimeDimensionProjection> getTimeDimensionProjections() {
        return super.getAllTimeDimensions().stream().map(dimension -> this.getTimeDimensionProjection((TimeDimension)dimension, dimension.getName(), SQLTable.prepareArgMap(dimension.getArgumentDefinitions()))).collect(Collectors.toList());
    }

    @Override
    public List<ColumnProjection> getColumnProjections() {
        return super.getAllColumns().stream().map(column -> this.getColumnProjection(column.getName())).collect(Collectors.toList());
    }

    @Override
    public ColumnProjection getColumnProjection(String name) {
        Column column = super.getColumn(Column.class, name);
        if (column == null) {
            return null;
        }
        return this.getColumnProjection(column, SQLTable.prepareArgMap(column.getArgumentDefinitions()));
    }

    @Override
    public ColumnProjection getColumnProjection(String name, Map<String, Argument> arguments) {
        Column column = super.getColumn(Column.class, name);
        if (column == null) {
            return null;
        }
        return this.getColumnProjection(column, arguments);
    }

    private ColumnProjection getColumnProjection(Column column, Map<String, Argument> arguments) {
        if (column instanceof TimeDimension) {
            return this.getTimeDimensionProjection((TimeDimension)column, column.getName(), arguments);
        }
        if (column instanceof Metric) {
            return this.getMetricProjection((Metric)column, column.getName(), arguments);
        }
        return this.getDimensionProjection((Dimension)column, column.getName(), arguments);
    }

    @Override
    public SQLJoin getJoin(String joinName) {
        return this.joins.get(joinName);
    }

    public SQLTable getJoinTable(MetaDataStore store, String joinName) {
        SQLJoin join = this.getJoin(joinName);
        if (join == null) {
            return null;
        }
        return (SQLTable)store.getTable(join.getJoinTableType());
    }

    public static boolean isTableJoin(MetaDataStore store, Type<?> modelType, String fieldName) {
        SQLTable table = (SQLTable)store.getTable(modelType);
        return table.getJoinTable(store, fieldName) != null;
    }

    @Override
    public Queryable getSource() {
        return this;
    }

    @Override
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    private static Map<String, Argument> prepareArgMap(Set<ArgumentDefinition> arguments) {
        return arguments.stream().map(arg -> Argument.builder().name(arg.getName()).value(arg.getDefaultValue()).build()).collect(Collectors.toMap(Argument::getName, Function.identity()));
    }

    public static boolean hasSql(Type<?> cls) {
        return cls.isAnnotationPresent(Subselect.class) || cls.isAnnotationPresent(FromSubquery.class);
    }

    public static String resolveTableOrSubselect(EntityDictionary dictionary, Type<?> cls, Query clientQuery) {
        if (SQLTable.hasSql(cls)) {
            if (cls.isAnnotationPresent(FromSubquery.class)) {
                FromSubquery fromSubquery = (FromSubquery)dictionary.getAnnotation(cls, FromSubquery.class);
                if (fromSubquery.maker() != null) {
                    TableSQLMaker maker = (TableSQLMaker)dictionary.getInjector().instantiate(fromSubquery.maker());
                    return maker.make(clientQuery);
                }
                return fromSubquery.sql();
            }
            return ((Subselect)dictionary.getAnnotation(cls, Subselect.class)).value();
        }
        jakarta.persistence.Table table = (jakarta.persistence.Table)dictionary.getAnnotation(cls, jakarta.persistence.Table.class);
        if (table != null) {
            return SQLTable.resolveTableAnnotation(table);
        }
        FromTable fromTable = (FromTable)dictionary.getAnnotation(cls, FromTable.class);
        return fromTable != null ? fromTable.name() : cls.getSimpleName();
    }

    private static String resolveTableAnnotation(jakarta.persistence.Table table) {
        StringBuilder fullTableName = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)table.catalog())) {
            fullTableName.append(table.catalog()).append(".");
        }
        if (StringUtils.isNotBlank((CharSequence)table.schema())) {
            fullTableName.append(table.schema()).append(".");
        }
        return fullTableName.append(table.name()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLTable)) {
            return false;
        }
        SQLTable other = (SQLTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConnectionDetails this$connectionDetails = this.getConnectionDetails();
        ConnectionDetails other$connectionDetails = other.getConnectionDetails();
        if (this$connectionDetails == null ? other$connectionDetails != null : !((Object)this$connectionDetails).equals(other$connectionDetails)) {
            return false;
        }
        Map<String, SQLJoin> this$joins = this.getJoins();
        Map<String, SQLJoin> other$joins = other.getJoins();
        if (this$joins == null ? other$joins != null : !((Object)this$joins).equals(other$joins)) {
            return false;
        }
        Map<String, Argument> this$arguments = this.getArguments();
        Map<String, Argument> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        Type<?> this$cls = this.getCls();
        Type<?> other$cls = other.getCls();
        return !(this$cls == null ? other$cls != null : !this$cls.equals(other$cls));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SQLTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConnectionDetails $connectionDetails = this.getConnectionDetails();
        result = result * 59 + ($connectionDetails == null ? 43 : ((Object)$connectionDetails).hashCode());
        Map<String, SQLJoin> $joins = this.getJoins();
        result = result * 59 + ($joins == null ? 43 : ((Object)$joins).hashCode());
        Map<String, Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        Type<?> $cls = this.getCls();
        result = result * 59 + ($cls == null ? 43 : $cls.hashCode());
        return result;
    }

    @Override
    public ConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    @Override
    public Map<String, SQLJoin> getJoins() {
        return this.joins;
    }

    public Type<?> getCls() {
        return this.cls;
    }
}

