/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.boot.admin")
public class AdminProperties {
    private String[] url;
    private String apiPath = "api/applications";
    private long period = 10000L;
    private int connectTimeout = 5000;
    private int readTimeout = 5000;
    private String username;
    private String password;
    private boolean autoDeregistration;
    private boolean autoRegistration = true;
    private boolean registerOnce = true;

    public void setUrl(String[] url) {
        this.url = (String[])url.clone();
    }

    public String[] getUrl() {
        return (String[])this.url.clone();
    }

    public void setApiPath(String apiPath) {
        this.apiPath = apiPath;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public String[] getAdminUrl() {
        String[] adminUrls = (String[])this.url.clone();
        int i = 0;
        while (i < adminUrls.length) {
            int n = i++;
            adminUrls[n] = adminUrls[n] + "/" + this.apiPath;
        }
        return adminUrls;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAutoDeregistration() {
        return this.autoDeregistration;
    }

    public void setAutoDeregistration(boolean autoDeregistration) {
        this.autoDeregistration = autoDeregistration;
    }

    public boolean isAutoRegistration() {
        return this.autoRegistration;
    }

    public void setAutoRegistration(boolean autoRegistration) {
        this.autoRegistration = autoRegistration;
    }

    public boolean isRegisterOnce() {
        return this.registerOnce;
    }

    public void setRegisterOnce(boolean registerOnce) {
        this.registerOnce = registerOnce;
    }
}

