/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.config;

import de.codecentric.boot.admin.server.config.AdminServerMarkerConfiguration;
import de.codecentric.boot.admin.server.config.AdminServerProperties;
import de.codecentric.boot.admin.server.config.AdminServerWebConfiguration;
import de.codecentric.boot.admin.server.notify.filter.web.NotificationFilterController;
import de.codecentric.boot.admin.server.ui.config.AdminServerUiProperties;
import de.codecentric.boot.admin.server.ui.extensions.UiExtension;
import de.codecentric.boot.admin.server.ui.extensions.UiExtensionsScanner;
import de.codecentric.boot.admin.server.ui.extensions.UiRoutesScanner;
import de.codecentric.boot.admin.server.ui.web.UiController;
import de.codecentric.boot.admin.server.ui.web.reactive.HomepageForwardingFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templatemode.TemplateMode;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={AdminServerMarkerConfiguration.Marker.class})
@AutoConfigureAfter(value={AdminServerWebConfiguration.class})
@EnableConfigurationProperties(value={AdminServerUiProperties.class})
public class AdminServerUiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AdminServerUiAutoConfiguration.class);
    private static final List<String> DEFAULT_UI_ROUTES = Arrays.asList("/about/**", "/applications/**", "/instances/**", "/journal/**", "/wallboard/**", "/external/**");
    private final AdminServerUiProperties adminUi;
    private final AdminServerProperties adminServer;
    private final ApplicationContext applicationContext;

    public AdminServerUiAutoConfiguration(AdminServerUiProperties adminUi, AdminServerProperties serverProperties, ApplicationContext applicationContext) {
        this.adminUi = adminUi;
        this.adminServer = serverProperties;
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public UiController homeUiController() throws IOException {
        List<String> extensionRoutes = new UiRoutesScanner((ResourcePatternResolver)this.applicationContext).scan(this.adminUi.getExtensionResourceLocations());
        List<String> routes = Stream.concat(DEFAULT_UI_ROUTES.stream(), extensionRoutes.stream()).collect(Collectors.toList());
        UiController.Settings uiSettings = UiController.Settings.builder().brand(this.adminUi.getBrand()).title(this.adminUi.getTitle()).loginIcon(this.adminUi.getLoginIcon()).favicon(this.adminUi.getFavicon()).faviconDanger(this.adminUi.getFaviconDanger()).notificationFilterEnabled(!this.applicationContext.getBeansOfType(NotificationFilterController.class).isEmpty()).routes(routes).rememberMeEnabled(this.adminUi.isRememberMeEnabled()).externalViews(this.adminUi.getExternalViews()).build();
        String publicUrl = this.adminUi.getPublicUrl() != null ? this.adminUi.getPublicUrl() : this.adminServer.getContextPath();
        return new UiController(publicUrl, this.uiExtensions(), uiSettings);
    }

    private List<UiExtension> uiExtensions() throws IOException {
        UiExtensionsScanner scanner = new UiExtensionsScanner((ResourcePatternResolver)this.applicationContext);
        List<UiExtension> uiExtensions = scanner.scan(this.adminUi.getExtensionResourceLocations());
        uiExtensions.forEach(e -> log.info("Loaded Spring Boot Admin UI Extension: {}", e));
        return uiExtensions;
    }

    @Bean
    public SpringResourceTemplateResolver adminTemplateResolver() {
        SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
        resolver.setApplicationContext(this.applicationContext);
        resolver.setPrefix(this.adminUi.getTemplateLocation());
        resolver.setSuffix(".html");
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resolver.setCacheable(this.adminUi.isCacheTemplates());
        resolver.setOrder(Integer.valueOf(10));
        resolver.setCheckExistence(true);
        return resolver;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletUiConfiguration {

        @Configuration(proxyBeanMethods=false)
        public static class AdminUiWebMvcConfig
        implements WebMvcConfigurer {
            private final AdminServerUiProperties adminUi;
            private final AdminServerProperties adminServer;
            private final ApplicationContext applicationContext;

            public AdminUiWebMvcConfig(AdminServerUiProperties adminUi, AdminServerProperties adminServer, ApplicationContext applicationContext) {
                this.adminUi = adminUi;
                this.adminServer = adminServer;
                this.applicationContext = applicationContext;
            }

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{this.adminServer.path("/**")}).addResourceLocations(this.adminUi.getResourceLocations()).addResourceLocations(this.adminUi.getExtensionResourceLocations()).setCacheControl(this.adminUi.getCache().toCacheControl());
            }

            @Bean
            @ConditionalOnMissingBean
            public de.codecentric.boot.admin.server.ui.web.servlet.HomepageForwardingFilter homepageForwardFilter() throws IOException {
                List<String> extensionRoutes = new UiRoutesScanner((ResourcePatternResolver)this.applicationContext).scan(this.adminUi.getExtensionResourceLocations());
                List<String> routes = Stream.concat(DEFAULT_UI_ROUTES.stream(), extensionRoutes.stream()).map(arg_0 -> ((AdminServerProperties)this.adminServer).path(arg_0)).collect(Collectors.toList());
                String homepage = this.adminServer.path("/");
                return new de.codecentric.boot.admin.server.ui.web.servlet.HomepageForwardingFilter(homepage, routes);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class ReactiveUiConfiguration {

        @Configuration(proxyBeanMethods=false)
        public static class AdminUiWebfluxConfig
        implements WebFluxConfigurer {
            private final AdminServerUiProperties adminUi;
            private final AdminServerProperties adminServer;
            private final ApplicationContext applicationContext;

            public AdminUiWebfluxConfig(AdminServerUiProperties adminUi, AdminServerProperties adminServer, ApplicationContext applicationContext) {
                this.adminUi = adminUi;
                this.adminServer = adminServer;
                this.applicationContext = applicationContext;
            }

            public void addResourceHandlers(org.springframework.web.reactive.config.ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{this.adminServer.path("/**")}).addResourceLocations(this.adminUi.getResourceLocations()).addResourceLocations(this.adminUi.getExtensionResourceLocations()).setCacheControl(this.adminUi.getCache().toCacheControl());
            }

            @Bean
            @ConditionalOnMissingBean
            public HomepageForwardingFilter homepageForwardFilter() throws IOException {
                List<String> extensionRoutes = new UiRoutesScanner((ResourcePatternResolver)this.applicationContext).scan(this.adminUi.getExtensionResourceLocations());
                List<String> routes = Stream.concat(DEFAULT_UI_ROUTES.stream(), extensionRoutes.stream()).map(arg_0 -> ((AdminServerProperties)this.adminServer).path(arg_0)).collect(Collectors.toList());
                String homepage = this.adminServer.path("/");
                return new HomepageForwardingFilter(homepage, routes);
            }
        }
    }
}

