/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.embed.process.io.ConsoleOutputStreamProcessor;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LoggingOutputStreamProcessor;
import de.flapdoodle.embed.process.io.NamedOutputStreamProcessor;
import de.flapdoodle.embed.process.io.ReaderProcessor;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Processors {
    private Processors() {
        throw new IllegalAccessError("singleton");
    }

    public static IStreamProcessor console() {
        return new ConsoleOutputStreamProcessor();
    }

    public static IStreamProcessor named(String name, IStreamProcessor destination) {
        return new NamedOutputStreamProcessor(name, destination);
    }

    public static IStreamProcessor namedConsole(String name) {
        return Processors.named(name, Processors.console());
    }

    public static IStreamProcessor logTo(Logger logger, Level level) {
        return new LoggingOutputStreamProcessor(logger, level);
    }

    public static ReaderProcessor connect(Reader reader, IStreamProcessor processor) {
        return new ReaderProcessor(reader, processor);
    }
}

