/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.exceptions.DistributionException;
import de.flapdoodle.embed.process.extract.Extractors;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.store.Downloader;
import de.flapdoodle.embed.process.store.LocalArtifactStore;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Starter<CONFIG extends ExecutableProcessConfig, EXECUTABLE extends Executable<CONFIG, PROCESS>, PROCESS extends IStopable> {
    private static Logger logger = Logger.getLogger(Starter.class.getName());
    private final IRuntimeConfig runtime;

    protected Starter(IRuntimeConfig config) {
        this.runtime = config;
    }

    protected boolean checkDistribution(Distribution distribution) throws IOException {
        IDownloadConfig downloadConfig = this.runtime.getDownloadConfig();
        if (!LocalArtifactStore.checkArtifact(downloadConfig, distribution)) {
            return LocalArtifactStore.store(downloadConfig, distribution, Downloader.download(downloadConfig, distribution));
        }
        return true;
    }

    public EXECUTABLE prepare(CONFIG config) {
        IProgressListener progress = this.runtime.getDownloadConfig().getProgressListener();
        Distribution distribution = Distribution.detectFor(((ExecutableProcessConfig)config).getVersion());
        progress.done("Detect Distribution");
        try {
            if (this.checkDistribution(distribution)) {
                progress.done("Check Distribution");
                File exe = this.extractExe(distribution);
                return this.newExecutable(config, distribution, this.runtime, exe);
            }
            throw new DistributionException("could not find Distribution", distribution);
        }
        catch (IOException iox) {
            logger.log(Level.SEVERE, "start", iox);
            throw new DistributionException(distribution, (Throwable)iox);
        }
    }

    protected File extractExe(Distribution distribution) throws IOException {
        IDownloadConfig downloadConfig = this.runtime.getDownloadConfig();
        IPackageResolver packageResolver = downloadConfig.getPackageResolver();
        File artifact = LocalArtifactStore.getArtifact(downloadConfig, distribution);
        IExtractor extractor = Extractors.getExtractor(packageResolver.getArchiveType(distribution));
        File exe = Files.createTempFile(this.runtime.getTempDirFactory(), this.runtime.getExecutableNaming().nameFor("extract", packageResolver.executableFilename(distribution)));
        extractor.extract(downloadConfig, artifact, exe, packageResolver.executeablePattern(distribution));
        return exe;
    }

    protected abstract EXECUTABLE newExecutable(CONFIG var1, Distribution var2, IRuntimeConfig var3, File var4);
}

