/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.runtime.Processes;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractProcess<T extends IExecutableProcessConfig, E extends Executable<T, P>, P extends IStopable>
implements IStopable {
    private static Logger logger = Logger.getLogger(AbstractProcess.class.getName());
    public static final int TIMEOUT = 20000;
    private final T config;
    private final IRuntimeConfig runtimeConfig;
    private final E executable;
    private ProcessControl process;
    private int processId;
    protected File pidFile;
    private boolean stopped = false;
    private Distribution distribution;

    public AbstractProcess(Distribution distribution, T config, IRuntimeConfig runtimeConfig, E executable) throws IOException {
        this.config = config;
        this.runtimeConfig = runtimeConfig;
        this.executable = executable;
        this.distribution = distribution;
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        try {
            this.onBeforeProcess(runtimeConfig);
            ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(runtimeConfig.getCommandLinePostProcessor().process(distribution, this.getCommandLine(distribution, config, ((Executable)this.executable).getFile())), this.getEnvironment(distribution, config, ((Executable)this.executable).getFile()), true);
            this.onBeforeProcessStart(processBuilder, config, runtimeConfig);
            this.process = ProcessControl.start(this.supportConfig(), processBuilder);
            if (runtimeConfig.isDaemonProcess()) {
                ProcessControl.addShutdownHook(new JobKiller());
            }
            this.onAfterProcessStart(this.process, runtimeConfig);
        }
        catch (IOException iox) {
            logger.severe(iox.getMessage());
            logger.logp(Level.INFO, this.getClass().getSimpleName(), "ctor", config.toString());
            this.stop();
            throw iox;
        }
    }

    public T getConfig() {
        return this.config;
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
    }

    protected void onBeforeProcessStart(ProcessBuilder processBuilder, T config, IRuntimeConfig runtimeConfig) {
    }

    protected void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        Processors.connect(process.getReader(), outputConfig.getOutput());
        Processors.connect(process.getError(), StreamToLineProcessor.wrap(outputConfig.getError()));
    }

    protected abstract List<String> getCommandLine(Distribution var1, T var2, IExtractedFileSet var3) throws IOException;

    protected Map<String, String> getEnvironment(Distribution distribution, T config, IExtractedFileSet exe) {
        return new HashMap<String, String>();
    }

    protected abstract ISupportConfig supportConfig();

    @Override
    public final synchronized void stop() {
        if (!this.stopped) {
            this.stopped = true;
            this.stopInternal();
            this.onAfterProcessStop(this.config, this.runtimeConfig);
            this.cleanupInternal();
        }
    }

    protected abstract void stopInternal();

    protected abstract void cleanupInternal();

    protected void onAfterProcessStop(T config, IRuntimeConfig runtimeConfig) {
    }

    protected final void stopProcess() {
        if (this.process != null) {
            this.process.stop();
        }
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    protected void setProcessId(int processId) {
        this.processId = processId;
    }

    protected boolean sendKillToProcess() {
        if (this.processId > 0) {
            return Processes.killProcess(this.supportConfig(), this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.runtimeConfig.getProcessOutput().getCommands()), this.processId);
        }
        return false;
    }

    protected boolean sendTermToProcess() {
        if (this.processId > 0) {
            return Processes.termProcess(this.supportConfig(), this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.runtimeConfig.getProcessOutput().getCommands()), this.processId);
        }
        return false;
    }

    protected boolean tryKillToProcess() {
        if (this.processId > 0) {
            return Processes.tryKillProcess(this.supportConfig(), this.distribution.getPlatform(), StreamToLineProcessor.wrap(this.runtimeConfig.getProcessOutput().getCommands()), this.processId);
        }
        return false;
    }

    public boolean isProcessRunning() {
        if (this.getProcessId() > 0) {
            return Processes.isProcessRunning(this.distribution.getPlatform(), this.getProcessId());
        }
        return false;
    }

    public int getProcessId() {
        return this.processId;
    }

    protected static int getPidFromFile(File pidFile) throws IOException {
        int tries;
        for (tries = 0; !pidFile.exists() && tries < 5; ++tries) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            logger.warning("Didn't find pid file in try " + tries + ", waiting 100ms...");
        }
        if (!pidFile.exists()) {
            throw new IOException("Could not find pid file " + pidFile);
        }
        String fileContent = StringUtils.chomp((String)StringUtils.strip((String)FileUtils.readFileToString((File)pidFile)));
        for (tries = 0; StringUtils.isBlank((CharSequence)fileContent) && tries < 5; ++tries) {
            fileContent = StringUtils.chomp((String)StringUtils.strip((String)FileUtils.readFileToString((File)pidFile)));
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((CharSequence)fileContent)) {
            throw new IOException("Pidfile " + pidFile + "does not contain a pid. Waited for " + tries * 100 + "ms.");
        }
        try {
            return Integer.parseInt(fileContent);
        }
        catch (NumberFormatException e) {
            throw new IOException("Pidfile " + pidFile + "does not contain a valid pid. Content: " + fileContent);
        }
    }

    protected void forceWritePidFile(int pid) throws IOException {
        Files.write(pid + "\n", this.pidFile);
    }

    class JobKiller
    implements Runnable {
        JobKiller() {
        }

        @Override
        public void run() {
            AbstractProcess.this.stop();
        }
    }
}

