/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.ITimeoutConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class Downloader {
    static final int DEFAULT_CONTENT_LENGTH = 0x1400000;
    static final int BUFFER_LENGTH = 65536;
    static final int READ_COUNT_MULTIPLIER = 100;

    private Downloader() {
    }

    public static String getDownloadUrl(IDownloadConfig runtime, Distribution distribution) {
        return runtime.getDownloadPath().getPath(distribution) + runtime.getPackageResolver().getPath(distribution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File download(IDownloadConfig runtime, Distribution distribution) throws IOException {
        String progressLabel = "Download " + distribution;
        IProgressListener progress = runtime.getProgressListener();
        progress.start(progressLabel);
        File ret = Files.createTempFile(runtime.getFileNaming().nameFor(runtime.getDownloadPrefix(), "." + (Object)((Object)runtime.getPackageResolver().getArchiveType(distribution))));
        if (ret.canWrite()) {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(ret));
            URL url = new URL(Downloader.getDownloadUrl(runtime, distribution));
            URLConnection openConnection = url.openConnection();
            openConnection.setRequestProperty("User-Agent", runtime.getUserAgent());
            ITimeoutConfig timeoutConfig = runtime.getTimeoutConfig();
            openConnection.setConnectTimeout(timeoutConfig.getConnectionTimeout());
            openConnection.setReadTimeout(runtime.getTimeoutConfig().getReadTimeout());
            InputStream downloadStream = openConnection.getInputStream();
            long length = openConnection.getContentLength();
            progress.info(progressLabel, "DownloadSize: " + length);
            if (length == -1L) {
                length = 0x1400000L;
            }
            long downloadStartedAt = System.currentTimeMillis();
            try {
                BufferedInputStream bis = new BufferedInputStream(downloadStream);
                byte[] buf = new byte[65536];
                int read = 0;
                long readCount = 0L;
                while ((read = bis.read(buf)) != -1) {
                    bos.write(buf, 0, read);
                    if ((readCount += (long)read) > length) {
                        length = readCount;
                    }
                    progress.progress(progressLabel, (int)(readCount * 100L / length));
                }
                progress.info(progressLabel, "downloaded with " + Downloader.downloadSpeed(downloadStartedAt, length));
            }
            finally {
                downloadStream.close();
                bos.flush();
                bos.close();
            }
        } else {
            throw new IOException("Can not write " + ret);
        }
        progress.done(progressLabel);
        return ret;
    }

    private static String downloadSpeed(long downloadStartedAt, long downloadSize) {
        long timeUsed = (System.currentTimeMillis() - downloadStartedAt) / 1000L;
        if (timeUsed == 0L) {
            timeUsed = 1L;
        }
        long kbPerSecond = downloadSize / (timeUsed * 1024L);
        return "" + kbPerSecond + "kb/s";
    }
}

