/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.IProperty;
import de.flapdoodle.embed.process.builder.ImmutableContainer;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.store.DownloadPath;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IDownloadPath;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.config.store.ITimeoutConfig;
import de.flapdoodle.embed.process.config.store.TimeoutConfigBuilder;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.progress.IProgressListener;

public class DownloadConfigBuilder
extends AbstractBuilder<IDownloadConfig> {
    private static final TypedProperty<UserAgent> USER_AGENT = TypedProperty.with("UserAgent", UserAgent.class);
    private static final TypedProperty<IProgressListener> PROGRESS_LISTENER = TypedProperty.with("ProgressListener", IProgressListener.class);
    private static final TypedProperty<ITempNaming> FILE_NAMING = TypedProperty.with("FileNaming", ITempNaming.class);
    private static final TypedProperty<IDirectory> ARTIFACT_STORE_PATH = TypedProperty.with("ArtifactStorePath", IDirectory.class);
    private static final TypedProperty<IPackageResolver> PACKAGE_RESOLVER = TypedProperty.with("PackageResolver", IPackageResolver.class);
    private static final TypedProperty<DownloadPrefix> DOWNLOAD_PREFIX = TypedProperty.with("DownloadPrefix", DownloadPrefix.class);
    private static final TypedProperty<IDownloadPath> DOWNLOAD_PATH = TypedProperty.with("DownloadPath", IDownloadPath.class);
    private static final TypedProperty<ITimeoutConfig> TIMEOUT_CONFIG = TypedProperty.with("TimeoutConfig", ITimeoutConfig.class);

    public DownloadConfigBuilder() {
        this.setDefault(TIMEOUT_CONFIG, new TimeoutConfigBuilder().defaults().build());
    }

    public DownloadConfigBuilder downloadPath(String path) {
        this.set(DOWNLOAD_PATH, new DownloadPath(path));
        return this;
    }

    protected IProperty<IDownloadPath> downloadPath() {
        return this.property(DOWNLOAD_PATH);
    }

    public DownloadConfigBuilder downloadPrefix(String prefix) {
        this.set(DOWNLOAD_PREFIX, new DownloadPrefix(prefix));
        return this;
    }

    protected IProperty<DownloadPrefix> downloadPrefix() {
        return this.property(DOWNLOAD_PREFIX);
    }

    public DownloadConfigBuilder packageResolver(IPackageResolver packageResolver) {
        this.set(PACKAGE_RESOLVER, packageResolver);
        return this;
    }

    protected IProperty<IPackageResolver> packageResolver() {
        return this.property(PACKAGE_RESOLVER);
    }

    public DownloadConfigBuilder artifactStorePath(IDirectory artifactStorePath) {
        this.set(ARTIFACT_STORE_PATH, artifactStorePath);
        return this;
    }

    protected IProperty<IDirectory> artifactStorePath() {
        return this.property(ARTIFACT_STORE_PATH);
    }

    public DownloadConfigBuilder fileNaming(ITempNaming fileNaming) {
        this.set(FILE_NAMING, fileNaming);
        return this;
    }

    protected IProperty<ITempNaming> fileNaming() {
        return this.property(FILE_NAMING);
    }

    public DownloadConfigBuilder progressListener(IProgressListener progressListener) {
        this.set(PROGRESS_LISTENER, progressListener);
        return this;
    }

    protected IProperty<IProgressListener> progressListener() {
        return this.property(PROGRESS_LISTENER);
    }

    public DownloadConfigBuilder userAgent(String userAgent) {
        this.set(USER_AGENT, new UserAgent(userAgent));
        return this;
    }

    protected IProperty<UserAgent> userAgent() {
        return this.property(USER_AGENT);
    }

    public DownloadConfigBuilder timeoutConfig(ITimeoutConfig timeoutConfig) {
        this.set(TIMEOUT_CONFIG, timeoutConfig);
        return this;
    }

    protected IProperty<ITimeoutConfig> timeoutConfig() {
        return this.property(TIMEOUT_CONFIG);
    }

    @Override
    public IDownloadConfig build() {
        IDownloadPath downloadPath = this.get(DOWNLOAD_PATH);
        String downloadPrefix = (String)this.get(DOWNLOAD_PREFIX).value();
        IPackageResolver packageResolver = this.get(PACKAGE_RESOLVER);
        IDirectory artifactStorePath = this.get(ARTIFACT_STORE_PATH);
        ITempNaming fileNaming = this.get(FILE_NAMING);
        IProgressListener progressListener = this.get(PROGRESS_LISTENER);
        String userAgent = (String)this.get(USER_AGENT).value();
        ITimeoutConfig timeoutConfig = this.get(TIMEOUT_CONFIG);
        return new ImmutableDownloadConfig(downloadPath, downloadPrefix, packageResolver, artifactStorePath, fileNaming, progressListener, userAgent, timeoutConfig);
    }

    protected static class ImmutableDownloadConfig
    implements IDownloadConfig {
        private final IDownloadPath _downloadPath;
        private final IProgressListener _progressListener;
        private final IDirectory _artifactStorePath;
        private final ITempNaming _fileNaming;
        private final String _downloadPrefix;
        private final String _userAgent;
        private final IPackageResolver _packageResolver;
        private final ITimeoutConfig _timeoutConfig;

        public ImmutableDownloadConfig(IDownloadPath downloadPath, String downloadPrefix, IPackageResolver packageResolver, IDirectory artifactStorePath, ITempNaming fileNaming, IProgressListener progressListener, String userAgent, ITimeoutConfig timeoutConfig) {
            this._downloadPath = downloadPath;
            this._downloadPrefix = downloadPrefix;
            this._packageResolver = packageResolver;
            this._artifactStorePath = artifactStorePath;
            this._fileNaming = fileNaming;
            this._progressListener = progressListener;
            this._userAgent = userAgent;
            this._timeoutConfig = timeoutConfig;
        }

        @Override
        public IDownloadPath getDownloadPath() {
            return this._downloadPath;
        }

        @Override
        public IProgressListener getProgressListener() {
            return this._progressListener;
        }

        @Override
        public IDirectory getArtifactStorePath() {
            return this._artifactStorePath;
        }

        @Override
        public ITempNaming getFileNaming() {
            return this._fileNaming;
        }

        @Override
        public String getDownloadPrefix() {
            return this._downloadPrefix;
        }

        @Override
        public String getUserAgent() {
            return this._userAgent;
        }

        @Override
        public IPackageResolver getPackageResolver() {
            return this._packageResolver;
        }

        @Override
        public ITimeoutConfig getTimeoutConfig() {
            return this._timeoutConfig;
        }
    }

    protected static class UserAgent
    extends ImmutableContainer<String> {
        public UserAgent(String value) {
            super(value);
        }
    }

    protected static class DownloadPrefix
    extends ImmutableContainer<String> {
        public DownloadPrefix(String value) {
            super(value);
        }
    }
}

