/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import de.plushnikov.intellij.lombok.extension.ExtensionRegister;
import de.plushnikov.intellij.lombok.extension.LombokExtensionRegisterFactory;
import org.jetbrains.annotations.NotNull;

public class LombokLoader
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)LombokLoader.class.getName());

    @NotNull
    public String getComponentName() {
        return "Lombok plugin for IntelliJ";
    }

    public void initComponent() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        LOG.info("Lombok plugin started for IntelliJ IDEA " + buildNumber.asString());
        ExtensionRegister extensionRegister = LombokExtensionRegisterFactory.getInstance();
        extensionRegister.registerRenameHandler();
        extensionRegister.registerTreeHandler();
    }

    public void disposeComponent() {
        ExtensionRegister extensionRegister = LombokExtensionRegisterFactory.getInstance();
        extensionRegister.unregisterRenameHandler();
        extensionRegister.unregisterTreeHandler();
    }
}

