/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.provider;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.augment.PsiAugmentProvider;
import de.plushnikov.intellij.lombok.UserMapKeys;
import de.plushnikov.intellij.lombok.processor.clazz.LombokClassProcessor;
import de.plushnikov.intellij.lombok.processor.field.LombokFieldProcessor;
import de.plushnikov.intellij.lombok.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.core.GenericServiceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LombokAugmentProvider
extends PsiAugmentProvider {
    private static final Logger LOG = Logger.getInstance((String)LombokAugmentProvider.class.getName());
    private final Collection<LombokFieldProcessor> allFieldHandlers;
    private final Collection<LombokClassProcessor> allClassHandlers;

    public LombokAugmentProvider() {
        List<LombokClassProcessor> list = GenericServiceLocator.locateAll(LombokClassProcessor.class);
        List<LombokFieldProcessor> list2 = GenericServiceLocator.locateAll(LombokFieldProcessor.class);
        this.allClassHandlers = new HashSet<LombokClassProcessor>(list);
        this.allFieldHandlers = new HashSet<LombokFieldProcessor>(list2);
    }

    @NotNull
    public <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement psiElement, @NotNull Class<Psi> clazz) {
        List list = Collections.emptyList();
        if (!(psiElement instanceof PsiClass) || !psiElement.isValid()) {
            return list;
        }
        if (DumbService.getInstance((Project)psiElement.getProject()).isDumb()) {
            return list;
        }
        list = new ArrayList();
        PsiClass psiClass = (PsiClass)psiElement;
        if (clazz.isAssignableFrom(PsiField.class)) {
            LOG.info("collect field of class: " + psiClass.getQualifiedName());
            this.processPsiClassAnnotations(list, psiClass, clazz);
        } else if (clazz.isAssignableFrom(PsiMethod.class)) {
            LOG.info("collect methods of class: " + psiClass.getQualifiedName());
            this.cleanAttributeUsage(psiClass);
            this.processPsiClassAnnotations(list, psiClass, clazz);
            this.processPsiClassFieldAnnotation(list, psiClass, clazz);
        }
        return list;
    }

    protected void cleanAttributeUsage(PsiClass psiClass) {
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern((PsiClass)psiClass)) {
            UserMapKeys.removeAllUsagesFrom((UserDataHolder)psiField);
        }
    }

    private <Psi extends PsiElement> void processPsiClassAnnotations(@NotNull List<Psi> list, @NotNull PsiClass psiClass, @NotNull Class<Psi> clazz) {
        PsiModifierList psiModifierList = psiClass.getModifierList();
        if (psiModifierList != null) {
            for (PsiAnnotation psiAnnotation : psiModifierList.getAnnotations()) {
                this.processClassAnnotation(psiAnnotation, psiClass, list, clazz);
            }
        }
    }

    private <Psi extends PsiElement> void processClassAnnotation(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull List<Psi> list, @NotNull Class<Psi> clazz) {
        for (LombokClassProcessor lombokClassProcessor : this.allClassHandlers) {
            if (!lombokClassProcessor.acceptAnnotation(psiAnnotation, clazz)) continue;
            lombokClassProcessor.process(psiClass, psiAnnotation, list);
        }
    }

    protected <Psi extends PsiElement> void processPsiClassFieldAnnotation(@NotNull List<Psi> list, @NotNull PsiClass psiClass, @NotNull Class<Psi> clazz) {
        for (PsiField psiField : psiClass.getFields()) {
            this.processField(list, psiField, clazz);
        }
    }

    protected <Psi extends PsiElement> void processField(@NotNull List<Psi> list, @NotNull PsiField psiField, @NotNull Class<Psi> clazz) {
        PsiModifierList psiModifierList = psiField.getModifierList();
        if (psiModifierList != null) {
            for (PsiAnnotation psiAnnotation : psiModifierList.getAnnotations()) {
                this.processFieldAnnotation(psiAnnotation, psiField, list, clazz);
            }
        }
    }

    private <Psi extends PsiElement> void processFieldAnnotation(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull List<Psi> list, @NotNull Class<Psi> clazz) {
        for (LombokFieldProcessor lombokFieldProcessor : this.allFieldHandlers) {
            if (!lombokFieldProcessor.acceptAnnotation(psiAnnotation, clazz)) continue;
            lombokFieldProcessor.process(psiField, psiAnnotation, list);
        }
    }
}

