/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import de.sormuras.junit.platform.maven.plugin.MojoHelper;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class SurefireMigrationSupport {
    private final JUnitPlatformMojo mojo;
    private final MavenSession session;

    SurefireMigrationSupport(JUnitPlatformMojo mojo, MavenSession session) {
        this.mojo = mojo;
        this.session = session;
    }

    void apply(Plugin surefirePlugin, Plugin junitPlugin) {
        String support = System.getProperty("junit-platform.surefire.migration.support", "true");
        if (!Boolean.parseBoolean(support)) {
            return;
        }
        Object configuration = surefirePlugin.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
        }
        if (!(configuration instanceof Xpp3Dom)) {
            this.mojo.warn("Surefire configuration is not a Xpp3Dom, skipping migration: {0}", configuration);
            return;
        }
        Xpp3Dom surefireConfiguration = (Xpp3Dom)configuration;
        Optional.ofNullable(surefireConfiguration.getChild("systemPropertyVariables")).filter(it -> it.getChildCount() > 0).ifPresent(it -> this.migrateSystemPropertyVariables((Xpp3Dom)it, junitPlugin));
        Optional.ofNullable(surefireConfiguration.getChild("environmentVariables")).filter(it -> it.getChildCount() > 0).ifPresent(it -> this.migrateEnvironmentVariables((Xpp3Dom)it, junitPlugin));
        Optional.ofNullable(surefireConfiguration.getChild("skip")).map(skip -> {
            this.setSkip(junitPlugin, skip.getValue());
            return null;
        }).orElseGet(() -> {
            MojoHelper helper = new MojoHelper(this.mojo, this.session, new MojoExecution(new MojoDescriptor(), surefireConfiguration));
            boolean skipTests = Boolean.parseBoolean(helper.evaluateProperty("${skipTests}"));
            if (!skipTests) {
                skipTests = Boolean.parseBoolean(helper.evaluateProperty("${maven.test.skip}"));
            }
            this.setSkip(junitPlugin, Boolean.toString(skipTests));
            return null;
        });
        String debug = System.getProperty("maven.surefire.debug");
        if (debug != null) {
            Xpp3Dom targetConfig = SurefireMigrationSupport.enforceConfiguration(junitPlugin);
            Xpp3Dom javaOptions = SurefireMigrationSupport.getOrCreateChild(targetConfig, "javaOptions");
            Xpp3Dom debugTag = javaOptions.getChild("debug");
            if (debugTag == null) {
                debugTag = new Xpp3Dom("debug");
                javaOptions.addChild(debugTag);
            }
            debugTag.setValue(debug);
        }
    }

    private void setSkip(Plugin junitPlugin, String value) {
        Xpp3Dom skip = SurefireMigrationSupport.getOrCreateChild(SurefireMigrationSupport.enforceConfiguration(junitPlugin), "skip");
        skip.setValue(value);
    }

    private void migrateSystemPropertyVariables(Xpp3Dom dom, Plugin junitPlugin) {
        Xpp3Dom targetConfig = SurefireMigrationSupport.enforceConfiguration(junitPlugin);
        Xpp3Dom javaOptions = SurefireMigrationSupport.getOrCreateChild(targetConfig, "javaOptions");
        Xpp3Dom additionalOptions = SurefireMigrationSupport.getOrCreateChild(javaOptions, "additionalOptions");
        Stream.of(dom.getChildren()).map(it -> {
            Xpp3Dom option = new Xpp3Dom("additionalOption");
            option.setValue("-D" + it.getName() + "=" + it.getValue());
            return option;
        }).forEach(arg_0 -> ((Xpp3Dom)additionalOptions).addChild(arg_0));
    }

    private void migrateEnvironmentVariables(Xpp3Dom dom, Plugin junitPlugin) {
        Xpp3Dom targetConfig = SurefireMigrationSupport.enforceConfiguration(junitPlugin);
        Xpp3Dom additionalEnvironment = SurefireMigrationSupport.getOrCreateChild(targetConfig, "additionalEnvironment");
        Stream.of(dom.getChildren()).forEach(arg_0 -> ((Xpp3Dom)additionalEnvironment).addChild(arg_0));
    }

    private static Xpp3Dom enforceConfiguration(Plugin plugin) {
        Xpp3Dom targetConfig = (Xpp3Dom)plugin.getConfiguration();
        if (targetConfig == null) {
            targetConfig = new Xpp3Dom("configuration");
            plugin.setConfiguration((Object)targetConfig);
        }
        return targetConfig;
    }

    private static Xpp3Dom getOrCreateChild(Xpp3Dom parent, String name) {
        Xpp3Dom child = parent.getChild(name);
        if (child == null) {
            child = new Xpp3Dom(name);
            parent.addChild(child);
        }
        return child;
    }
}

