/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.services.container;

import java.net.URL;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.dentaku.services.container.ContainerException;
import org.dentaku.services.exception.DentakuException;

public class ContainerManager {
    protected Embedder container;
    private static ContainerManager instance;

    public static ContainerManager getInstance() throws ContainerException {
        if (instance == null) {
            instance = new ContainerManager();
        }
        return instance;
    }

    public static void setInstance(ContainerManager instance) {
        ContainerManager.instance = instance;
    }

    public Embedder getContainer() {
        return this.container;
    }

    public Object lookup(String key) throws ComponentLookupException {
        return this.container.lookup(key);
    }

    public void dispose() throws Exception {
        this.container.stop();
        instance = null;
    }

    public static ContainerManager getContainerManager(URL configurationStream) throws DentakuException {
        ContainerManager containerManager = new ContainerManager();
        if (containerManager.container == null) {
            Embedder container = new Embedder();
            try {
                container.setConfiguration(configurationStream);
                container.start();
            }
            catch (Exception e) {
                throw new DentakuException(e);
            }
            containerManager.container = container;
        }
        return containerManager;
    }
}

