/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.ImageGenerationData;
import com.azure.ai.openai.models.ImageGenerationOptions;
import com.azure.ai.openai.models.ImageGenerationQuality;
import com.azure.ai.openai.models.ImageGenerationResponseFormat;
import com.azure.ai.openai.models.ImageGenerationStyle;
import com.azure.ai.openai.models.ImageGenerations;
import com.azure.ai.openai.models.ImageSize;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.ProxyOptions;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.azure.InternalAzureOpenAiHelper;
import dev.langchain4j.model.azure.spi.AzureOpenAiImageModelBuilderFactory;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureOpenAiImageModel
implements ImageModel {
    private static final Logger logger = LoggerFactory.getLogger(AzureOpenAiImageModel.class);
    private OpenAIClient client;
    private final String deploymentName;
    private ImageGenerationQuality quality = null;
    private ImageSize size = null;
    private String user = null;
    private ImageGenerationStyle style = null;
    private ImageGenerationResponseFormat responseFormat = null;

    public AzureOpenAiImageModel(OpenAIClient client, String deploymentName, String quality, String size, String user, String style, String responseFormat) {
        this(deploymentName, quality, size, user, style, responseFormat);
        this.client = client;
    }

    public AzureOpenAiImageModel(String endpoint, String serviceVersion, String apiKey, String deploymentName, String quality, String size, String user, String style, String responseFormat, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, String userAgentSuffix, Map<String, String> customHeaders) {
        this(deploymentName, quality, size, user, style, responseFormat);
        this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, apiKey, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
    }

    public AzureOpenAiImageModel(String endpoint, String serviceVersion, KeyCredential keyCredential, String deploymentName, String quality, String size, String user, String style, String responseFormat, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, String userAgentSuffix, Map<String, String> customHeaders) {
        this(deploymentName, quality, size, user, style, responseFormat);
        this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, keyCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
    }

    public AzureOpenAiImageModel(String endpoint, String serviceVersion, TokenCredential tokenCredential, String deploymentName, String quality, String size, String user, String style, String responseFormat, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, String userAgentSuffix, Map<String, String> customHeaders) {
        this(deploymentName, quality, size, user, style, responseFormat);
        this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, tokenCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
    }

    private AzureOpenAiImageModel(String deploymentName, String quality, String size, String user, String style, String responseFormat) {
        this.deploymentName = (String)Utils.getOrDefault((Object)deploymentName, (Object)"dall-e-3");
        if (quality != null) {
            this.quality = ImageGenerationQuality.fromString((String)quality);
        }
        if (size != null) {
            this.size = ImageSize.fromString((String)size);
        }
        if (user != null) {
            this.user = user;
        }
        if (style != null) {
            this.style = ImageGenerationStyle.fromString((String)style);
        }
        if (responseFormat != null) {
            this.responseFormat = ImageGenerationResponseFormat.fromString((String)responseFormat);
        }
    }

    public Response<Image> generate(String prompt) {
        ImageGenerationOptions options = new ImageGenerationOptions(prompt).setModel(this.deploymentName).setN(Integer.valueOf(1)).setQuality(this.quality).setSize(this.size).setUser(this.user).setStyle(this.style).setResponseFormat(this.responseFormat);
        try {
            ImageGenerations imageGenerations = this.client.getImageGenerations(this.deploymentName, options);
            Image image = InternalAzureOpenAiHelper.imageFrom((ImageGenerationData)imageGenerations.getData().get(0));
            return Response.from((Object)image);
        }
        catch (HttpResponseException httpResponseException) {
            logger.info("Error generating image, {}", httpResponseException.getValue());
            FinishReason exceptionFinishReason = InternalAzureOpenAiHelper.contentFilterManagement(httpResponseException, "content_policy_violation");
            return Response.from((Object)Image.builder().build(), null, (FinishReason)exceptionFinishReason);
        }
    }

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(AzureOpenAiImageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            AzureOpenAiImageModelBuilderFactory factory = (AzureOpenAiImageModelBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return new Builder();
    }

    public static class Builder {
        private String endpoint;
        private String serviceVersion;
        private String apiKey;
        private KeyCredential keyCredential;
        private TokenCredential tokenCredential;
        private String deploymentName;
        private String quality;
        private String size;
        private String user;
        private String style;
        private String responseFormat;
        private Duration timeout;
        private Integer maxRetries;
        private ProxyOptions proxyOptions;
        private boolean logRequestsAndResponses;
        private OpenAIClient openAIClient;
        private String userAgentSuffix;
        private Map<String, String> customHeaders;

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder nonAzureApiKey(String nonAzureApiKey) {
            this.keyCredential = new KeyCredential(nonAzureApiKey);
            this.endpoint = "https://api.openai.com/v1";
            return this;
        }

        public Builder tokenCredential(TokenCredential tokenCredential) {
            this.tokenCredential = tokenCredential;
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        public Builder quality(ImageGenerationQuality imageGenerationQuality) {
            this.quality = imageGenerationQuality.toString();
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }

        public Builder size(ImageSize imageSize) {
            this.size = imageSize.toString();
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder style(String style) {
            this.style = style;
            return this;
        }

        public Builder style(ImageGenerationStyle imageGenerationStyle) {
            this.style = imageGenerationStyle.toString();
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder responseFormat(ImageGenerationResponseFormat imageGenerationResponseFormat) {
            this.responseFormat = imageGenerationResponseFormat.toString();
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxyOptions(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public Builder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        public Builder openAIClient(OpenAIClient openAIClient) {
            this.openAIClient = openAIClient;
            return this;
        }

        public Builder userAgentSuffix(String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public AzureOpenAiImageModel build() {
            if (this.openAIClient == null) {
                if (this.tokenCredential != null) {
                    return new AzureOpenAiImageModel(this.endpoint, this.serviceVersion, this.tokenCredential, this.deploymentName, this.quality, this.size, this.user, this.style, this.responseFormat, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.userAgentSuffix, this.customHeaders);
                }
                if (this.keyCredential != null) {
                    return new AzureOpenAiImageModel(this.endpoint, this.serviceVersion, this.keyCredential, this.deploymentName, this.quality, this.size, this.user, this.style, this.responseFormat, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.userAgentSuffix, this.customHeaders);
                }
                return new AzureOpenAiImageModel(this.endpoint, this.serviceVersion, this.apiKey, this.deploymentName, this.quality, this.size, this.user, this.style, this.responseFormat, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.userAgentSuffix, this.customHeaders);
            }
            return new AzureOpenAiImageModel(this.openAIClient, this.deploymentName, this.quality, this.size, this.user, this.style, this.responseFormat);
        }
    }
}

