/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class CreateFileAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.CreateFileAction";
    private Shell shell;

    public CreateFileAction(Shell shell) {
        super(WorkbenchMessages.getString("CreateFileAction.text"));
        Assert.isNotNull(shell);
        this.shell = shell;
        this.setToolTipText(WorkbenchMessages.getString("CreateFileAction.toolTip"));
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_OBJ_FILE"));
        this.setId(ID);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.create_file_action_context");
    }

    public void run() {
        BasicNewFileResourceWizard wizard = new BasicNewFileResourceWizard();
        wizard.init(PlatformUI.getWorkbench(), this.getStructuredSelection());
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText(WorkbenchMessages.getString("CreateFileAction.title"));
        WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.new_file_wizard_context");
        dialog.open();
    }

    protected boolean updateSelection(IStructuredSelection s) {
        if (!super.updateSelection(s)) {
            return false;
        }
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IResource resource = (IResource)resources.next();
            if (this.resourceIsType(resource, 6) && resource.isAccessible()) continue;
            return false;
        }
        return true;
    }
}

