/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.text.Collator;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.misc.Sorter;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;

public class OpenWithMenu
extends ContributionItem {
    private IWorkbenchPage page;
    private IAdaptable file;
    private EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
    private static Hashtable imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private Sorter sorter = new Sorter(){
        private Collator collator = Collator.getInstance();

        public boolean compare(Object o1, Object o2) {
            String s1 = ((IEditorDescriptor)o1).getLabel();
            String s2 = ((IEditorDescriptor)o2).getLabel();
            return this.collator.compare(s2, s1) > 0;
        }
    };
    static /* synthetic */ Class class$0;

    public OpenWithMenu(IWorkbenchPage page) {
        this(page, null);
    }

    public OpenWithMenu(IWorkbenchPage page, IAdaptable file) {
        super(ID);
        this.page = page;
        this.file = file;
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.getFileResource()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.SystemEditor")) {
            imageDesc = this.registry.getSystemEditorImageDescriptor(this.getFileResource());
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.openEditor(descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        IFile file = this.getFileResource();
        if (file == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.getDefaultEditor();
        IEditorDescriptor preferredEditor = this.registry.getDefaultEditor(file);
        Object[] editors = this.sorter.sort(this.registry.getEditors(file));
        boolean defaultFound = false;
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = (IEditorDescriptor)editors[i];
            this.createMenuItem(menu, editor, preferredEditor);
            if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                defaultFound = true;
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        EditorDescriptor descriptor = EditorDescriptor.getSystemEditorDescriptor();
        this.createMenuItem(menu, descriptor, preferredEditor);
        this.createDefaultMenuItem(menu, file);
    }

    private IFile getFileResource() {
        IResource resource;
        if (this.file instanceof IFile) {
            return (IFile)this.file;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)this.file.getAdapter((Class)clazz)) instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(IEditorDescriptor editor) {
        IFile file = this.getFileResource();
        try {
            if (editor == null) {
                this.page.openSystemEditor(file);
            } else {
                this.page.openEditor(file, editor.getId());
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError(this.page.getWorkbenchWindow().getShell(), WorkbenchMessages.getString("OpenWithMenu.dialogTitle"), ((Throwable)((Object)e)).getMessage(), e);
        }
    }

    private void createDefaultMenuItem(Menu menu, final IFile file) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(this.registry.getDefaultEditor(file) == null);
        menuItem.setText(WorkbenchMessages.getString("DefaultEditorDescription.name"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.registry.setDefaultEditor(file, null);
                        try {
                            OpenWithMenu.this.page.openEditor(file);
                            break;
                        }
                        catch (PartInitException e) {
                            DialogUtil.openError(OpenWithMenu.this.page.getWorkbenchWindow().getShell(), WorkbenchMessages.getString("OpenWithMenu.dialogTitle"), ((Throwable)((Object)e)).getMessage(), e);
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }
}

