/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class RenameResourceAction
extends WorkspaceAction {
    private TreeEditor treeEditor;
    private Tree navigatorTree;
    private Text textEditor;
    private Composite textEditorParent;
    private TextActionHandler textActionHandler;
    private IResource inlinedResource;
    public static final String ID = "org.eclipse.ui.RenameResourceAction";
    private IPath newPath;
    private static final String CHECK_RENAME_TITLE = WorkbenchMessages.getString("RenameResourceAction.checkTitle");
    private static final String CHECK_RENAME_MESSAGE = WorkbenchMessages.getString("RenameResourceAction.readOnlyCheck");
    private static String RESOURCE_EXISTS_TITLE = WorkbenchMessages.getString("RenameResourceAction.resourceExists");
    private static String RESOURCE_EXISTS_MESSAGE = WorkbenchMessages.getString("RenameResourceAction.overwriteQuestion");
    private static String RENAMING_MESSAGE = WorkbenchMessages.getString("RenameResourceAction.progressMessage");

    public RenameResourceAction(Shell shell) {
        super(shell, WorkbenchMessages.getString("RenameResourceAction.text"));
        this.setToolTipText(WorkbenchMessages.getString("RenameResourceAction.toolTip"));
        this.setId(ID);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.rename_resource_action_context");
    }

    public RenameResourceAction(Shell shell, Tree tree) {
        this(shell);
        this.navigatorTree = tree;
        this.treeEditor = new TreeEditor(tree);
    }

    private boolean checkOverwrite(final Shell shell, final IResource destination) {
        final boolean[] result = new boolean[1];
        Runnable query = new Runnable(){

            public void run() {
                String pathName = destination.getFullPath().makeRelative().toString();
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)RESOURCE_EXISTS_TITLE, (String)MessageFormat.format(RESOURCE_EXISTS_MESSAGE, pathName));
            }
        };
        shell.getDisplay().syncExec(query);
        return result[0];
    }

    private boolean checkReadOnlyAndNull(IResource currentResource) {
        if (currentResource == null) {
            return false;
        }
        if (currentResource.isReadOnly()) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)CHECK_RENAME_TITLE, (String)MessageFormat.format(CHECK_RENAME_MESSAGE, currentResource.getName()));
        }
        return true;
    }

    Composite createParent() {
        Tree tree = this.getTree();
        Composite result = new Composite((Composite)tree, 0);
        TreeItem[] selectedItems = tree.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private void createTextEditor(final IResource resource) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        this.textEditorParent.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameResourceAction.this.textEditor.getSize();
                Point parentSize = RenameResourceAction.this.textEditorParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameResourceAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameResourceAction.this.textEditorParent.getSize();
                RenameResourceAction.this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
                RenameResourceAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameResourceAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameResourceAction.this.saveChangesAndDispose(resource);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameResourceAction.this.saveChangesAndDispose(resource);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    private void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    protected List getActionResources() {
        if (this.inlinedResource == null) {
            return super.getActionResources();
        }
        ArrayList<IResource> actionResources = new ArrayList<IResource>();
        actionResources.add(this.inlinedResource);
        return actionResources;
    }

    String getOperationMessage() {
        return WorkbenchMessages.getString("RenameResourceAction.progress");
    }

    String getProblemsMessage() {
        return WorkbenchMessages.getString("RenameResourceAction.problemMessage");
    }

    String getProblemsTitle() {
        return WorkbenchMessages.getString("RenameResourceAction.problemTitle");
    }

    private Tree getTree() {
        return this.navigatorTree;
    }

    private boolean getUpdateValue(IStructuredSelection selection) {
        if (selection.size() > 1) {
            return false;
        }
        if (!super.updateSelection(selection)) {
            return false;
        }
        List resources = this.getSelectedResources();
        return resources.size() == 1;
    }

    void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(RENAMING_MESSAGE, 100);
        IWorkspaceRoot workspaceRoot = resource.getWorkspace().getRoot();
        IResource newResource = workspaceRoot.findMember(this.newPath);
        if (newResource != null) {
            if (this.checkOverwrite(this.getShell(), newResource)) {
                if (resource.getType() == 1 && newResource.getType() == 1) {
                    IFile file = (IFile)resource;
                    IFile newFile = (IFile)newResource;
                    if (this.validateEdit(file, newFile, this.getShell())) {
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 50);
                        newFile.setContents(file.getContents(), 2, (IProgressMonitor)subMonitor);
                        file.delete(2, (IProgressMonitor)subMonitor);
                    }
                    monitor.worked(100);
                    return;
                }
                newResource.delete(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            } else {
                monitor.worked(100);
                return;
            }
        }
        if (resource.getType() == 4) {
            IProject project = (IProject)resource;
            IProjectDescription description = project.getDescription();
            description.setName(this.newPath.segment(0));
            project.move(description, 33, monitor);
        } else {
            resource.move(this.newPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
    }

    protected String queryNewResourceName(final IResource resource) {
        final IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        final IPath prefix = resource.getFullPath().removeLastSegments(1);
        IInputValidator validator = new IInputValidator(){

            public String isValid(String string) {
                if (resource.getName().equals(string)) {
                    return WorkbenchMessages.getString("RenameResourceAction.nameMustBeDifferent");
                }
                IStatus status = workspace.validateName(string, resource.getType());
                if (!status.isOK()) {
                    return status.getMessage();
                }
                if (workspace.getRoot().exists(prefix.append(string))) {
                    return WorkbenchMessages.getString("RenameResourceAction.nameExists");
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.getShell(), WorkbenchMessages.getString("RenameResourceAction.inputDialogTitle"), WorkbenchMessages.getString("RenameResourceAction.inputDialogMessage"), resource.getName(), validator);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog.getValue();
    }

    private void queryNewResourceNameInline(IResource resource) {
        if (this.textEditorParent == null) {
            this.createTextEditor(resource);
        }
        this.textEditor.setText(resource.getName());
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    public void run() {
        if (this.navigatorTree == null) {
            IResource currentResource = (IResource)this.getStructuredSelection().getFirstElement();
            if (!this.checkReadOnlyAndNull(currentResource)) {
                return;
            }
            String newName = this.queryNewResourceName(currentResource);
            if (newName == null || newName.equals("")) {
                return;
            }
            this.newPath = currentResource.getFullPath().removeLastSegments(1).append(newName);
            super.run();
        } else {
            this.runWithInlineEditor();
        }
    }

    private void runWithInlineEditor() {
        IResource currentResource = (IResource)this.getStructuredSelection().getFirstElement();
        if (!this.checkReadOnlyAndNull(currentResource)) {
            return;
        }
        this.queryNewResourceNameInline(currentResource);
    }

    protected void runWithNewPath(IPath path, IResource resource) {
        this.newPath = path;
        super.run();
    }

    private void saveChangesAndDispose(IResource resource) {
        this.inlinedResource = resource;
        final String newName = this.textEditor.getText();
        Runnable query = new Runnable(){

            public void run() {
                RenameResourceAction.this.disposeTextWidget();
                if (!newName.equals(RenameResourceAction.this.inlinedResource.getName())) {
                    IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
                    IStatus status = workspace.validateName(newName, RenameResourceAction.this.inlinedResource.getType());
                    if (!status.isOK()) {
                        RenameResourceAction.this.displayError(status.getMessage());
                    } else {
                        IPath newPath = RenameResourceAction.this.inlinedResource.getFullPath().removeLastSegments(1).append(newName);
                        RenameResourceAction.this.runWithNewPath(newPath, RenameResourceAction.this.inlinedResource);
                    }
                }
                RenameResourceAction.this.inlinedResource = null;
            }
        };
        this.getTree().getShell().getDisplay().asyncExec(query);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.disposeTextWidget();
        if (selection.size() > 1) {
            return false;
        }
        if (!super.updateSelection(selection)) {
            return false;
        }
        List resources = this.getSelectedResources();
        return resources.size() == 1;
    }

    public void setTextActionHandler(TextActionHandler actionHandler) {
        this.textActionHandler = actionHandler;
    }

    boolean validateEdit(IFile source, IFile destination, Shell shell) {
        if (destination.isReadOnly()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = source.isReadOnly() ? workspace.validateEdit(new IFile[]{source, destination}, (Object)shell) : workspace.validateEdit(new IFile[]{destination}, (Object)shell);
            return status.isOK();
        }
        return true;
    }
}

