/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.IShowInSource;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.ShowInContext;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ViewLabelProvider;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.part.IShowInTarget;

public class ShowInAction
extends Action {
    private IWorkbenchWindow window;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ShowInAction(IWorkbenchWindow window) {
        Assert.isNotNull(window);
        this.window = window;
        this.setText(WorkbenchMessages.getString("ShowInAction.text"));
        this.setToolTipText(WorkbenchMessages.getString("ShowInAction.toolTip"));
        this.setId("showIn");
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.show_in_action_context");
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public void updateState() {
        this.updateState(this.getSourcePart());
    }

    protected void updateState(IWorkbenchPart sourcePart) {
        this.setEnabled(sourcePart != null && (sourcePart instanceof IEditorPart || this.getShowInSource(sourcePart) != null) && this.hasShowInItems(sourcePart));
    }

    private ArrayList getShowInPartIds() {
        WorkbenchPage page = (WorkbenchPage)this.getWindow().getActivePage();
        if (page != null) {
            return page.getShowInPartIds();
        }
        return new ArrayList();
    }

    private boolean hasShowInItems(IWorkbenchPart sourcePart) {
        ArrayList ids = this.getShowInPartIds();
        if (ids.isEmpty()) {
            return false;
        }
        String srcId = sourcePart.getSite().getId();
        if (ids.contains(srcId)) {
            return ids.size() > 1;
        }
        return ids.size() > 0;
    }

    protected IWorkbenchPart getSourcePart() {
        IWorkbenchPage page = this.getWindow().getActivePage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    protected org.eclipse.ui.part.IShowInSource getShowInSource(IWorkbenchPart sourcePart) {
        Object o;
        if (sourcePart instanceof org.eclipse.ui.part.IShowInSource) {
            return (org.eclipse.ui.part.IShowInSource)((Object)sourcePart);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = sourcePart.getAdapter(clazz)) instanceof org.eclipse.ui.part.IShowInSource) {
            return (org.eclipse.ui.part.IShowInSource)o;
        }
        if (sourcePart instanceof IShowInSource) {
            return this.wrap((IShowInSource)((Object)sourcePart));
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.dialogs.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = sourcePart.getAdapter(clazz2)) instanceof IShowInSource) {
            return this.wrap((IShowInSource)o);
        }
        return null;
    }

    protected IShowInTarget getShowInTarget(IWorkbenchPart targetPart) {
        Object o;
        if (targetPart instanceof IShowInTarget) {
            return (IShowInTarget)((Object)targetPart);
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = targetPart.getAdapter(clazz)) instanceof IShowInTarget) {
            return (IShowInTarget)o;
        }
        if (targetPart instanceof org.eclipse.ui.dialogs.IShowInTarget) {
            return this.wrap((org.eclipse.ui.dialogs.IShowInTarget)((Object)targetPart));
        }
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.ui.dialogs.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = targetPart.getAdapter(clazz2)) instanceof org.eclipse.ui.dialogs.IShowInTarget) {
            return this.wrap((org.eclipse.ui.dialogs.IShowInTarget)o);
        }
        return null;
    }

    protected org.eclipse.ui.part.ShowInContext getContext() {
        IWorkbenchPart sourcePart = this.getSourcePart();
        if (sourcePart == null) {
            return null;
        }
        org.eclipse.ui.part.IShowInSource source = this.getShowInSource(sourcePart);
        if (source != null) {
            org.eclipse.ui.part.ShowInContext context = source.getShowInContext();
            if (context != null) {
                return context;
            }
        } else if (sourcePart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)sourcePart).getEditorInput();
            ISelectionProvider sp = sourcePart.getSite().getSelectionProvider();
            ISelection sel = sp == null ? null : sp.getSelection();
            return new org.eclipse.ui.part.ShowInContext(input, sel);
        }
        return null;
    }

    private IViewDescriptor[] getViewDescriptors() {
        IWorkbenchPart sourcePart = this.getSourcePart();
        if (sourcePart == null) {
            return new IViewDescriptor[0];
        }
        String srcId = sourcePart.getSite().getId();
        ArrayList ids = this.getShowInPartIds();
        ArrayList<IViewDescriptor> descs = new ArrayList<IViewDescriptor>();
        IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
        Iterator i = ((AbstractList)ids).iterator();
        while (i.hasNext()) {
            IViewDescriptor desc;
            String id = (String)i.next();
            if (id.equals(srcId) || (desc = reg.find(id)) == null) continue;
            descs.add(desc);
        }
        return descs.toArray(new IViewDescriptor[descs.size()]);
    }

    public void run() {
        Object[] result;
        org.eclipse.ui.part.ShowInContext context = this.getContext();
        if (context == null) {
            this.getWindow().getShell().getDisplay().beep();
            return;
        }
        IViewDescriptor[] viewDescs = this.getViewDescriptors();
        if (viewDescs.length == 0) {
            this.getWindow().getShell().getDisplay().beep();
            return;
        }
        ListDialog dialog = new ListDialog(this.getWindow().getShell());
        dialog.setTitle(WorkbenchMessages.getString("ShowInDialog.title"));
        dialog.setMessage(WorkbenchMessages.getString("ShowInDialog.message"));
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new ViewLabelProvider());
        dialog.setInput(viewDescs);
        dialog.setInitialSelections(new Object[]{viewDescs[0]});
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0) {
            String targetId = ((IViewDescriptor)result[0]).getId();
            this.showIn(context, targetId);
        }
    }

    protected void showIn(org.eclipse.ui.part.ShowInContext context, String targetId) {
        IWorkbenchPage page = this.getWindow().getActivePage();
        if (page != null) {
            try {
                IViewPart view = page.showView(targetId);
                IShowInTarget target = this.getShowInTarget(view);
                if (target == null || !target.show(context)) {
                    this.getWindow().getShell().getDisplay().beep();
                }
                ((WorkbenchPage)page).performedShowIn(targetId);
            }
            catch (PartInitException e) {
                WorkbenchPlugin.log("Error showing view in ShowInAction.run", e.getStatus());
            }
        }
    }

    private org.eclipse.ui.part.IShowInSource wrap(final IShowInSource oldSource) {
        return new org.eclipse.ui.part.IShowInSource(){

            public org.eclipse.ui.part.ShowInContext getShowInContext() {
                return oldSource.getShowInContext();
            }
        };
    }

    private IShowInTarget wrap(final org.eclipse.ui.dialogs.IShowInTarget oldTarget) {
        return new IShowInTarget(){

            public boolean show(org.eclipse.ui.part.ShowInContext context) {
                if (context instanceof ShowInContext) {
                    return oldTarget.show((ShowInContext)context);
                }
                return oldTarget.show(new ShowInContext(context.getInput(), context.getSelection()));
            }
        };
    }
}

