/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.TwoArrayQuickSorter;
import org.eclipse.ui.internal.misc.StringMatcher;

public class FilteredList
extends Composite {
    private Table fList;
    private ILabelProvider fLabelProvider;
    private boolean fMatchEmptyString = true;
    private boolean fIgnoreCase;
    private boolean fAllowDuplicates;
    private String fFilter = "";
    private TwoArrayQuickSorter fSorter;
    private Object[] fElements = new Object[0];
    private Label[] fLabels;
    private Vector fImages = new Vector();
    private int[] fFoldedIndices;
    private int fFoldedCount;
    private int[] fFilteredIndices;
    private int fFilteredCount;
    private FilterMatcher fFilterMatcher = new DefaultFilterMatcher();
    private Comparator fComparator;
    private UpdateThread fUpdateThread;

    public FilteredList(Composite parent, int style, ILabelProvider labelProvider, boolean ignoreCase, boolean allowDuplicates, boolean matchEmptyString) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.fList = new Table((Composite)this, style);
        this.fList.setLayoutData((Object)new GridData(1808));
        this.fList.setFont(parent.getFont());
        this.fList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredList.this.fLabelProvider.dispose();
                if (FilteredList.this.fUpdateThread != null) {
                    FilteredList.this.fUpdateThread.requestStop();
                }
            }
        });
        this.fLabelProvider = labelProvider;
        this.fIgnoreCase = ignoreCase;
        this.fSorter = new TwoArrayQuickSorter(new LabelComparator(ignoreCase));
        this.fAllowDuplicates = allowDuplicates;
        this.fMatchEmptyString = matchEmptyString;
    }

    public void setElements(Object[] elements) {
        if (elements == null) {
            this.fElements = new Object[0];
        } else {
            this.fElements = new Object[elements.length];
            System.arraycopy(elements, 0, this.fElements, 0, elements.length);
        }
        int length = this.fElements.length;
        this.fLabels = new Label[length];
        HashSet<Image> imageSet = new HashSet<Image>();
        int i = 0;
        while (i != length) {
            String text = this.fLabelProvider.getText(this.fElements[i]);
            Image image = this.fLabelProvider.getImage(this.fElements[i]);
            this.fLabels[i] = new Label(text, image);
            imageSet.add(image);
            ++i;
        }
        this.fImages.clear();
        this.fImages.addAll(imageSet);
        this.fSorter.sort(this.fLabels, this.fElements);
        this.fFilteredIndices = new int[length];
        this.fFoldedIndices = new int[length];
        this.updateList();
    }

    public boolean isEmpty() {
        return this.fElements == null || this.fElements.length == 0;
    }

    public void setFilterMatcher(FilterMatcher filterMatcher) {
        Assert.isNotNull((Object)filterMatcher);
        this.fFilterMatcher = filterMatcher;
    }

    public void setComparator(Comparator comparator) {
        Assert.isNotNull((Object)comparator);
        this.fComparator = comparator;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fList.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fList.removeSelectionListener(listener);
    }

    public void setSelection(int[] selection) {
        if (selection == null || selection.length == 0) {
            this.fList.deselectAll();
        } else {
            this.fList.setSelection(selection);
        }
    }

    public int[] getSelectionIndices() {
        return this.fList.getSelectionIndices();
    }

    public int getSelectionIndex() {
        return this.fList.getSelectionIndex();
    }

    public void setSelection(Object[] elements) {
        if (elements == null || elements.length == 0) {
            this.fList.deselectAll();
            return;
        }
        if (this.fElements == null) {
            return;
        }
        int[] indices = new int[elements.length];
        int i = 0;
        while (i != elements.length) {
            int j = 0;
            while (j != this.fFoldedCount) {
                int max = j == this.fFoldedCount - 1 ? this.fFilteredCount : this.fFoldedIndices[j + 1];
                int l = this.fFoldedIndices[j];
                while (l != max) {
                    if (this.fElements[this.fFilteredIndices[l]].equals(elements[i])) {
                        indices[i] = j;
                        break;
                    }
                    ++l;
                }
                if (l != max) break;
                ++j;
            }
            if (j == this.fFoldedCount) {
                indices[i] = 0;
            }
            ++i;
        }
        this.fList.setSelection(indices);
    }

    public Object[] getSelection() {
        if (this.fList.isDisposed() || this.fList.getSelectionCount() == 0) {
            return new Object[0];
        }
        int[] indices = this.fList.getSelectionIndices();
        Object[] elements = new Object[indices.length];
        int i = 0;
        while (i != indices.length) {
            elements[i] = this.fElements[this.fFilteredIndices[this.fFoldedIndices[indices[i]]]];
            ++i;
        }
        return elements;
    }

    public void setFilter(String filter) {
        this.fFilter = filter == null ? "" : filter;
        this.updateList();
    }

    private void updateList() {
        this.fFilteredCount = this.filter();
        this.fFoldedCount = this.fold();
        if (this.fUpdateThread != null) {
            this.fUpdateThread.requestStop();
        }
        this.fUpdateThread = new UpdateThread(new TableUpdater(this.fList, this.fFoldedCount));
        this.fUpdateThread.start();
    }

    public String getFilter() {
        return this.fFilter;
    }

    public Object[] getFoldedElements(int index) {
        if (index < 0 || index >= this.fFoldedCount) {
            return null;
        }
        int start = this.fFoldedIndices[index];
        int count = index == this.fFoldedCount - 1 ? this.fFilteredCount - start : this.fFoldedIndices[index + 1] - start;
        Object[] elements = new Object[count];
        int i = 0;
        while (i != count) {
            elements[i] = this.fElements[this.fFilteredIndices[start + i]];
            ++i;
        }
        return elements;
    }

    private int fold() {
        if (this.fAllowDuplicates) {
            int i = 0;
            while (i != this.fFilteredCount) {
                this.fFoldedIndices[i] = i;
                ++i;
            }
            return this.fFilteredCount;
        }
        int k = 0;
        Label last = null;
        int i = 0;
        while (i != this.fFilteredCount) {
            int j = this.fFilteredIndices[i];
            Label current = this.fLabels[j];
            if (!current.equals(last)) {
                this.fFoldedIndices[k] = i;
                ++k;
                last = current;
            }
            ++i;
        }
        return k;
    }

    private int filter() {
        if (!(this.fFilter != null && this.fFilter.length() != 0 || this.fMatchEmptyString)) {
            return 0;
        }
        this.fFilterMatcher.setFilter(this.fFilter.trim(), this.fIgnoreCase, false);
        int k = 0;
        int i = 0;
        while (i != this.fElements.length) {
            if (this.fFilterMatcher.match(this.fElements[i])) {
                this.fFilteredIndices[k++] = i;
            }
            ++i;
        }
        return k;
    }

    public boolean getAllowDuplicates() {
        return this.fAllowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.fAllowDuplicates = allowDuplicates;
    }

    public boolean getIgnoreCase() {
        return this.fIgnoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.fIgnoreCase = ignoreCase;
    }

    public boolean getMatchEmptyString() {
        return this.fMatchEmptyString;
    }

    public void setMatchEmptyString(boolean matchEmptyString) {
        this.fMatchEmptyString = matchEmptyString;
    }

    public ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    static /* synthetic */ Label[] access$3(FilteredList filteredList) {
        return filteredList.fLabels;
    }

    static /* synthetic */ int[] access$4(FilteredList filteredList) {
        return filteredList.fFilteredIndices;
    }

    static /* synthetic */ int[] access$5(FilteredList filteredList) {
        return filteredList.fFoldedIndices;
    }

    public interface FilterMatcher {
        public void setFilter(String var1, boolean var2, boolean var3);

        public boolean match(Object var1);
    }

    private class DefaultFilterMatcher
    implements FilterMatcher {
        private StringMatcher fMatcher;

        DefaultFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            this.fMatcher = new StringMatcher(String.valueOf(pattern) + '*', ignoreCase, ignoreWildCards);
        }

        public boolean match(Object element) {
            return this.fMatcher.match(FilteredList.this.fLabelProvider.getText(element));
        }
    }

    private static class Label {
        public final String string;
        public final Image image;

        public Label(String string, Image image) {
            this.string = string;
            this.image = image;
        }

        public boolean equals(Label label) {
            if (label == null) {
                return false;
            }
            return this.string.equals(label.string) && this.image.equals((Object)label.image);
        }
    }

    private final class LabelComparator
    implements Comparator {
        private boolean fIgnoreCase;

        LabelComparator(boolean ignoreCase) {
            this.fIgnoreCase = ignoreCase;
        }

        public int compare(Object left, Object right) {
            Label leftLabel = (Label)left;
            Label rightLabel = (Label)right;
            int value = FilteredList.this.fComparator == null ? (this.fIgnoreCase ? leftLabel.string.compareToIgnoreCase(rightLabel.string) : leftLabel.string.compareTo(rightLabel.string)) : FilteredList.this.fComparator.compare(leftLabel.string, rightLabel.string);
            if (value != 0) {
                return value;
            }
            if (leftLabel.image == null) {
                return rightLabel.image == null ? 0 : -1;
            }
            if (rightLabel.image == null) {
                return 1;
            }
            return FilteredList.this.fImages.indexOf(leftLabel.image) - FilteredList.this.fImages.indexOf(rightLabel.image);
        }
    }

    private interface IncrementalRunnable
    extends Runnable {
        public int getCount();

        public void cancel();
    }

    private class TableUpdater
    implements IncrementalRunnable {
        private final Display fDisplay;
        private final Table fTable;
        private final int fCount;
        private int fIndex;

        public TableUpdater(Table table, int count) {
            this.fTable = table;
            this.fDisplay = table.getDisplay();
            this.fCount = count;
        }

        public int getCount() {
            return this.fCount + 1;
        }

        public void cancel() {
            this.fIndex = 0;
        }

        public void run() {
            int index = this.fIndex++;
            this.fDisplay.syncExec(new Runnable(this, index){
                private final /* synthetic */ TableUpdater this$1;
                private final /* synthetic */ int val$index;
                {
                    this.this$1 = tableUpdater;
                    this.val$index = n;
                }

                public void run() {
                    if (TableUpdater.access$0(this.this$1).isDisposed()) {
                        return;
                    }
                    int itemCount = TableUpdater.access$0(this.this$1).getItemCount();
                    if (this.val$index < TableUpdater.access$1(this.this$1)) {
                        TableItem item = this.val$index < itemCount ? TableUpdater.access$0(this.this$1).getItem(this.val$index) : new TableItem(TableUpdater.access$0(this.this$1), 0);
                        Label label = FilteredList.access$3(TableUpdater.access$2(this.this$1))[FilteredList.access$4(TableUpdater.access$2(this.this$1))[FilteredList.access$5(TableUpdater.access$2(this.this$1))[this.val$index]]];
                        item.setText(label.string);
                        item.setImage(label.image);
                        if (this.val$index == 0) {
                            TableUpdater.access$0(this.this$1).setSelection(0);
                            TableUpdater.access$0(this.this$1).notifyListeners(13, new Event());
                        }
                    } else {
                        if (TableUpdater.access$1(this.this$1) < itemCount) {
                            TableUpdater.access$0(this.this$1).setRedraw(false);
                            TableUpdater.access$0(this.this$1).remove(TableUpdater.access$1(this.this$1), itemCount - 1);
                            TableUpdater.access$0(this.this$1).setRedraw(true);
                        }
                        if (TableUpdater.access$1(this.this$1) == 0) {
                            TableUpdater.access$0(this.this$1).notifyListeners(13, new Event());
                        }
                    }
                }
            });
        }

        static /* synthetic */ Table access$0(TableUpdater tableUpdater) {
            return tableUpdater.fTable;
        }

        static /* synthetic */ int access$1(TableUpdater tableUpdater) {
            return tableUpdater.fCount;
        }

        static /* synthetic */ FilteredList access$2(TableUpdater tableUpdater) {
            return tableUpdater.FilteredList.this;
        }
    }

    private static class UpdateThread
    extends Thread {
        private final IncrementalRunnable fRunnable;
        private boolean fStop;

        public UpdateThread(IncrementalRunnable runnable) {
            this.fRunnable = runnable;
        }

        public void requestStop() {
            this.fStop = true;
        }

        public void run() {
            int count = this.fRunnable.getCount();
            int i = 0;
            while (i != count) {
                if (i % 50 == 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.fStop) {
                    this.fRunnable.cancel();
                    break;
                }
                this.fRunnable.run();
                ++i;
            }
        }
    }
}

