/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.CoolBarContributionItem;
import org.eclipse.ui.internal.CoolBarLayout;
import org.eclipse.ui.internal.CoolItemPosition;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class CoolBarManager
extends ContributionManager
implements IToolBarManager {
    private int style = 0;
    private CoolBar coolBar = null;
    private MenuManager chevronMenuManager;
    private MenuManager coolBarMenuManager = new MenuManager();
    private Menu coolBarMenu = null;
    private boolean rememberPositions = false;
    private ArrayList rememberedPositions = new ArrayList();

    public CoolBarManager() {
    }

    public CoolBarManager(int style) {
        this.style = style;
    }

    public void add(IAction action) {
        Assert.isTrue((boolean)false);
    }

    public void add(IContributionItem item) {
        Assert.isTrue((boolean)(item instanceof CoolBarContributionItem));
        super.add(item);
    }

    public void addToMenu(ActionContributionItem item) {
        this.coolBarMenuManager.add(item.getAction());
    }

    private void addToGroup(String itemId, IContributionItem item, boolean append) {
        Assert.isTrue((boolean)false);
    }

    private boolean coolBarExist() {
        return this.coolBar != null && !this.coolBar.isDisposed();
    }

    CoolBar createControl(Composite parent) {
        if (!this.coolBarExist() && parent != null) {
            this.coolBar = new CoolBar(parent, this.style);
            this.coolBar.setLocked(false);
            this.coolBar.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    CoolBarManager.this.coolBar.getParent().layout();
                }
            });
            this.coolBar.setMenu(this.getCoolBarMenu());
        }
        return this.coolBar;
    }

    private CoolItem createCoolItem(CoolBarContributionItem cbItem, ToolBar toolBar) {
        toolBar.setVisible(true);
        CoolItemPosition position = this.getRememberedPosition(cbItem.getId());
        CoolItem coolItem = position != null ? this.createRememberedCoolItem(cbItem, toolBar, position) : this.createNewCoolItem(cbItem, toolBar);
        coolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    CoolBarManager.this.handleChevron(event);
                }
            }
        });
        return coolItem;
    }

    private CoolItem createNewCoolItem(CoolBarContributionItem cbItem, ToolBar toolBar) {
        CoolItem coolItem;
        int index = -1;
        if (cbItem.isOrderBefore()) {
            index = this.getInsertBeforeIndex(cbItem);
        } else if (cbItem.isOrderAfter()) {
            index = this.getInsertAfterIndex(cbItem);
        }
        if (index == -1) {
            index = this.coolBar.getItemCount();
            coolItem = new CoolItem(this.coolBar, 4);
        } else {
            coolItem = new CoolItem(this.coolBar, 4, index);
        }
        coolItem.setControl((Control)toolBar);
        coolItem.setData((Object)cbItem);
        this.setSizeFor(coolItem);
        return coolItem;
    }

    private CoolItem createRememberedCoolItem(CoolBarContributionItem cbItem, ToolBar toolBar, CoolItemPosition position) {
        RestoreItemData data = this.getRestoreData(cbItem, position);
        int savedAfterRow = -1;
        int currentAfterRow = -1;
        int savedBeforeRow = -1;
        int currentBeforeRow = -1;
        int savedItemRow = -1;
        CoolBarLayout currentLayout = this.getLayout();
        if (data.savedPosition != null) {
            savedItemRow = data.savedPosition.getRowOf(cbItem.getId());
            if (data.afterItemId != null) {
                savedAfterRow = data.savedPosition.getRowOf(data.afterItemId);
                currentAfterRow = currentLayout.getRowOfIndex(data.afterIndex);
            }
            if (data.beforeItemId != null) {
                savedBeforeRow = data.savedPosition.getRowOf(data.beforeItemId);
                currentBeforeRow = currentLayout.getRowOfIndex(data.beforeIndex);
            }
        }
        int createIndex = -1;
        int[] newWraps = null;
        if (data.afterIndex != -1 && data.beforeIndex != -1) {
            if (savedItemRow == savedAfterRow && savedItemRow == savedBeforeRow) {
                if (currentAfterRow == currentBeforeRow) {
                    createIndex = data.beforeIndex + 1;
                    int row = currentBeforeRow;
                } else if (currentBeforeRow == savedBeforeRow) {
                    createIndex = data.beforeIndex + 1;
                    int row = currentBeforeRow;
                } else if (currentAfterRow == savedAfterRow) {
                    createIndex = data.afterIndex;
                    int row = currentAfterRow;
                    newWraps = currentLayout.wrapsForNewItem(row, createIndex);
                } else {
                    createIndex = data.beforeIndex + 1;
                    int row = currentBeforeRow;
                }
            } else if (savedItemRow == savedBeforeRow) {
                createIndex = data.beforeIndex + 1;
                int row = currentBeforeRow;
            } else if (savedItemRow == savedAfterRow) {
                createIndex = data.afterIndex;
                int row = currentAfterRow;
                newWraps = currentLayout.wrapsForNewItem(row, createIndex);
            } else {
                int row = currentBeforeRow + 1;
                createIndex = currentLayout.getStartIndexOfRow(row);
                if (createIndex == -1) {
                    createIndex = this.coolBar.getItemCount();
                }
                newWraps = currentLayout.wrapsForNewRow(row, createIndex);
            }
        } else if (data.afterIndex != -1) {
            createIndex = data.afterIndex;
            if (savedItemRow == savedAfterRow) {
                int row = currentAfterRow;
                newWraps = currentLayout.wrapsForNewItem(row, createIndex);
            } else {
                int row = currentAfterRow;
                createIndex = currentLayout.getStartIndexOfRow(row);
                newWraps = currentLayout.wrapsForNewRow(row, createIndex);
            }
        } else if (data.beforeIndex != -1) {
            createIndex = data.beforeIndex + 1;
            if (savedItemRow == savedBeforeRow) {
                int row = currentBeforeRow;
                newWraps = currentLayout.wrapsForNewItem(row, createIndex);
            } else {
                int row = currentBeforeRow + 1;
                createIndex = currentLayout.getStartIndexOfRow(row);
                if (createIndex == -1) {
                    createIndex = this.coolBar.getItemCount();
                }
                newWraps = currentLayout.wrapsForNewRow(row, createIndex);
            }
        } else {
            createIndex = this.coolBar.getItemCount();
        }
        if (newWraps != null) {
            this.coolBar.setRedraw(false);
        }
        CoolItem coolItem = new CoolItem(this.coolBar, 4, createIndex);
        coolItem.setControl((Control)toolBar);
        coolItem.setData((Object)cbItem);
        this.setSizeFor(coolItem);
        if (newWraps != null) {
            this.coolBar.setWrapIndices(newWraps);
            this.coolBar.setRedraw(true);
        }
        this.positionAdded(position);
        return coolItem;
    }

    private void dispose(CoolBarContributionItem cbItem) {
        CoolItem coolItem = this.findCoolItem(cbItem);
        if (coolItem != null) {
            this.dispose(coolItem);
        }
        this.remove((IContributionItem)cbItem);
        cbItem.getToolBarManager().dispose();
    }

    private void dispose(CoolItem coolItem) {
        if (coolItem != null && !coolItem.isDisposed()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)coolItem.getData());
            if (cbItem != null && this.rememberPositions) {
                this.rememberPositionFor(cbItem.getId(), this.getLayout());
            }
            coolItem.setData(null);
            Control control = coolItem.getControl();
            if (control != null && !control.isDisposed()) {
                coolItem.setControl(null);
            }
            coolItem.dispose();
        }
    }

    void dispose() {
        if (this.coolBarExist()) {
            IContributionItem[] cbItems = this.getItems();
            int i = 0;
            while (i < cbItems.length) {
                CoolBarContributionItem cbItem = (CoolBarContributionItem)cbItems[i];
                this.dispose(cbItem);
                cbItem.dispose();
                ++i;
            }
            this.coolBar.dispose();
            this.coolBar = null;
        }
        if (this.chevronMenuManager != null) {
            this.chevronMenuManager.dispose();
            this.chevronMenuManager = null;
        }
        if (this.coolBarMenuManager != null) {
            this.coolBarMenuManager.dispose();
            this.coolBarMenuManager = null;
        }
    }

    private CoolItem findCoolItem(CoolBarContributionItem item) {
        if (this.coolBar == null) {
            return null;
        }
        CoolItem[] items = this.coolBar.getItems();
        int i = 0;
        while (i < items.length) {
            CoolItem coolItem = items[i];
            CoolBarContributionItem data = (CoolBarContributionItem)((Object)coolItem.getData());
            if (data != null && data.equals((Object)item)) {
                return coolItem;
            }
            ++i;
        }
        return null;
    }

    CoolBarContributionItem findSubId(String id) {
        IContributionItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            CoolBarContributionItem item = (CoolBarContributionItem)items[i];
            IContributionItem subItem = item.getToolBarManager().find(id);
            if (subItem != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private ArrayList getContributionIds() {
        IContributionItem[] items = this.getItems();
        ArrayList<String> ids = new ArrayList<String>(items.length);
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            ids.add(item.getId());
            ++i;
        }
        return ids;
    }

    private ArrayList getCoolItemIds() {
        CoolItem[] coolItems = this.coolBar.getItems();
        ArrayList<String> ids = new ArrayList<String>(coolItems.length);
        int i = 0;
        while (i < coolItems.length) {
            CoolBarContributionItem group = (CoolBarContributionItem)((Object)coolItems[i].getData());
            if (group != null) {
                ids.add(group.getId());
            }
            ++i;
        }
        return ids;
    }

    Menu getCoolBarMenu() {
        if (this.coolBarMenu == null) {
            this.coolBarMenu = this.coolBarMenuManager.createContextMenu((Control)this.coolBar);
        }
        return this.coolBarMenu;
    }

    CoolBar getControl() {
        return this.coolBar;
    }

    private int getInsertAfterIndex(CoolBarContributionItem coolBarItem) {
        CoolItem afterCoolItem;
        IContributionItem[] items = this.getItems();
        int index = -1;
        CoolBarContributionItem afterItem = null;
        int i = 0;
        block0: while (i < items.length) {
            if (items[i].equals((Object)coolBarItem)) {
                if (i > 0) {
                    while (i > 0) {
                        afterItem = (CoolBarContributionItem)items[i - 1];
                        if (afterItem.isVisible()) break block0;
                        --i;
                    }
                    break;
                }
                index = 0;
                break;
            }
            ++i;
        }
        if (afterItem != null && (afterCoolItem = this.findCoolItem(afterItem)) != null) {
            index = this.coolBar.indexOf(afterCoolItem);
            ++index;
        }
        return index;
    }

    private int getInsertBeforeIndex(CoolBarContributionItem coolBarItem) {
        CoolItem beforeCoolItem;
        IContributionItem[] items = this.getItems();
        int index = -1;
        CoolBarContributionItem beforeItem = null;
        int i = 0;
        block0: while (i < items.length) {
            if (items[i].equals((Object)coolBarItem)) {
                if (i < items.length - 1) {
                    while (i < items.length - 1) {
                        beforeItem = (CoolBarContributionItem)items[i + 1];
                        if (beforeItem.isVisible()) break block0;
                        ++i;
                    }
                    break;
                }
                index = this.coolBar.getItems().length;
                break;
            }
            ++i;
        }
        if (beforeItem != null && (beforeCoolItem = this.findCoolItem(beforeItem)) != null) {
            index = this.coolBar.indexOf(beforeCoolItem);
        }
        return index;
    }

    private CoolBarLayout getLayout() {
        if (!this.coolBarExist()) {
            return null;
        }
        CoolBarLayout layout = new CoolBarLayout(this.coolBar);
        layout.rememberedPositions = new ArrayList();
        layout.rememberedPositions.addAll(this.rememberedPositions);
        return layout;
    }

    private RestoreItemData getRestoreData(CoolBarContributionItem cbItem, CoolItemPosition position) {
        RestoreItemData bestMatch = new RestoreItemData();
        ArrayList coolBarItems = this.getLayout().items;
        int startIndex = this.rememberedPositions.indexOf(position);
        CoolBarLayout previousLayout = null;
        int i = startIndex;
        while (i < this.rememberedPositions.size()) {
            CoolItemPosition savedPosition = (CoolItemPosition)this.rememberedPositions.get(i);
            ArrayList savedItems = savedPosition.getItems();
            int savedItemIndex = savedItems.indexOf(cbItem.getId());
            if (savedItemIndex == -1 || previousLayout != null && !previousLayout.isDerivativeOf(savedPosition.layout)) break;
            boolean afterBeforeItemFound = bestMatch.afterIndex != -1 && bestMatch.beforeIndex != -1;
            String afterId = null;
            String beforeId = null;
            int beforeIndex = -1;
            int afterIndex = -1;
            int j = savedItemIndex + 1;
            while (j < savedItems.size()) {
                afterId = (String)savedItems.get(j);
                afterIndex = coolBarItems.indexOf(afterId);
                if (afterIndex != -1) break;
                ++j;
            }
            j = savedItemIndex - 1;
            while (j >= 0) {
                beforeId = (String)savedItems.get(j);
                beforeIndex = coolBarItems.indexOf(beforeId);
                if (beforeIndex != -1) break;
                --j;
            }
            if (beforeIndex != -1 && afterIndex != -1) {
                bestMatch.savedPosition = savedPosition;
                bestMatch.afterItemId = afterId;
                bestMatch.afterIndex = afterIndex;
                bestMatch.beforeItemId = beforeId;
                bestMatch.beforeIndex = beforeIndex;
                if (beforeIndex + 1 == afterIndex) {
                    break;
                }
            } else if (beforeIndex != -1) {
                if (afterBeforeItemFound) break;
                bestMatch.savedPosition = savedPosition;
                bestMatch.beforeItemId = beforeId;
                bestMatch.beforeIndex = beforeIndex;
                bestMatch.afterItemId = null;
                bestMatch.afterIndex = -1;
                if (beforeIndex == coolBarItems.size() - 1) {
                    break;
                }
            } else {
                if (afterIndex == -1 || afterBeforeItemFound) break;
                bestMatch.savedPosition = savedPosition;
                bestMatch.afterItemId = afterId;
                bestMatch.afterIndex = afterIndex;
                bestMatch.beforeItemId = null;
                bestMatch.beforeIndex = -1;
                if (afterIndex == 0) break;
            }
            previousLayout = savedPosition.layout;
            ++i;
        }
        return bestMatch;
    }

    private CoolItemPosition getRememberedPosition(String cbItemId) {
        int i = 0;
        while (i < this.rememberedPositions.size()) {
            CoolItemPosition position = (CoolItemPosition)this.rememberedPositions.get(i);
            if (position.id.equals(cbItemId) && !position.added) {
                return position;
            }
            ++i;
        }
        return null;
    }

    int getStyle() {
        return this.style;
    }

    private void handleChevron(SelectionEvent event) {
        CoolItem item = (CoolItem)event.widget;
        Control control = item.getControl();
        if (!(control instanceof ToolBar)) {
            return;
        }
        Point chevronPosition = this.coolBar.toDisplay(new Point(event.x, event.y));
        ToolBar toolBar = (ToolBar)control;
        ToolItem[] tools = toolBar.getItems();
        int toolCount = tools.length;
        int visibleItemCount = 0;
        while (visibleItemCount < toolCount) {
            Rectangle toolBounds = tools[visibleItemCount].getBounds();
            Point point = toolBar.toDisplay(new Point(toolBounds.x, toolBounds.y));
            toolBounds.x = point.x;
            toolBounds.y = point.y;
            if (chevronPosition.x >= toolBounds.x && chevronPosition.x - toolBounds.x <= toolBounds.width) break;
            ++visibleItemCount;
        }
        if (this.chevronMenuManager != null) {
            this.chevronMenuManager.dispose();
        }
        this.chevronMenuManager = new MenuManager();
        int i = visibleItemCount;
        while (i < toolCount) {
            IContributionItem data = (IContributionItem)tools[i].getData();
            if (data instanceof ActionContributionItem) {
                ActionContributionItem contribution = new ActionContributionItem(((ActionContributionItem)data).getAction());
                this.chevronMenuManager.add((IContributionItem)contribution);
            } else if (data instanceof SubContributionItem) {
                IContributionItem innerData = ((SubContributionItem)data).getInnerItem();
                if (innerData instanceof ActionContributionItem) {
                    ActionContributionItem contribution = new ActionContributionItem(((ActionContributionItem)innerData).getAction());
                    this.chevronMenuManager.add((IContributionItem)contribution);
                }
            } else if (data.isSeparator()) {
                this.chevronMenuManager.add((IContributionItem)new Separator());
            }
            ++i;
        }
        Menu popup = this.chevronMenuManager.createContextMenu((Control)this.coolBar);
        popup.setLocation(chevronPosition.x, chevronPosition.y);
        popup.setVisible(true);
    }

    public void insertAfter(String id, IAction action) {
        Assert.isTrue((boolean)false);
    }

    public void insertAfter(String id, IContributionItem item) {
        Assert.isTrue((boolean)(item instanceof CoolBarContributionItem));
        super.insertAfter(id, item);
        ((CoolBarContributionItem)item).setOrderAfter(true);
    }

    public void insertBefore(String id, IAction action) {
        Assert.isTrue((boolean)false);
    }

    public void insertBefore(String id, IContributionItem item) {
        Assert.isTrue((boolean)(item instanceof CoolBarContributionItem));
        super.insertBefore(id, item);
        ((CoolBarContributionItem)item).setOrderBefore(true);
    }

    boolean isLayoutLocked() {
        if (!this.coolBarExist()) {
            return false;
        }
        return this.coolBar.getLocked();
    }

    void lockLayout(boolean value) {
        this.coolBar.setLocked(value);
    }

    private void positionAdded(CoolItemPosition position) {
        position.added = true;
        boolean done = this.rememberedPositions.size() == 0;
        while (!done) {
            CoolItemPosition topLayout = (CoolItemPosition)this.rememberedPositions.get(0);
            if (topLayout.added) {
                this.rememberedPositions.remove(0);
                done = this.rememberedPositions.size() == 0;
                continue;
            }
            done = true;
        }
        int testIndex = 1;
        done = testIndex + 1 > this.rememberedPositions.size() - 1;
        while (!done) {
            CoolItemPosition pos = (CoolItemPosition)this.rememberedPositions.get(testIndex);
            if (pos.added) {
                CoolItemPosition nextPos = (CoolItemPosition)this.rememberedPositions.get(testIndex + 1);
                CoolItemPosition prevPos = (CoolItemPosition)this.rememberedPositions.get(testIndex - 1);
                boolean nextSameGroup = pos.layout.isDerivativeOf(nextPos.layout);
                boolean prevSameGroup = prevPos.layout.isDerivativeOf(pos.layout);
                if (!nextSameGroup && !prevSameGroup) {
                    this.rememberedPositions.remove(testIndex);
                } else if (nextPos.added && nextSameGroup && !prevSameGroup) {
                    this.rememberedPositions.remove(testIndex);
                } else {
                    ++testIndex;
                }
            } else {
                ++testIndex;
            }
            boolean bl = done = testIndex + 1 > this.rememberedPositions.size() - 1;
        }
    }

    private void redoLayout() {
        this.coolBar.setWrapIndices(new int[0]);
        CoolItem[] coolItems = this.coolBar.getItems();
        int i = 0;
        while (i < coolItems.length) {
            CoolItem coolItem = coolItems[i];
            this.setSizeFor(coolItem);
            ++i;
        }
        this.rememberedPositions = new ArrayList();
        this.relayout();
    }

    private void resetLayout() {
        this.coolBar.setRedraw(false);
        CoolItem[] coolItems = this.coolBar.getItems();
        int i = 0;
        while (i < coolItems.length) {
            CoolItem coolItem = coolItems[i];
            this.dispose(coolItem);
            ++i;
        }
        this.coolBar.setWrapIndices(new int[0]);
        this.update(true);
        this.coolBar.setRedraw(true);
    }

    public IContributionItem remove(IContributionItem item) {
        Assert.isTrue((boolean)(item instanceof CoolBarContributionItem));
        return super.remove(item);
    }

    private void relayout() {
        this.coolBar.getParent().layout();
    }

    private CoolItemPosition rememberPositionFor(String cbItemId, CoolBarLayout layout) {
        layout.rememberedPositions = new ArrayList();
        CoolItemPosition position = new CoolItemPosition(cbItemId, layout);
        int index = -1;
        int i = 0;
        while (i < this.rememberedPositions.size()) {
            CoolItemPosition item = (CoolItemPosition)this.rememberedPositions.get(i);
            if (position.id.equals(item.id)) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            this.rememberedPositions.remove(index);
        }
        this.rememberedPositions.add(0, position);
        return position;
    }

    void saveLayoutFor(Perspective perspective) {
        perspective.setToolBarLayout(this.getLayout());
        this.rememberPositions = false;
        this.rememberedPositions = new ArrayList();
    }

    void setLayoutFor(Perspective perspective) {
        this.rememberedPositions = new ArrayList();
        this.setLayout(perspective.getToolBarLayout());
        this.updateTabOrder();
        this.rememberPositions = true;
    }

    private void setLayout(CoolBarLayout layout) {
        try {
            this.setLayoutTo(layout);
        }
        catch (Exception e) {
            WorkbenchPlugin.log("An error has occurred restoring the coolbar layout. " + e.toString());
            this.resetLayout();
        }
    }

    private void setLayoutTo(CoolBarLayout layout) {
        ToolBar tBar;
        if (layout == null) {
            this.coolBar.setRedraw(false);
            CoolItem[] coolItems = this.coolBar.getItems();
            int[] newItemOrder = new int[coolItems.length];
            IContributionItem[] items = this.getItems();
            int j = 0;
            int[] oldItemOrder = this.coolBar.getItemOrder();
            int i = 0;
            while (i < items.length) {
                CoolBarContributionItem item = (CoolBarContributionItem)items[i];
                CoolItem coolItem = this.findCoolItem(item);
                if (coolItem != null) {
                    int creationIndex;
                    int visualIndex = this.coolBar.indexOf(coolItem);
                    newItemOrder[j] = creationIndex = oldItemOrder[visualIndex];
                    ++j;
                }
                ++i;
            }
            this.coolBar.setItemLayout(newItemOrder, this.coolBar.getWrapIndices(), this.coolBar.getItemSizes());
            this.redoLayout();
            this.coolBar.setRedraw(true);
            return;
        }
        int maxItemCount = this.coolBar.getItemCount();
        int[] itemOrder = new int[maxItemCount];
        Point[] itemSizes = new Point[maxItemCount];
        int[] found = new int[maxItemCount];
        int i = 0;
        while (i < found.length) {
            found[i] = -1;
            ++i;
        }
        int[] currentItemOrder = this.coolBar.getItemOrder();
        Vector<Integer> foundItemOrder = new Vector<Integer>();
        Vector<Point> foundItemSizes = new Vector<Point>();
        int i2 = 0;
        while (i2 < layout.items.size()) {
            CoolItem coolItem = this.findCoolItem((CoolBarContributionItem)this.find((String)layout.items.get(i2)));
            if (coolItem != null) {
                int index = currentItemOrder[this.coolBar.indexOf(coolItem)];
                foundItemOrder.add(new Integer(index));
                foundItemSizes.add(layout.itemSizes[i2]);
                found[index] = 0;
            }
            ++i2;
        }
        int count = 0;
        count = 0;
        while (count < foundItemOrder.size()) {
            itemOrder[count] = (Integer)foundItemOrder.elementAt(count);
            itemSizes[count] = (Point)foundItemSizes.elementAt(count);
            ++count;
        }
        this.rememberedPositions = layout.rememberedPositions;
        ArrayList<CoolItem> rememberedAddedItems = new ArrayList<CoolItem>();
        int i3 = 0;
        while (i3 < found.length) {
            if (found[i3] == -1) {
                itemOrder[count] = i3;
                CoolItem cItem = this.coolBar.getItem(i3);
                itemSizes[count] = cItem.getSize();
                CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)cItem.getData());
                CoolItemPosition position = this.getRememberedPosition(cbItem.getId());
                if (position != null) {
                    rememberedAddedItems.add(cItem);
                }
                ++count;
            }
            ++i3;
        }
        this.coolBar.setRedraw(false);
        this.coolBar.setItemLayout(itemOrder, new int[0], itemSizes);
        String[] wrapItems = new String[layout.itemWrapIndices.length];
        int i4 = 0;
        while (i4 < layout.itemWrapIndices.length) {
            wrapItems[i4] = (String)layout.items.get(layout.itemWrapIndices[i4]);
            ++i4;
        }
        int[] wrapIndices = new int[wrapItems.length];
        ArrayList currentCoolItemIds = this.getCoolItemIds();
        int j = 0;
        int k = 0;
        while (k < wrapItems.length) {
            int index = currentCoolItemIds.indexOf(wrapItems[k]);
            if (index != -1) {
                wrapIndices[j] = index;
                ++j;
                ++k;
                continue;
            }
            int visualIndex = layout.items.indexOf(wrapItems[k]);
            int row = layout.getRowOfIndex(visualIndex);
            int nextIndex = visualIndex + 1;
            int nextRow = layout.getRowOfIndex(nextIndex);
            if (nextIndex < layout.items.size() && nextRow == row) {
                String nextItem;
                wrapItems[k] = nextItem = (String)layout.items.get(nextIndex);
                continue;
            }
            ++k;
        }
        int[] itemWraps = new int[j];
        System.arraycopy(wrapIndices, 0, itemWraps, 0, j);
        this.coolBar.setWrapIndices(itemWraps);
        ArrayList<CoolBarContributionItem> cbItems = new ArrayList<CoolBarContributionItem>();
        ArrayList<ToolBar> toolbars = new ArrayList<ToolBar>();
        int i5 = 0;
        while (i5 < rememberedAddedItems.size()) {
            CoolItem item = (CoolItem)rememberedAddedItems.get(i5);
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)item.getData());
            cbItems.add(cbItem);
            tBar = (ToolBar)item.getControl();
            toolbars.add(tBar);
            this.dispose(item);
            ++i5;
        }
        i5 = 0;
        while (i5 < cbItems.size()) {
            CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)cbItems.get(i5));
            CoolItemPosition position = this.getRememberedPosition(cbItem.getId());
            tBar = (ToolBar)toolbars.get(i5);
            this.createRememberedCoolItem(cbItem, tBar, position);
            ++i5;
        }
        ArrayList currentIds = this.getCoolItemIds();
        int i6 = 0;
        while (i6 < layout.items.size()) {
            String id = (String)layout.items.get(i6);
            if (!currentIds.contains(id)) {
                this.rememberPositionFor(id, layout);
            }
            ++i6;
        }
        this.coolBar.setRedraw(true);
    }

    private void setSizeFor(CoolItem coolItem) {
        this.setSizeFor(coolItem, -1);
    }

    private void setSizeFor(CoolItem coolItem, int coolWidth) {
        ToolBar toolBar = (ToolBar)coolItem.getControl();
        Point size = toolBar.computeSize(-1, -1);
        Point coolSize = coolItem.computeSize(size.x, size.y);
        coolItem.setMinimumSize(size.x, size.y);
        coolItem.setPreferredSize(coolSize);
        if (coolWidth == -1) {
            coolItem.setSize(coolSize);
        } else {
            coolItem.setSize(new Point(coolWidth, coolSize.y));
        }
    }

    public void update(boolean force) {
        if ((this.isDirty() || force) && this.coolBarExist()) {
            boolean useRedraw = false;
            CoolBarLayout layout = this.getLayout();
            IContributionItem[] items = this.getItems();
            ArrayList<CoolBarContributionItem> cbItemsToRemove = new ArrayList<CoolBarContributionItem>(items.length);
            int i = 0;
            while (i < items.length) {
                CoolBarContributionItem cbItem = (CoolBarContributionItem)items[i];
                if (cbItem.getItems().length == 0) {
                    int visualIndex;
                    CoolItem coolItem = this.findCoolItem(cbItem);
                    if (!useRedraw && coolItem != null && layout.isOnRowAlone(visualIndex = this.coolBar.indexOf(coolItem))) {
                        useRedraw = true;
                    }
                    cbItemsToRemove.add(cbItem);
                }
                ++i;
            }
            CoolItem[] coolItems = this.coolBar.getItems();
            ArrayList<CoolItem> coolItemsToRemove = new ArrayList<CoolItem>(coolItems.length);
            int i2 = 0;
            while (i2 < coolItems.length) {
                CoolItem coolItem = coolItems[i2];
                CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)coolItem.getData());
                if (cbItem != null && !cbItem.isVisible() && !cbItemsToRemove.contains((Object)cbItem)) {
                    int visualIndex;
                    if (!useRedraw && layout.isOnRowAlone(visualIndex = this.coolBar.indexOf(coolItem))) {
                        useRedraw = true;
                    }
                    coolItemsToRemove.add(coolItem);
                }
                ++i2;
            }
            if (!useRedraw && cbItemsToRemove.size() + coolItemsToRemove.size() > 2) {
                useRedraw = true;
            }
            if (useRedraw) {
                this.coolBar.setRedraw(false);
            }
            Iterator e = ((AbstractList)cbItemsToRemove).iterator();
            while (e.hasNext()) {
                CoolBarContributionItem cbItem = (CoolBarContributionItem)((Object)e.next());
                this.dispose(cbItem);
            }
            e = ((AbstractList)coolItemsToRemove).iterator();
            while (e.hasNext()) {
                CoolItem coolItem = (CoolItem)e.next();
                ToolBar tBar = (ToolBar)coolItem.getControl();
                tBar.setVisible(false);
                this.dispose(coolItem);
            }
            ArrayList coolItemIds = this.getCoolItemIds();
            items = this.getItems();
            boolean changed = false;
            boolean relock = false;
            int i3 = 0;
            while (i3 < items.length) {
                ToolBar toolBar;
                CoolBarContributionItem cbItem = (CoolBarContributionItem)items[i3];
                if (!coolItemIds.contains(cbItem.getId()) && cbItem.isVisible() && (toolBar = cbItem.getControl()) != null && !toolBar.isDisposed() && toolBar.getItemCount() > 0 && cbItem.hasDisplayableItems()) {
                    if (!changed) {
                        changed = true;
                        if (this.coolBar.getLocked()) {
                            this.coolBar.setLocked(false);
                            relock = true;
                        }
                    }
                    this.createCoolItem(cbItem, toolBar);
                }
                ++i3;
            }
            this.updateTabOrder();
            this.setDirty(false);
            if (relock) {
                this.coolBar.setLocked(true);
            }
            if (useRedraw) {
                this.coolBar.setRedraw(true);
            }
        }
    }

    void updateSizeFor(CoolBarContributionItem cbItem) {
        CoolItem coolItem = this.findCoolItem(cbItem);
        if (coolItem != null) {
            this.setSizeFor(coolItem);
        }
    }

    void updateTabOrder() {
        CoolItem[] items = this.coolBar.getItems();
        Control[] children = new Control[items.length];
        int i = 0;
        while (i < children.length) {
            children[i] = items[i].getControl();
            ++i;
        }
        this.coolBar.setTabList(children);
    }

    private class RestoreItemData {
        CoolItemPosition savedPosition;
        String beforeItemId;
        String afterItemId;
        int beforeIndex = -1;
        int afterIndex = -1;

        RestoreItemData() {
        }
    }
}

