/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.EditorAreaDropAdapter;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.IPartDropListener;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSashContainer;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;

public class EditorArea
extends PartSashContainer {
    private static final String DEFAULT_WORKBOOK_ID = "DefaultEditorWorkbook";
    private IPartDropListener partDropListener;
    private ArrayList editorWorkbooks = new ArrayList(3);
    private EditorWorkbook activeEditorWorkbook;
    private DropTarget dropTarget;
    private DropTargetAdapter dropTargetAdapter;

    public EditorArea(String editorId, IPartDropListener listener, WorkbenchPage page) {
        super(editorId, page);
        this.partDropListener = listener;
        this.dropTargetAdapter = new EditorAreaDropAdapter(page);
        this.createDefaultWorkbook();
    }

    public void addEditor(EditorPane pane) {
        EditorWorkbook workbook = this.getActiveWorkbook();
        workbook.add(pane);
    }

    protected void childAdded(LayoutPart child) {
        if (child instanceof EditorWorkbook) {
            this.editorWorkbooks.add(child);
        }
    }

    protected void childRemoved(LayoutPart child) {
        if (child instanceof EditorWorkbook) {
            ((AbstractCollection)this.editorWorkbooks).remove(child);
            if (this.activeEditorWorkbook == child) {
                this.setActiveWorkbook(null, false);
            }
        }
    }

    protected EditorWorkbook createDefaultWorkbook() {
        EditorWorkbook newWorkbook = new EditorWorkbook(this);
        newWorkbook.setID(DEFAULT_WORKBOOK_ID);
        this.add(newWorkbook);
        return newWorkbook;
    }

    protected Composite createParent(Composite parentWidget) {
        return new Composite(parentWidget, 0);
    }

    public void dispose() {
        Iterator iter = ((AbstractList)this.editorWorkbooks).iterator();
        while (iter.hasNext()) {
            EditorWorkbook wb = (EditorWorkbook)iter.next();
            wb.dispose();
        }
        this.editorWorkbooks.clear();
        super.dispose();
    }

    protected void disposeParent() {
        this.parent.dispose();
    }

    public EditorWorkbook getActiveWorkbook() {
        if (this.activeEditorWorkbook == null) {
            if (this.editorWorkbooks.size() < 1) {
                this.setActiveWorkbook(this.createDefaultWorkbook(), false);
            } else {
                this.setActiveWorkbook((EditorWorkbook)this.editorWorkbooks.get(0), false);
            }
        }
        return this.activeEditorWorkbook;
    }

    public String getActiveWorkbookID() {
        return this.getActiveWorkbook().getID();
    }

    public ArrayList getEditorWorkbooks() {
        return (ArrayList)this.editorWorkbooks.clone();
    }

    public int getEditorWorkbookCount() {
        return this.editorWorkbooks.size();
    }

    public IPartDropListener getPartDropListener() {
        return this.partDropListener;
    }

    protected boolean isActiveWorkbook(EditorWorkbook workbook) {
        return this.activeEditorWorkbook == workbook;
    }

    public void findSashes(LayoutPart pane, PartPane.Sashes sashes) {
        super.findSashes(pane, sashes);
        this.getRootContainer().findSashes(this, sashes);
    }

    public void removeAllEditors() {
        EditorWorkbook currentWorkbook = this.getActiveWorkbook();
        Iterator workbooks = ((AbstractList)((ArrayList)this.editorWorkbooks.clone())).iterator();
        while (workbooks.hasNext()) {
            EditorWorkbook workbook = (EditorWorkbook)workbooks.next();
            workbook.removeAll();
            if (workbook == currentWorkbook) continue;
            this.remove(workbook);
            workbook.dispose();
        }
    }

    public void removeEditor(EditorPane pane) {
        EditorWorkbook workbook = pane.getWorkbook();
        if (workbook == null) {
            return;
        }
        workbook.remove(pane);
        if (workbook.getItemCount() < 1 && this.editorWorkbooks.size() > 1) {
            this.remove(workbook);
            workbook.dispose();
        }
    }

    public IStatus restoreState(IMemento memento) {
        if (this.children != null) {
            EditorWorkbook defaultWorkbook = null;
            int i = 0;
            while (i < this.children.size()) {
                LayoutPart child = (LayoutPart)this.children.get(i);
                if (child.getID() == DEFAULT_WORKBOOK_ID && (defaultWorkbook = (EditorWorkbook)child).getItemCount() > 0) {
                    defaultWorkbook = null;
                }
                ++i;
            }
            if (defaultWorkbook != null) {
                this.remove(defaultWorkbook);
            }
        }
        IMemento[] infos = memento.getChildren("info");
        HashMap<String, EditorWorkbook> mapIDtoPart = new HashMap<String, EditorWorkbook>(infos.length);
        int i = 0;
        while (i < infos.length) {
            IMemento childMem = infos[i];
            String partID = childMem.getString("part");
            String relativeID = childMem.getString("relative");
            int relationship = 0;
            float ratio = 0.0f;
            if (relativeID != null) {
                relationship = childMem.getInteger("relationship");
                ratio = childMem.getFloat("ratio").floatValue();
            }
            EditorWorkbook workbook = new EditorWorkbook(this);
            workbook.setID(partID);
            workbook.setContainer(this);
            if (relativeID == null) {
                this.add(workbook);
            } else {
                LayoutPart refPart = (LayoutPart)mapIDtoPart.get(relativeID);
                if (refPart != null) {
                    this.add(workbook, relationship, ratio, refPart);
                } else {
                    WorkbenchPlugin.log("Unable to find part for ID: " + relativeID);
                }
            }
            mapIDtoPart.put(partID, workbook);
            ++i;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus saveState(IMemento memento) {
        PartSashContainer.RelationshipInfo[] relationships = this.computeRelation();
        int i = 0;
        while (i < relationships.length) {
            PartSashContainer.RelationshipInfo info = relationships[i];
            IMemento childMem = memento.createChild("info");
            childMem.putString("part", info.part.getID());
            if (info.relative != null) {
                childMem.putString("relative", info.relative.getID());
                childMem.putInteger("relationship", info.relationship);
                childMem.putFloat("ratio", info.ratio);
            }
            ++i;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public void setActiveWorkbook(EditorWorkbook newWorkbook, boolean hasFocus) {
        EditorWorkbook oldWorkbook = this.activeEditorWorkbook;
        this.activeEditorWorkbook = newWorkbook;
        if (oldWorkbook != null && oldWorkbook != newWorkbook) {
            oldWorkbook.tabFocusHide();
        }
        if (newWorkbook != null) {
            newWorkbook.tabFocusShow(hasFocus);
        }
        this.updateTabList();
    }

    public void setActiveWorkbookFromID(String id) {
        int i = 0;
        while (i < this.editorWorkbooks.size()) {
            EditorWorkbook workbook = (EditorWorkbook)this.editorWorkbooks.get(i);
            if (workbook.getID().equals(id)) {
                this.setActiveWorkbook(workbook, false);
            }
            ++i;
        }
    }

    public void updateTabList() {
        Composite parent = this.getParent();
        if (parent != null) {
            EditorWorkbook wb = this.getActiveWorkbook();
            if (wb == null) {
                parent.setTabList(new Control[0]);
            } else {
                parent.setTabList(wb.getTabList());
            }
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.addDropSupport();
    }

    private void addDropSupport() {
        if (this.dropTarget == null) {
            Transfer[] types = new Transfer[]{EditorInputTransfer.getInstance(), ResourceTransfer.getInstance(), MarkerTransfer.getInstance()};
            this.dropTarget = new DropTarget(this.getControl(), 16);
            this.dropTarget.setTransfer(types);
            this.dropTarget.addDropListener((DropTargetListener)this.dropTargetAdapter);
        }
    }
}

