/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.WWinKeyBindingService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.misc.Assert;

public class KeyBindingService
implements IKeyBindingService {
    private HashMap defIdToAction = new HashMap();
    private String[] scopeIds = new String[]{"org.eclipse.ui.globalScope"};
    private WWinKeyBindingService parent;

    public KeyBindingService(WWinKeyBindingService service, PartSite site) {
        EditorActionBuilder.ExternalContributor contributor;
        this.parent = service;
        if (site instanceof EditorSite && (contributor = (EditorActionBuilder.ExternalContributor)((EditorSite)site).getExtensionActionBarContributor()) != null) {
            this.registerExtendedActions(contributor.getExtendedActions());
        }
    }

    public void registerExtendedActions(ActionDescriptor[] actionDescriptors) {
        int i = 0;
        while (i < actionDescriptors.length) {
            PluginAction action = actionDescriptors[i].getAction();
            if (action.getActionDefinitionId() != null) {
                this.registerAction((IAction)action);
            }
            ++i;
        }
    }

    public String[] getScopeIds() {
        return (String[])this.scopeIds.clone();
    }

    public void setScopeIds(String[] scopeIds) throws IllegalArgumentException {
        if (scopeIds == null || scopeIds.length < 1) {
            throw new IllegalArgumentException();
        }
        this.scopeIds = (String[])scopeIds.clone();
        int i = 0;
        while (i < scopeIds.length) {
            if (scopeIds[i] == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
    }

    public void registerAction(IAction action) {
        String defId = action.getActionDefinitionId();
        Assert.isNotNull(defId, "All registered action must have a definition id");
        this.defIdToAction.put(defId, action);
    }

    public void unregisterAction(IAction action) {
        String defId = action.getActionDefinitionId();
        Assert.isNotNull(defId, "All registered action must have a definition id");
        this.defIdToAction.remove(defId);
    }

    public IAction getAction(String definitionId) {
        IAction action = (IAction)this.defIdToAction.get(definitionId);
        if (action == null) {
            action = (IAction)this.parent.getMapping().get(definitionId);
        }
        return action;
    }

    public String getActiveAcceleratorConfigurationId() {
        return ((Workbench)PlatformUI.getWorkbench()).getActiveAcceleratorConfiguration().getId();
    }

    public String getActiveAcceleratorScopeId() {
        return this.getScopeIds()[0];
    }

    public void setActiveAcceleratorScopeId(String scopeId) throws IllegalArgumentException {
        this.setScopeIds(new String[]{scopeId});
    }

    public boolean processKey(KeyEvent event) {
        return false;
    }

    public void enable(boolean enable) {
    }
}

