/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class KeyTable {
    private Shell shell;
    private int[] keys;
    private Menu menu;
    private MenuItem menuItem;
    private KeyTableListener keyTableListener;

    public KeyTable(Shell shell) {
        this.shell = shell;
        this.initMenu();
    }

    public void initMenu() {
        Menu parent = this.shell.getMenuBar();
        if (parent == null || parent.getItemCount() < 1) {
            throw new SWTException();
        }
        MenuItem parentItem = parent.getItem(parent.getItemCount() - 1);
        final Menu child = parentItem.getMenu();
        if (child == null) {
            throw new SWTException();
        }
        this.menuItem = new MenuItem(child, 64, 0);
        this.menu = new Menu(this.menuItem);
        this.menuItem.setMenu(this.menu);
        child.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                if (KeyTable.this.menuItem == null || KeyTable.this.menuItem.isDisposed()) {
                    return;
                }
                KeyTable.this.menuItem.setMenu(null);
                KeyTable.this.menuItem.dispose();
            }
        });
        child.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                if (KeyTable.this.menuItem == null || KeyTable.this.menuItem.isDisposed()) {
                    KeyTable.this.menuItem = new MenuItem(child, 64, 0);
                    KeyTable.this.menuItem.setMenu(KeyTable.this.menu);
                }
            }
        });
    }

    public void addKeyTableListener(KeyTableListener keyTableListener) {
        this.keyTableListener = keyTableListener;
    }

    public void removeKeyTableListener(KeyTableListener keyTableListener) {
    }

    void handleEvent(Event event) {
        MenuItem eventMenuItem = (MenuItem)event.widget;
        int key = eventMenuItem.getAccelerator();
        if (this.keyTableListener != null) {
            this.keyTableListener.keyPressed(key);
        }
    }

    public int[] getKeys() {
        if (this.keys == null) {
            return null;
        }
        int[] keys = new int[this.keys.length];
        System.arraycopy(this.keys, 0, keys, 0, this.keys.length);
        return keys;
    }

    public void setKeys(int[] keys) {
        if (keys == null) {
            this.keys = null;
        } else {
            this.keys = new int[keys.length];
            System.arraycopy(keys, 0, this.keys, 0, keys.length);
        }
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        if (this.menuItem == null || this.menuItem.isDisposed()) {
            this.initMenu();
        } else {
            this.menu = new Menu(this.menuItem);
            this.menuItem.setMenu(this.menu);
        }
        int i = 0;
        while (i < keys.length) {
            int key = keys[i];
            MenuItem keyMenuItem = new MenuItem(this.menu, 8);
            keyMenuItem.setAccelerator(key);
            keyMenuItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    KeyTable.this.handleEvent(event);
                }
            });
            ++i;
        }
    }

    public interface KeyTableListener {
        public void keyPressed(int var1);
    }
}

