/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class NavigationHistoryEntry {
    private IWorkbenchPage page;
    protected String editorID;
    protected IEditorInput editorInput;
    private IMemento memento;
    protected NavigationHistoryEntry mementoEntry;
    protected String historyText;
    protected INavigationLocation location;
    private IMemento locationMemento;

    public NavigationHistoryEntry(IWorkbenchPage page, IEditorPart part, INavigationLocation location) {
        this.page = page;
        this.editorID = part.getSite().getId();
        this.editorInput = part.getEditorInput();
        this.location = location;
        if (location != null) {
            this.historyText = location.getText();
        }
        if (this.historyText == null || this.historyText.equals("")) {
            this.historyText = part.getTitle();
        }
    }

    protected NavigationHistoryEntry(IWorkbenchPage page) {
        this.page = page;
    }

    void restoreLocation() {
        if (this.editorInput == null) {
            if (this.memento != null) {
                this.restoreEditor(this.memento);
                this.memento = null;
            } else if (this.mementoEntry != null) {
                if (this.mementoEntry.memento != null) {
                    this.mementoEntry.restoreEditor(this.mementoEntry.memento);
                    this.mementoEntry.memento = null;
                }
                this.editorID = this.mementoEntry.editorID;
                this.editorInput = this.mementoEntry.editorInput;
                this.mementoEntry = null;
            }
        }
        if (this.editorInput != null && this.editorID != null) {
            try {
                IEditorPart editor = this.page.openEditor(this.editorInput, this.editorID, true);
                if (this.location == null && editor instanceof INavigationLocationProvider) {
                    this.location = ((INavigationLocationProvider)((Object)editor)).createEmptyNavigationLocation();
                }
                if (this.location != null) {
                    if (this.locationMemento != null) {
                        this.location.setInput(this.editorInput);
                        this.location.restoreState(this.locationMemento);
                        this.locationMemento = null;
                    }
                    this.location.restoreLocation();
                }
            }
            catch (PartInitException partInitException) {}
        }
    }

    boolean isPersistable() {
        if (this.editorInput != null) {
            IPersistableElement persistable = this.editorInput.getPersistable();
            return persistable != null;
        }
        return this.memento != null || this.mementoEntry != null;
    }

    String getHistoryText() {
        if (this.location != null) {
            String text = this.location.getText();
            if (text == null || text.equals("")) {
                text = this.historyText;
            } else {
                this.historyText = text;
            }
            return text;
        }
        return this.historyText;
    }

    boolean handlePartClosed() {
        if (!this.isPersistable()) {
            return false;
        }
        if (this.mementoEntry == null && this.memento == null) {
            IPersistableElement persistable = this.editorInput.getPersistable();
            this.memento = XMLMemento.createWriteRoot("editor");
            this.memento.putString("id", this.editorID);
            this.memento.putString("factoryID", persistable.getFactoryId());
            persistable.saveState(this.memento);
        }
        if (this.location != null) {
            this.locationMemento = XMLMemento.createWriteRoot("position");
            this.location.saveState(this.locationMemento);
            this.location.releaseState();
        }
        this.editorID = null;
        this.editorInput = null;
        return true;
    }

    void saveState(IMemento mem, ArrayList entries) {
        mem.putString("historyLabel", this.getHistoryText());
        if (this.editorInput != null) {
            int mementoEntryIndex = -1;
            int size = entries.size();
            int i = 0;
            while (i < size) {
                NavigationHistoryEntry entry = (NavigationHistoryEntry)entries.get(i);
                if (entry == this) break;
                if (this.editorInput.equals(entry.editorInput) && this.editorID.equals(entry.editorID)) {
                    mementoEntryIndex = i;
                    break;
                }
                ++i;
            }
            if (mementoEntryIndex >= 0) {
                IMemento childMem = mem.createChild("index");
                childMem.putInteger("index", mementoEntryIndex);
            } else {
                IPersistableElement persistable = this.editorInput.getPersistable();
                IMemento childMem = mem.createChild("editor");
                childMem.putString("id", this.editorID);
                childMem.putString("factoryID", persistable.getFactoryId());
                persistable.saveState(childMem);
            }
        } else if (this.memento != null) {
            IMemento childMem = mem.createChild("editor");
            childMem.putMemento(this.memento);
        } else {
            int mementoEntryIndex = entries.indexOf(this.mementoEntry);
            IMemento childMem = mem.createChild("index");
            childMem.putInteger("index", mementoEntryIndex);
        }
        if (this.locationMemento != null) {
            IMemento childMem = mem.createChild("position");
            childMem.putMemento(this.locationMemento);
        } else if (this.location != null) {
            IMemento childMem = mem.createChild("position");
            this.location.saveState(childMem);
        }
    }

    void restoreState(IMemento mem, ArrayList entries) {
        this.historyText = mem.getString("historyLabel");
        this.memento = mem.getChild("editor");
        this.locationMemento = mem.getChild("position");
        IMemento childMem = mem.getChild("index");
        if (childMem != null) {
            Integer index = childMem.getInteger("index");
            if (index >= 0) {
                this.mementoEntry = (NavigationHistoryEntry)entries.get(index);
            }
            this.memento = null;
        }
    }

    private void restoreEditor(IMemento memento) {
        IAdaptable element;
        String factoryID = memento.getString("factoryID");
        IElementFactory factory = WorkbenchPlugin.getDefault().getElementFactory(factoryID);
        if (factory != null && (element = factory.createElement(memento)) instanceof IEditorInput) {
            this.editorInput = (IEditorInput)element;
            this.editorID = memento.getString("id");
        }
    }

    public String toString() {
        return "Input<" + this.editorInput + "> Input<" + this.editorInput + "> Details<" + this.location + ">";
    }

    void dispose() {
        if (this.location != null) {
            this.location.dispose();
        }
    }

    boolean mergeInto(NavigationHistoryEntry currentEntry) {
        if (this.editorInput != null && this.editorInput.equals(currentEntry.editorInput) && this.location != null) {
            if (currentEntry.location == null) {
                currentEntry.location = this.location;
                return true;
            }
            return this.location.mergeInto(currentEntry.location);
        }
        return false;
    }
}

