/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.CTabPartDragDrop;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.IPartDropListener;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartDragDrop;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IViewDescriptor;

public class PartTabFolder
extends LayoutPart
implements ILayoutContainer {
    private static int tabLocation = -1;
    private CTabFolder tabFolder;
    private Map mapTabToPart = new HashMap();
    private LayoutPart current;
    private Map mapPartToDragMonitor = new HashMap();
    private boolean assignFocusOnSelection = true;
    private LayoutPart inactiveCurrent;
    private Composite parent;
    private boolean active = false;
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            CTabItem oldItem;
            CTabItem newItem = PartTabFolder.this.tabFolder.getItem(new Point(e.x, e.y));
            if (newItem != null && newItem != (oldItem = PartTabFolder.this.tabFolder.getSelection())) {
                return;
            }
            if (PartTabFolder.this.current != null) {
                PartTabFolder.this.current.setFocus();
            }
        }
    };
    TabInfo[] invisibleChildren;

    public PartTabFolder() {
        super("PartTabFolder");
        this.setID(this.toString());
        if (tabLocation == -1) {
            tabLocation = this.getPreferenceStore().getInt("VIEW_TAB_POSITION");
        }
    }

    public void add(String name, int index, LayoutPart part) {
        if (this.active && !(part instanceof PartPlaceholder)) {
            CTabItem tab = this.createPartTab(part, name, index);
            index = this.tabFolder.indexOf(tab);
            this.setSelection(index);
        } else {
            TabInfo info = new TabInfo();
            info.tabText = name;
            info.part = part;
            this.invisibleChildren = this.arrayAdd(this.invisibleChildren, info, index);
            if (this.active) {
                part.setContainer(this);
            }
        }
    }

    public void add(LayoutPart child) {
        int index = this.getItemCount();
        String label = "";
        if (child instanceof PartPane) {
            WorkbenchPartReference ref = (WorkbenchPartReference)((PartPane)child).getPartReference();
            label = ref.getRegisteredName();
        }
        this.add(label, index, child);
    }

    public boolean allowsBorder() {
        return this.mapTabToPart.size() <= 1;
    }

    private TabInfo[] arrayAdd(TabInfo[] array, TabInfo item, int index) {
        if (item == null) {
            return array;
        }
        TabInfo[] result = null;
        if (array == null) {
            result = new TabInfo[]{item};
        } else {
            if (index >= array.length) {
                index = array.length;
            }
            result = new TabInfo[array.length + 1];
            System.arraycopy(array, 0, result, 0, index);
            result[index] = item;
            System.arraycopy(array, index, result, index + 1, array.length - index);
        }
        return result;
    }

    private TabInfo[] arrayRemove(TabInfo[] array, LayoutPart item) {
        if (item == null) {
            return array;
        }
        TabInfo[] result = null;
        int index = -1;
        int i = 0;
        int length = array.length;
        while (i < length) {
            if (item == array[i].part) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return array;
        }
        if (array.length > 1) {
            result = new TabInfo[array.length - 1];
            System.arraycopy(array, 0, result, 0, index);
            System.arraycopy(array, index + 1, result, index, result.length - index);
        }
        return result;
    }

    protected static Rectangle calculatePageBounds(CTabFolder folder) {
        if (folder == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bounds = folder.getBounds();
        Rectangle offset = folder.getClientArea();
        bounds.x += offset.x;
        bounds.y += offset.y;
        bounds.width = offset.width;
        bounds.height = offset.height;
        return bounds;
    }

    public void createControl(Composite parent) {
        if (this.tabFolder != null) {
            return;
        }
        this.parent = parent;
        this.tabFolder = new CTabFolder(parent, tabLocation | 0x800);
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LayoutPart item = (LayoutPart)PartTabFolder.this.mapTabToPart.get(e.item);
                if (item != null) {
                    PartTabFolder.this.setSelection(item);
                    if (PartTabFolder.this.assignFocusOnSelection) {
                        item.setFocus();
                    }
                }
            }
        });
        this.tabFolder.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                PartTabFolder.this.setControlSize();
            }
        });
        this.tabFolder.addMouseListener(this.mouseListener);
        this.tabFolder.setData((Object)this);
        if (this.invisibleChildren != null) {
            TabInfo[] stillInactive = new TabInfo[]{};
            int tabCount = 0;
            int i = 0;
            int length = this.invisibleChildren.length;
            while (i < length) {
                if (this.invisibleChildren[i].part instanceof PartPlaceholder) {
                    this.invisibleChildren[i].part.setContainer(this);
                    TabInfo[] newStillInactive = new TabInfo[stillInactive.length + 1];
                    System.arraycopy(stillInactive, 0, newStillInactive, 0, stillInactive.length);
                    newStillInactive[stillInactive.length] = this.invisibleChildren[i];
                    stillInactive = newStillInactive;
                } else {
                    this.createPartTab(this.invisibleChildren[i].part, this.invisibleChildren[i].tabText, tabCount);
                    ++tabCount;
                }
                ++i;
            }
            this.invisibleChildren = stillInactive;
        }
        this.active = true;
        if (this.getItemCount() > 0) {
            int newPage = 0;
            if (this.current != null) {
                newPage = this.indexOf(this.current);
            }
            this.setSelection(newPage);
        }
    }

    private CTabItem createPartTab(LayoutPart part, String tabName, int tabIndex) {
        CTabItem tabItem = tabIndex < 0 ? new CTabItem(this.tabFolder, 0) : new CTabItem(this.tabFolder, 0, tabIndex);
        tabItem.setText(tabName);
        this.mapTabToPart.put(tabItem, part);
        part.createControl(this.parent);
        part.setContainer(this);
        if (this.mapTabToPart.size() == 2) {
            Iterator parts = this.mapTabToPart.values().iterator();
            ((LayoutPart)parts.next()).setContainer(this);
            ((LayoutPart)parts.next()).setContainer(this);
        }
        return tabItem;
    }

    public void disableDrag(LayoutPart part) {
        PartDragDrop partDragDrop = (PartDragDrop)this.mapPartToDragMonitor.get(part);
        if (partDragDrop != null) {
            partDragDrop.dispose();
            this.mapPartToDragMonitor.remove(part);
        }
        if (this.mapPartToDragMonitor.size() == 1 && (partDragDrop = (PartDragDrop)this.mapPartToDragMonitor.get(this)) != null) {
            partDragDrop.dispose();
            this.mapPartToDragMonitor.remove(this);
        }
    }

    public void dispose() {
        if (!this.active) {
            return;
        }
        TabInfo[] newInvisibleChildren = new TabInfo[this.mapTabToPart.size()];
        if (this.invisibleChildren != null) {
            newInvisibleChildren = new TabInfo[newInvisibleChildren.length + this.invisibleChildren.length];
            System.arraycopy(this.invisibleChildren, 0, newInvisibleChildren, this.mapTabToPart.size(), this.invisibleChildren.length);
        }
        Iterator keys = this.mapTabToPart.keySet().iterator();
        while (keys.hasNext()) {
            CTabItem item = (CTabItem)keys.next();
            LayoutPart part = (LayoutPart)this.mapTabToPart.get(item);
            TabInfo info = new TabInfo();
            info.tabText = item.getText();
            info.part = part;
            newInvisibleChildren[this.tabFolder.indexOf((CTabItem)item)] = info;
            this.disableDrag(part);
        }
        this.invisibleChildren = newInvisibleChildren;
        if (this.invisibleChildren != null) {
            int i = 0;
            int length = this.invisibleChildren.length;
            while (i < length) {
                this.invisibleChildren[i].part.setContainer(null);
                ++i;
            }
        }
        this.mapTabToPart.clear();
        if (this.tabFolder != null) {
            this.tabFolder.dispose();
        }
        this.tabFolder = null;
        this.active = false;
    }

    public void enableDrag(ViewPane pane, IPartDropListener listener) {
        if (this.mapPartToDragMonitor.containsKey(pane)) {
            return;
        }
        CTabItem tab = this.getTab(pane);
        if (tab == null) {
            return;
        }
        CTabPartDragDrop dragSource = new CTabPartDragDrop(pane, this.tabFolder, tab);
        this.mapPartToDragMonitor.put(pane, dragSource);
        dragSource.addDropListener(listener);
        if (this.mapPartToDragMonitor.size() == 1) {
            dragSource = new CTabPartDragDrop(this, this.tabFolder, null);
            this.mapPartToDragMonitor.put(this, dragSource);
            dragSource.addDropListener(listener);
        }
    }

    public void openTracker(LayoutPart part) {
        CTabPartDragDrop dnd = (CTabPartDragDrop)this.mapPartToDragMonitor.get(part);
        dnd.openTracker();
    }

    public Rectangle getBounds() {
        return this.tabFolder.getBounds();
    }

    public int getMinimumHeight() {
        if (this.current == null || this.tabFolder == null || this.tabFolder.isDisposed()) {
            return super.getMinimumHeight();
        }
        if (this.getItemCount() > 1) {
            Rectangle trim = this.tabFolder.computeTrim(0, 0, 0, this.current.getMinimumHeight());
            return trim.height;
        }
        return this.current.getMinimumHeight();
    }

    public LayoutPart[] getChildren() {
        int count;
        LayoutPart[] children = new LayoutPart[]{};
        if (this.invisibleChildren != null) {
            children = new LayoutPart[this.invisibleChildren.length];
            int i = 0;
            int length = this.invisibleChildren.length;
            while (i < length) {
                children[i] = this.invisibleChildren[i].part;
                ++i;
            }
        }
        if ((count = this.mapTabToPart.size()) > 0) {
            int index = children.length;
            LayoutPart[] newChildren = new LayoutPart[children.length + count];
            System.arraycopy(children, 0, newChildren, 0, children.length);
            children = newChildren;
            int nX = 0;
            while (nX < count) {
                CTabItem tabItem = this.tabFolder.getItem(nX);
                children[index] = (LayoutPart)this.mapTabToPart.get(tabItem);
                ++index;
                ++nX;
            }
        }
        return children;
    }

    public Control getControl() {
        return this.tabFolder;
    }

    public int getItemCount() {
        if (this.active) {
            return this.tabFolder.getItemCount();
        }
        if (this.invisibleChildren != null) {
            return this.invisibleChildren.length;
        }
        return 0;
    }

    public Composite getParent() {
        return this.tabFolder.getParent();
    }

    public int getSelection() {
        if (!this.active) {
            return 0;
        }
        return this.tabFolder.getSelectionIndex();
    }

    private CTabItem getTab(LayoutPart child) {
        Iterator tabs = this.mapTabToPart.keySet().iterator();
        while (tabs.hasNext()) {
            CTabItem tab = (CTabItem)tabs.next();
            if (this.mapTabToPart.get(tab) != child) continue;
            return tab;
        }
        return null;
    }

    public LayoutPart getVisiblePart() {
        if (this.current == null) {
            return this.inactiveCurrent;
        }
        return this.current;
    }

    public int indexOf(LayoutPart item) {
        Iterator keys = this.mapTabToPart.keySet().iterator();
        while (keys.hasNext()) {
            CTabItem tab = (CTabItem)keys.next();
            LayoutPart part = (LayoutPart)this.mapTabToPart.get(tab);
            if (!part.equals(item)) continue;
            return this.tabFolder.indexOf(tab);
        }
        return 0;
    }

    public void remove(LayoutPart child) {
        if (this.active && !(child instanceof PartPlaceholder)) {
            Iterator keys = this.mapTabToPart.keySet().iterator();
            while (keys.hasNext()) {
                CTabItem key = (CTabItem)keys.next();
                if (!this.mapTabToPart.get(key).equals(child)) continue;
                this.removeTab(key);
                break;
            }
        } else if (this.invisibleChildren != null) {
            this.invisibleChildren = this.arrayRemove(this.invisibleChildren, child);
        }
        if (this.active) {
            child.setVisible(false);
            child.setContainer(null);
        }
    }

    private void removeTab(CTabItem tab) {
        LayoutPart part = (LayoutPart)this.mapTabToPart.get(tab);
        if (part != null) {
            this.disableDrag(part);
        }
        this.assignFocusOnSelection = false;
        this.mapTabToPart.remove(tab);
        tab.dispose();
        this.assignFocusOnSelection = true;
        if (this.mapTabToPart.size() == 1) {
            Iterator parts = this.mapTabToPart.values().iterator();
            ((LayoutPart)parts.next()).setContainer(this);
        }
    }

    public void reorderTab(ViewPane pane, int x, int y) {
        int targetIndex;
        CTabItem targetTab;
        CTabItem sourceTab = this.getTab(pane);
        if (sourceTab == null) {
            return;
        }
        Point location = new Point(1, 1);
        if ((this.tabFolder.getStyle() & 0x400) != 0) {
            location.y = this.tabFolder.getSize().y - 4;
        }
        if (x > location.x) {
            location.x = x;
        }
        if ((targetTab = this.tabFolder.getItem(location)) == null) {
            if (this.tabFolder.indexOf(sourceTab) != this.tabFolder.getItemCount() - 1) {
                this.reorderTab(pane, sourceTab, -1);
            }
            return;
        }
        if (targetTab == sourceTab) {
            return;
        }
        int sourceIndex = this.tabFolder.indexOf(sourceTab);
        if (sourceIndex == (targetIndex = this.tabFolder.indexOf(targetTab)) - 1) {
            return;
        }
        this.reorderTab(pane, sourceTab, targetIndex);
    }

    private void reorderTab(ViewPane pane, CTabItem sourceTab, int newIndex) {
        boolean wasVisible = this.tabFolder.getSelection() == sourceTab;
        CTabItem newTab = newIndex < 0 ? new CTabItem(this.tabFolder, 0) : new CTabItem(this.tabFolder, 0, newIndex);
        this.mapTabToPart.put(newTab, pane);
        CTabPartDragDrop partDragDrop = (CTabPartDragDrop)this.mapPartToDragMonitor.get(pane);
        partDragDrop.setTab(newTab);
        String sourceLabel = sourceTab.getText();
        this.mapTabToPart.remove(sourceTab);
        this.assignFocusOnSelection = false;
        sourceTab.dispose();
        this.assignFocusOnSelection = true;
        newTab.setText(sourceLabel);
        if (wasVisible) {
            this.tabFolder.setSelection(newTab);
            this.setSelection(pane);
            pane.setFocus();
        }
    }

    public void reparent(Composite newParent) {
        if (!newParent.isReparentable()) {
            return;
        }
        Control control = this.getControl();
        if (control == null || control.getParent() == newParent) {
            return;
        }
        super.reparent(newParent);
        Iterator iterator = this.mapTabToPart.values().iterator();
        while (iterator.hasNext()) {
            ((LayoutPart)iterator.next()).reparent(newParent);
        }
    }

    public void replace(LayoutPart oldChild, LayoutPart newChild) {
        if (oldChild instanceof PartPlaceholder && !(newChild instanceof PartPlaceholder)) {
            this.replaceChild((PartPlaceholder)oldChild, newChild);
            return;
        }
        if (!(oldChild instanceof PartPlaceholder) && newChild instanceof PartPlaceholder) {
            this.replaceChild(oldChild, (PartPlaceholder)newChild);
            return;
        }
    }

    private void replaceChild(LayoutPart oldChild, PartPlaceholder newChild) {
        if (this.active) {
            Iterator keys = this.mapTabToPart.keySet().iterator();
            while (keys.hasNext()) {
                CTabItem key = (CTabItem)keys.next();
                LayoutPart part = (LayoutPart)this.mapTabToPart.get(key);
                if (part != oldChild) continue;
                boolean partIsActive = this.current == oldChild;
                TabInfo info = new TabInfo();
                info.part = newChild;
                info.tabText = key.getText();
                this.removeTab(key);
                int index = 0;
                if (this.invisibleChildren != null) {
                    index = this.invisibleChildren.length;
                }
                this.invisibleChildren = this.arrayAdd(this.invisibleChildren, info, index);
                oldChild.setVisible(false);
                oldChild.setContainer(null);
                newChild.setContainer(this);
                if (this.tabFolder.getItemCount() <= 0 || partIsActive) break;
                this.setControlSize();
                break;
            }
        } else if (this.invisibleChildren != null) {
            int i = 0;
            int length = this.invisibleChildren.length;
            while (i < length) {
                if (this.invisibleChildren[i].part == oldChild) {
                    this.invisibleChildren[i].part = newChild;
                }
                ++i;
            }
        }
    }

    private void replaceChild(PartPlaceholder oldChild, LayoutPart newChild) {
        if (this.invisibleChildren == null) {
            return;
        }
        int i = 0;
        int length = this.invisibleChildren.length;
        while (i < length) {
            if (this.invisibleChildren[i].part == oldChild) {
                if (this.active) {
                    TabInfo info = this.invisibleChildren[i];
                    this.invisibleChildren = this.arrayRemove(this.invisibleChildren, oldChild);
                    oldChild.setContainer(null);
                    if (newChild instanceof PartPane) {
                        WorkbenchPartReference ref = (WorkbenchPartReference)((PartPane)newChild).getPartReference();
                        info.tabText = ref.getRegisteredName();
                    }
                    CTabItem item = this.createPartTab(newChild, info.tabText, -1);
                    int index = this.tabFolder.indexOf(item);
                    this.setSelection(index);
                    break;
                }
                this.invisibleChildren[i].part = newChild;
                if (this.inactiveCurrent == null || this.inactiveCurrent != oldChild) break;
                this.current = newChild;
                this.inactiveCurrent = null;
                break;
            }
            ++i;
        }
    }

    public IStatus restoreState(IMemento memento) {
        String activeTabID = memento.getString("activePageID");
        IMemento[] children = memento.getChildren("page");
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IMemento childMem = children[i];
                String partID = childMem.getString("content");
                String tabText = childMem.getString("label");
                IViewDescriptor descriptor = WorkbenchPlugin.getDefault().getViewRegistry().find(partID);
                if (descriptor != null) {
                    tabText = descriptor.getLabel();
                }
                PartPlaceholder part = new PartPlaceholder(partID);
                this.add(tabText, i, part);
                part.setContainer(this);
                if (partID.equals(activeTabID)) {
                    this.inactiveCurrent = part;
                }
                ++i;
            }
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus saveState(IMemento memento) {
        block11: {
            block10: {
                if (this.current != null) {
                    memento.putString("activePageID", this.current.getID());
                }
                if (this.mapTabToPart.size() != 0) break block10;
                if (this.invisibleChildren == null) break block11;
                int i = 0;
                while (i < this.invisibleChildren.length) {
                    TabInfo info = this.invisibleChildren[i];
                    IMemento childMem = memento.createChild("page");
                    childMem.putString("label", info.tabText);
                    childMem.putString("content", info.part.getID());
                    ++i;
                }
                break block11;
            }
            LayoutPart[] children = this.getChildren();
            CTabItem[] keys = new CTabItem[this.mapTabToPart.size()];
            this.mapTabToPart.keySet().toArray(keys);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    IMemento childMem = memento.createChild("page");
                    childMem.putString("content", children[i].getID());
                    boolean found = false;
                    int j = 0;
                    while (j < keys.length) {
                        if (this.mapTabToPart.get(keys[j]) == children[i]) {
                            childMem.putString("label", keys[j].getText());
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        j = 0;
                        while (j < this.invisibleChildren.length) {
                            if (this.invisibleChildren[j].part == children[i]) {
                                childMem.putString("label", this.invisibleChildren[j].tabText);
                                found = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!found) {
                        childMem.putString("label", "LabelNotFound");
                    }
                    ++i;
                }
            }
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public void setBounds(Rectangle r) {
        if (this.tabFolder != null) {
            this.tabFolder.setBounds(r);
        }
        this.setControlSize();
    }

    private void setControlSize() {
        if (this.current == null || this.tabFolder == null) {
            return;
        }
        Rectangle bounds = this.mapTabToPart.size() > 1 ? PartTabFolder.calculatePageBounds(this.tabFolder) : this.tabFolder.getBounds();
        this.current.setBounds(bounds);
        this.current.moveAbove((Control)this.tabFolder);
    }

    public void setSelection(int index) {
        if (!this.active) {
            return;
        }
        if (this.mapTabToPart.size() == 0) {
            this.setSelection(null);
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > this.mapTabToPart.size() - 1) {
            index = this.mapTabToPart.size() - 1;
        }
        this.tabFolder.setSelection(index);
        CTabItem item = this.tabFolder.getItem(index);
        LayoutPart part = (LayoutPart)this.mapTabToPart.get(item);
        this.setSelection(part);
    }

    private void setSelection(LayoutPart part) {
        if (!this.active) {
            return;
        }
        if (part instanceof PartPlaceholder) {
            return;
        }
        if (this.current != null && this.current != part) {
            this.current.setVisible(false);
        }
        this.current = part;
        if (this.current != null) {
            this.setControlSize();
            this.current.setVisible(true);
        }
    }

    public LayoutPart targetPartFor(LayoutPart dragSource) {
        return this;
    }

    private class TabInfo {
        private String tabText;
        private LayoutPart part;

        TabInfo() {
        }
    }
}

