/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionSetSeparator;
import org.eclipse.ui.internal.CoolBarContributionItem;
import org.eclipse.ui.internal.CoolBarManager;
import org.eclipse.ui.internal.CoolItemToolBarManager;
import org.eclipse.ui.internal.IActionSetContributionItem;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class PluginActionSetBuilder
extends PluginActionBuilder {
    public static final String TAG_ACTION_SET = "actionSet";
    public static final String ATT_PULLDOWN = "pulldown";
    private PluginActionSet actionSet;
    private IWorkbenchWindow window;

    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        String pulldown;
        boolean pullDownStyle = false;
        String style = element.getAttribute("style");
        pullDownStyle = style != null ? style.equals(ATT_PULLDOWN) : (pulldown = element.getAttribute(ATT_PULLDOWN)) != null && pulldown.equals("true");
        ActionDescriptor desc = null;
        desc = pullDownStyle ? new ActionDescriptor(element, 5, this.window) : new ActionDescriptor(element, 3, this.window);
        WWinPluginAction action = (WWinPluginAction)desc.getAction();
        action.setActionSetId(this.actionSet.getDesc().getId());
        this.actionSet.addPluginAction(action);
        return desc;
    }

    protected PluginActionBuilder.BasicContribution createContribution() {
        return new ActionSetContribution(this.actionSet.getDesc().getId());
    }

    public static IContributionItem findInsertionPoint(String startId, String sortId, IContributionManager mgr, boolean startVsEnd) {
        IContributionItem[] items = mgr.getItems();
        int insertIndex = 0;
        while (insertIndex < items.length) {
            if (startId.equals(items[insertIndex].getId())) break;
            ++insertIndex;
        }
        if (insertIndex >= items.length) {
            return null;
        }
        int compareMetric = 0;
        if (startVsEnd) {
            compareMetric = 1;
        }
        int nX = insertIndex + 1;
        while (nX < items.length) {
            String testId;
            IContributionItem item = items[nX];
            if (item.isSeparator() || item.isGroupMarker() || !(item instanceof IActionSetContributionItem) || sortId != null && sortId.compareTo(testId = ((IActionSetContributionItem)item).getActionSetId()) < compareMetric) break;
            insertIndex = nX++;
        }
        return items[insertIndex];
    }

    public static IContributionItem findSubInsertionPoint(String startId, String sortId, CoolBarManager mgr, boolean startVsEnd) {
        IContributionItem[] items = mgr.getItems();
        int insertIndex = 0;
        while (insertIndex < items.length) {
            if (startId.equals(items[insertIndex].getId())) break;
            ++insertIndex;
        }
        if (insertIndex >= items.length) {
            insertIndex = 0;
            while (insertIndex < items.length) {
                CoolBarContributionItem item = (CoolBarContributionItem)items[insertIndex];
                IContributionItem foundItem = item.getToolBarManager().find(startId);
                if (foundItem != null) break;
                ++insertIndex;
            }
        }
        if (insertIndex >= items.length) {
            return null;
        }
        int compareMetric = 0;
        if (startVsEnd) {
            compareMetric = 1;
        }
        int nX = insertIndex + 1;
        while (nX < items.length) {
            String testId;
            IContributionItem subItem;
            CoolBarContributionItem item = (CoolBarContributionItem)items[nX];
            if (item.getItems().length == 0 || !((subItem = item.getItems()[0]) instanceof IActionSetContributionItem) || sortId != null && sortId.compareTo(testId = ((IActionSetContributionItem)subItem).getActionSetId()) < compareMetric) break;
            insertIndex = nX++;
        }
        return items[insertIndex];
    }

    public void readActionExtensions(PluginActionSet set, IWorkbenchWindow window, IActionBars bars) {
        this.actionSet = set;
        this.window = window;
        this.cache = null;
        this.currentContribution = null;
        this.targetID = null;
        this.targetContributionTag = TAG_ACTION_SET;
        this.readElements(new IConfigurationElement[]{set.getConfigElement()});
        if (this.cache != null) {
            this.contribute(bars.getMenuManager(), bars.getToolBarManager(), true);
        } else {
            WorkbenchPlugin.log("Action Set is empty: " + set.getDesc().getId());
        }
    }

    private static class ActionSetContribution
    extends PluginActionBuilder.BasicContribution {
        private String actionSetId;

        public ActionSetContribution(String id) {
            this.actionSetId = id;
        }

        protected void addGroup(IContributionManager mgr, String name) {
            if (mgr instanceof CoolItemToolBarManager) {
                CoolItemToolBarManager tBarMgr = (CoolItemToolBarManager)mgr;
                CoolBarManager cBarMgr = tBarMgr.getParentManager();
                IContributionItem cbItem = cBarMgr.find(this.actionSetId);
                if (cbItem == null) {
                    IContributionItem refItem = PluginActionSetBuilder.findSubInsertionPoint("additions", this.actionSetId, cBarMgr, true);
                    if (refItem == null) {
                        cBarMgr.add((IContributionItem)tBarMgr.getCoolBarItem());
                    } else {
                        cBarMgr.insertAfter(refItem.getId(), (IContributionItem)tBarMgr.getCoolBarItem());
                    }
                }
                ActionSetSeparator group = new ActionSetSeparator(name, this.actionSetId);
                tBarMgr.add((IContributionItem)group);
            } else {
                IContributionItem refItem = PluginActionSetBuilder.findInsertionPoint("additions", this.actionSetId, mgr, true);
                ActionSetSeparator group = new ActionSetSeparator(name, this.actionSetId);
                if (refItem == null) {
                    mgr.add((IContributionItem)group);
                } else {
                    mgr.insertAfter(refItem.getId(), (IContributionItem)group);
                }
            }
        }

        protected void insertMenuGroup(IMenuManager menu, AbstractGroupMarker marker) {
            if (this.actionSetId != null) {
                IContributionItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    String testId;
                    IContributionItem item = items[i];
                    if ((item.isSeparator() || item.isGroupMarker()) && item instanceof IActionSetContributionItem && this.actionSetId.compareTo(testId = ((IActionSetContributionItem)item).getActionSetId()) < 0) {
                        menu.insertBefore(items[i].getId(), (IContributionItem)marker);
                        return;
                    }
                    ++i;
                }
            }
            menu.add((IContributionItem)marker);
        }

        protected void insertAfter(IContributionManager mgr, String refId, IContributionItem item) {
            IContributionItem refItem = PluginActionSetBuilder.findInsertionPoint(refId, this.actionSetId, mgr, true);
            if (refItem != null) {
                mgr.insertAfter(refItem.getId(), item);
            } else {
                WorkbenchPlugin.log("Reference item " + refId + " not found for action " + item.getId());
            }
        }
    }
}

