/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.ShowFastViewContribution;
import org.eclipse.ui.internal.WorkbenchPage;

public class ShortcutBarPart
extends LayoutPart {
    private ToolBarManager tbm;
    private ToolBar toolbar;

    public ShortcutBarPart(ToolBarManager tbm) {
        super("ShortcutBarPart");
        this.tbm = tbm;
        this.toolbar = tbm.getControl();
        this.toolbar.setData((Object)this);
        this.initDragAndDrop();
    }

    public final void createControl(Composite parent) {
    }

    public final Control getControl() {
        return this.toolbar;
    }

    private void initDragAndDrop() {
        DropTarget dropTarget = new DropTarget((Control)this.toolbar, 3);
        dropTarget.addDropListener((DropTargetListener)new ShortcutBarDropAdapter(this.toolbar));
    }

    public LayoutPart targetPartFor(LayoutPart dragSource) {
        return this;
    }

    class ShortcutBarDropAdapter
    extends DropTargetAdapter {
        private static final long hoverThreshold = 250L;
        private ToolBar toolBar;
        private ToolItem currentDropTarget;
        private int lastValidOperation;
        private IViewPart lastFastView = null;
        private IWorkbenchPart deactivatedPart = null;
        private long hoverStart;

        public ShortcutBarDropAdapter(ToolBar dropTarget) {
            this.toolBar = dropTarget;
        }

        private ToolItem getDropTarget(Point position) {
            return this.toolBar.getItem(this.toolBar.toControl(position));
        }

        private void doDropValidation(DropTargetEvent event) {
            if (event.detail != 0) {
                this.lastValidOperation = event.detail;
            }
            event.detail = this.validateTarget() ? this.lastValidOperation : 0;
        }

        public void dragEnter(DropTargetEvent event) {
            this.currentDropTarget = this.getDropTarget(new Point(event.x, event.y));
            this.doDropValidation(event);
        }

        public void dragOver(DropTargetEvent event) {
            ToolItem oldTarget = this.currentDropTarget;
            this.currentDropTarget = this.getDropTarget(new Point(event.x, event.y));
            if (this.currentDropTarget == null) {
                event.detail = 0;
                if (oldTarget != null) {
                    this.hoverStart = System.currentTimeMillis();
                } else if (this.lastFastView != null && System.currentTimeMillis() - this.hoverStart > 250L) {
                    this.hideView();
                }
            } else {
                long currentTime = System.currentTimeMillis();
                this.doDropValidation(event);
                if (oldTarget != this.currentDropTarget) {
                    this.hoverStart = currentTime;
                } else if (this.validateTarget() && currentTime - this.hoverStart > 250L) {
                    this.showView();
                }
            }
        }

        private void showView() {
            Object itemData = this.currentDropTarget.getData("FastView");
            if (itemData != null) {
                IViewReference ref = (IViewReference)itemData;
                WorkbenchPage page = (WorkbenchPage)ShortcutBarPart.this.getWorkbenchWindow().getActivePage();
                if (this.deactivatedPart == null) {
                    this.deactivatedPart = page.getActivePart();
                }
                this.lastFastView = (IViewPart)ref.getPart(true);
                page.activate(this.lastFastView);
            }
        }

        private void hideView() {
            if (this.deactivatedPart != null) {
                WorkbenchPage partPage;
                WorkbenchPage activePage = (WorkbenchPage)ShortcutBarPart.this.getWorkbenchWindow().getActivePage();
                if (activePage == (partPage = (WorkbenchPage)this.deactivatedPart.getSite().getPage())) {
                    partPage.activate(this.deactivatedPart);
                }
                this.deactivatedPart = null;
            }
            this.lastFastView = null;
        }

        private boolean validateTarget() {
            return this.currentDropTarget != null && this.currentDropTarget.getData() instanceof ShowFastViewContribution;
        }
    }
}

