/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPage;

public class ShowFastViewContribution
extends ContributionItem {
    public static final String FAST_VIEW = "FastView";
    private IWorkbenchWindow window;

    public ShowFastViewContribution(IWorkbenchWindow window) {
        super("showFastViewContr");
        this.window = window;
    }

    public void fill(ToolBar parent, int index) {
        WorkbenchPage page = (WorkbenchPage)this.window.getActivePage();
        if (page == null) {
            return;
        }
        IViewReference[] refs = page.getFastViews();
        int size = refs.length;
        int nX = 0;
        while (nX < size) {
            final IViewReference ref = refs[nX];
            ToolItem item = new ToolItem(parent, 32, index);
            item.setImage(ref.getTitleImage());
            item.setToolTipText(ref.getTitle());
            item.setData(FAST_VIEW, (Object)ref);
            if (ref == ((WorkbenchPage)this.window.getActivePage()).getActiveFastView()) {
                item.setSelection(true);
            } else {
                item.setSelection(false);
            }
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShowFastViewContribution.this.showView(ref);
                }
            });
            ++index;
            ++nX;
        }
    }

    public boolean isDynamic() {
        return true;
    }

    private void showView(IViewReference ref) {
        WorkbenchPage page = (WorkbenchPage)ref.getPage();
        page.toggleFastView(ref);
    }
}

