/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.ui.internal.Semaphore;
import org.eclipse.ui.internal.UIWorkspaceLock;

public class UISynchronizer
extends Synchronizer {
    protected UIWorkspaceLock uiLock;

    public UISynchronizer(Display display, UIWorkspaceLock lock) {
        super(display);
        this.uiLock = lock;
    }

    public void syncExec(Runnable runnable) {
        if (runnable == null || this.uiLock.isUI() || !this.uiLock.isCurrentOperation()) {
            super.syncExec(runnable);
            return;
        }
        Runnable runOnce = new Runnable(){

            public void run() {
                UISynchronizer.this.uiLock.doPendingWork();
            }
        };
        Semaphore work = new Semaphore(runnable);
        work.setOperationThread(Thread.currentThread());
        this.uiLock.addPendingWork(work);
        if (!this.uiLock.isUIWaiting()) {
            this.asyncExec(runOnce);
        } else {
            this.uiLock.interruptUI();
        }
        try {
            work.acquire();
        }
        catch (InterruptedException interruptedException) {}
    }
}

