/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.AboutInfo;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.SimpleListContentProvider;
import org.eclipse.ui.internal.misc.Assert;

public class WelcomePageSelectionDialog
extends SelectionDialog {
    private static final int LIST_WIDTH = 60;
    private static final int LIST_HEIGHT = 10;
    private AboutInfo[] features;
    private ListViewer listViewer;

    public WelcomePageSelectionDialog(Shell shell, AboutInfo[] features, int initialSelection) {
        super(shell);
        Assert.isTrue(features != null && features.length > 0);
        this.features = features;
        this.setTitle(WorkbenchMessages.getString("WelcomePageSelectionDialog.title"));
        this.setMessage(WorkbenchMessages.getString("WelcomePageSelectionDialog.message"));
        if (initialSelection >= 0 && initialSelection < features.length) {
            this.setInitialSelections(new Object[]{features[initialSelection]});
        } else {
            this.setInitialSelections(new Object[0]);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, "org.eclipse.ui.welcome_page_selection_dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.listViewer = new ListViewer(composite, 2820);
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        this.listViewer.getList().setLayoutData((Object)data);
        this.listViewer.getList().setFont(parent.getFont());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == null ? "" : ((AboutInfo)element).getFeatureLabel();
            }
        });
        SimpleListContentProvider cp = new SimpleListContentProvider();
        cp.setElements(this.features);
        this.listViewer.setContentProvider((IContentProvider)cp);
        this.listViewer.setInput(new Object());
        this.listViewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WelcomePageSelectionDialog.this.getOkButton().setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WelcomePageSelectionDialog.this.okPressed();
            }
        });
        return composite;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }
}

