/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.WorkbenchImages;

public abstract class WorkbenchPartReference
implements IWorkbenchPartReference {
    protected IWorkbenchPart part;
    private String id;
    protected PartPane pane;
    private String title;
    private String tooltip;
    private Image image;
    private ImageDescriptor imageDescritor;
    private ListenerList propChangeListeners = new ListenerList(2);

    public void init(String id, String title, String tooltip, ImageDescriptor desc) {
        this.id = id;
        this.title = title;
        this.tooltip = tooltip;
        this.imageDescritor = desc;
    }

    public void releaseReferences() {
        this.id = null;
        this.tooltip = null;
        this.title = null;
        if (this.image != null && this.imageDescritor != null) {
            if (this.part != null) {
                this.part.getTitleImage();
            }
            ReferenceCounter imageCache = WorkbenchImages.getImageCache();
            this.image = (Image)imageCache.get(this.imageDescritor);
            if (this.image != null) {
                imageCache.removeRef(this.imageDescritor);
            }
            this.image = null;
            this.imageDescritor = null;
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        IWorkbenchPart part = this.getPart(false);
        if (part != null) {
            part.addPropertyListener(listener);
        } else {
            this.propChangeListeners.add((Object)listener);
        }
    }

    public void removePropertyListener(IPropertyListener listener) {
        IWorkbenchPart part = this.getPart(false);
        if (part != null) {
            part.removePropertyListener(listener);
        } else {
            this.propChangeListeners.remove((Object)listener);
        }
    }

    public String getId() {
        if (this.part != null) {
            return this.part.getSite().getId();
        }
        return this.id;
    }

    public String getTitleToolTip() {
        if (this.part != null) {
            return this.part.getTitleToolTip();
        }
        return this.tooltip;
    }

    public String getTitle() {
        String result = this.title;
        if (this.part != null) {
            result = this.part.getTitle();
        }
        if (result == null) {
            result = new String();
        }
        return result;
    }

    public Image getTitleImage() {
        if (this.part != null) {
            return this.part.getTitleImage();
        }
        if (this.image != null) {
            return this.image;
        }
        if (this.imageDescritor == null) {
            return null;
        }
        ReferenceCounter imageCache = WorkbenchImages.getImageCache();
        this.image = (Image)imageCache.get(this.imageDescritor);
        if (this.image != null) {
            imageCache.addRef(this.imageDescritor);
            return this.image;
        }
        this.image = this.imageDescritor.createImage();
        imageCache.put(this.imageDescritor, this.image);
        return this.image;
    }

    public void setPart(IWorkbenchPart part) {
        this.part = part;
        if (part == null) {
            return;
        }
        Object[] listeners = this.propChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            part.addPropertyListener((IPropertyListener)listeners[i]);
            ++i;
        }
        PartSite site = (PartSite)part.getSite();
        if (site != null && this.pane != null) {
            site.setPane(this.pane);
            this.pane = null;
        }
    }

    public void setPane(PartPane pane) {
        if (pane == null) {
            return;
        }
        if (this.part != null) {
            PartSite site = (PartSite)this.part.getSite();
            site.setPane(pane);
        } else {
            this.pane = pane;
        }
    }

    public PartPane getPane() {
        PartPane result = null;
        if (this.part != null) {
            result = ((PartSite)this.part.getSite()).getPane();
        }
        if (result == null) {
            result = this.pane;
        }
        return result;
    }

    public void dispose() {
        if (this.image != null && this.imageDescritor != null) {
            int count;
            ReferenceCounter imageCache = WorkbenchImages.getImageCache();
            if (this.image != null && (count = imageCache.removeRef(this.imageDescritor)) <= 0) {
                this.image.dispose();
            }
            this.imageDescritor = null;
            this.image = null;
        }
        if (this.part != null) {
            this.part.dispose();
        }
        this.part = null;
    }

    public abstract String getRegisteredName();

    public abstract IWorkbenchPart getPart(boolean var1);

    public abstract IWorkbenchPage getPage();
}

