/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.PlatformUIPreferenceListener;
import org.eclipse.ui.internal.SharedImages;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.CapabilityRegistry;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.IViewRegistry;
import org.eclipse.ui.internal.registry.MarkerHelpRegistry;
import org.eclipse.ui.internal.registry.MarkerHelpRegistryReader;
import org.eclipse.ui.internal.registry.MarkerImageProviderRegistry;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;
import org.eclipse.ui.internal.registry.ProjectImageRegistry;
import org.eclipse.ui.internal.registry.ViewRegistry;
import org.eclipse.ui.internal.registry.ViewRegistryReader;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkbenchPlugin
extends AbstractUIPlugin {
    private static WorkbenchPlugin inst;
    private EditorRegistry editorRegistry;
    private ProjectImageRegistry projectImageRegistry;
    private DecoratorManager decoratorManager;
    private MarkerHelpRegistry markerHelpRegistry;
    private WorkingSetManager workingSetManager;
    private WorkingSetRegistry workingSetRegistry;
    public static boolean DEBUG;
    public static String PI_WORKBENCH;
    private static char PREFERENCE_PAGE_CATEGORY_SEPARATOR;
    private IWorkbench workbench;
    private PreferenceManager preferenceManager;
    private ViewRegistry viewRegistry;
    private PerspectiveRegistry perspRegistry;
    private CapabilityRegistry capabilityRegistry;
    private ActionSetRegistry actionSetRegistry;
    private SharedImages sharedImages;
    private MarkerImageProviderRegistry markerImageProviderRegistry;

    static {
        DEBUG = false;
        PI_WORKBENCH = "org.eclipse.ui";
        PREFERENCE_PAGE_CATEGORY_SEPARATOR = (char)47;
    }

    public WorkbenchPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        inst = this;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        IPluginDescriptor plugin = element.getDeclaringExtension().getDeclaringPluginDescriptor();
        if (plugin.isPluginActivated()) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    protected ImageRegistry createImageRegistry() {
        return WorkbenchImages.getImageRegistry();
    }

    public ActionSetRegistry getActionSetRegistry() {
        if (this.actionSetRegistry == null) {
            this.actionSetRegistry = new ActionSetRegistry();
        }
        return this.actionSetRegistry;
    }

    public CapabilityRegistry getCapabilityRegistry() {
        if (this.capabilityRegistry == null) {
            this.capabilityRegistry = new CapabilityRegistry();
            this.capabilityRegistry.load();
        }
        return this.capabilityRegistry;
    }

    public MarkerHelpRegistry getMarkerHelpRegistry() {
        if (this.markerHelpRegistry == null) {
            this.markerHelpRegistry = new MarkerHelpRegistry();
            new MarkerHelpRegistryReader().addHelp(this.markerHelpRegistry);
        }
        return this.markerHelpRegistry;
    }

    public static WorkbenchPlugin getDefault() {
        return inst;
    }

    public IEditorRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = new EditorRegistry();
        }
        return this.editorRegistry;
    }

    public IElementFactory getElementFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint(PI_WORKBENCH, "elementFactories");
        if (extensionPoint == null) {
            WorkbenchPlugin.log("Unable to find element factory. Extension point: elementFactories not found");
            return null;
        }
        IConfigurationElement targetElement = null;
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (strID.equals(targetID)) {
                targetElement = configElements[j];
                break;
            }
            ++j;
        }
        if (targetElement == null) {
            WorkbenchPlugin.log("Unable to find element factory: " + targetID);
            return null;
        }
        IElementFactory factory = null;
        try {
            factory = (IElementFactory)WorkbenchPlugin.createExtension(targetElement, "class");
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create element factory.", e.getStatus());
            factory = null;
        }
        return factory;
    }

    public MarkerImageProviderRegistry getMarkerImageProviderRegistry() {
        if (this.markerImageProviderRegistry == null) {
            this.markerImageProviderRegistry = new MarkerImageProviderRegistry();
        }
        return this.markerImageProviderRegistry;
    }

    public IPerspectiveRegistry getPerspectiveRegistry() {
        if (this.perspRegistry == null) {
            this.perspRegistry = new PerspectiveRegistry();
            this.perspRegistry.load();
        }
        return this.perspRegistry;
    }

    public static IWorkspace getPluginWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IWorkingSetManager getWorkingSetManager() {
        if (this.workingSetManager == null) {
            this.workingSetManager = new WorkingSetManager();
            this.workingSetManager.restoreState();
        }
        return this.workingSetManager;
    }

    public WorkingSetRegistry getWorkingSetRegistry() {
        if (this.workingSetRegistry == null) {
            this.workingSetRegistry = new WorkingSetRegistry();
            this.workingSetRegistry.load();
        }
        return this.workingSetRegistry;
    }

    public PreferenceManager getPreferenceManager() {
        if (this.preferenceManager == null) {
            this.preferenceManager = new PreferenceManager(PREFERENCE_PAGE_CATEGORY_SEPARATOR);
            PreferencePageRegistryReader registryReader = new PreferencePageRegistryReader(this.getWorkbench());
            List pageContributions = registryReader.getPreferenceContributions(Platform.getPluginRegistry());
            Iterator iterator = pageContributions.iterator();
            while (iterator.hasNext()) {
                this.preferenceManager.addToRoot((IPreferenceNode)iterator.next());
            }
        }
        return this.preferenceManager;
    }

    public ProjectImageRegistry getProjectImageRegistry() {
        if (this.projectImageRegistry == null) {
            this.projectImageRegistry = new ProjectImageRegistry();
            this.projectImageRegistry.load();
        }
        return this.projectImageRegistry;
    }

    public ISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = new SharedImages();
        }
        return this.sharedImages;
    }

    public IViewRegistry getViewRegistry() {
        if (this.viewRegistry == null) {
            this.viewRegistry = new ViewRegistry();
            try {
                ViewRegistryReader reader = new ViewRegistryReader();
                reader.readViews(Platform.getPluginRegistry(), this.viewRegistry);
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Unable to read view registry.", e.getStatus());
            }
        }
        return this.viewRegistry;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        JFacePreferences.setPreferenceStore((IPreferenceStore)store);
        store.setDefault("AUTO_BUILD", true);
        store.setDefault("SAVE_ALL_BEFORE_BUILD", false);
        store.setDefault("saveInterval", 5);
        store.setDefault("WELCOME_DIALOG", true);
        store.setDefault("REFRESH_WORKSPACE_ON_STARTUP", false);
        store.setDefault("EDITOR_LIST_PULLDOWN_ACTIVE", false);
        store.setDefault("EDITOR_LIST_DISPLAY_FULL_NAME", false);
        store.setDefault("CLOSE_EDITORS_ON_EXIT", false);
        store.setDefault("REUSE_OPEN_EDITORS_BOOLEAN", false);
        store.setDefault("REUSE_DIRTY_EDITORS", true);
        store.setDefault("REUSE_OPEN_EDITORS", 8);
        store.setDefault("OPEN_ON_SINGLE_CLICK", false);
        store.setDefault("SELECT_ON_HOVER", false);
        store.setDefault("OPEN_AFTER_DELAY", false);
        store.setDefault("RECENT_FILES", 4);
        store.setDefault("VIEW_TAB_POSITION", 1024);
        store.setDefault("EDITOR_TAB_POSITION", 128);
        store.setDefault("EDITOR_TABS_SPAN_MULTIPLE_LINES", false);
        store.setDefault("EDITOR_TAB_WIDTH_SCALAR", 3);
        store.setDefault("NUMBER_EDITOR_TABS", 999);
        store.setDefault("OPEN_VIEW_MODE", 0);
        store.setDefault("OPEN_PERSPECTIVE_MODE", 0);
        store.setDefault("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION", "prompt");
        store.setDefault("ENABLED_DECORATORS", "");
        store.setDefault("EDITOR_LIST_SELECTION_SCOPE", 1);
        store.setDefault("EDITOR_LIST_SORT_CRITERIA", 0);
        store.setDefault("COLOR_ICONS", false);
        store.setDefault("SHOW_SHORTCUT_BAR", true);
        store.setDefault("SHOW_STATUS_LINE", true);
        store.setDefault("SHOW_TOOL_BAR", true);
        store.setDefault("SHOW_TASKS_ON_BUILD", true);
        store.setDefault("acceleratorConfigurationId", "org.eclipse.ui.defaultAcceleratorConfiguration");
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"ERROR_COLOR", (RGB)new RGB(255, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"HYPERLINK_COLOR", (RGB)new RGB(0, 0, 153));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"ACTIVE_HYPERLINK_COLOR", (RGB)new RGB(0, 0, 255));
        store.setDefault("ENABLE_CONFIGURABLE_PROJECT_WIZARD", false);
        store.setDefault("SINGLE_CLICK_METHOD", 0);
        store.setDefault("ENABLE_COOL_BARS", true);
        store.setDefault("ENABLE_NEW_MENUS", true);
        FontRegistry registry = JFaceResources.getFontRegistry();
        this.initializeFont("org.eclipse.jface.dialogfont", registry, store);
        this.initializeFont("org.eclipse.jface.bannerfont", registry, store);
        this.initializeFont("org.eclipse.jface.headerfont", registry, store);
        this.initializeFont("org.eclipse.jface.textfont", registry, store);
        store.addPropertyChangeListener((IPropertyChangeListener)new PlatformUIPreferenceListener());
    }

    private void initializeFont(String fontKey, FontRegistry registry, IPreferenceStore store) {
        FontData[] fontData = registry.getFontData(fontKey);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)fontKey, (FontData[])fontData);
    }

    public static void log(String message) {
        WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        System.err.println(message);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            WorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
            System.err.println(String.valueOf(message) + "\nReason:");
        }
        WorkbenchPlugin.getDefault().getLog().log(status);
        System.err.println(status.getMessage());
    }

    public void setWorkbench(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
    }

    public DecoratorManager getDecoratorManager() {
        if (this.decoratorManager == null) {
            this.decoratorManager = new DecoratorManager();
            this.decoratorManager.restoreListeners();
        }
        return this.decoratorManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startup() throws CoreException {
        File markerFile;
        block20: {
            block18: {
                block17: {
                    IPath locationPath = this.getStateLocation();
                    File newLocation = locationPath.toFile();
                    File oldLocation = new File(newLocation, "..//org.eclipse.ui");
                    try {
                        oldLocation = oldLocation.getCanonicalFile();
                    }
                    catch (IOException iOException) {}
                    String markerFileName = ".copiedStateFiles_Marker";
                    markerFile = new File(oldLocation, markerFileName);
                    if (markerFile.exists()) {
                        return;
                    }
                    try {
                        String[] list = newLocation.list();
                        if (list != null && list.length != 0) {
                            Object var15_7 = null;
                            break block17;
                        }
                        String[] oldList = oldLocation.list();
                        if (oldList == null) break block18;
                        if (oldList.length == 0) {
                            break block18;
                        }
                        byte[] b = new byte[1024];
                        int i = 0;
                        while (i < oldList.length) {
                            String string = oldList[i];
                            try {
                                File oldFile = new File(oldLocation, string);
                                FileInputStream in = new FileInputStream(oldFile);
                                FileOutputStream out = new FileOutputStream(new File(newLocation, string));
                                int read = in.read(b);
                                while (true) {
                                    if (read < 0) {
                                        in.close();
                                        out.close();
                                        oldFile.delete();
                                        break;
                                    }
                                    out.write(b, 0, read);
                                    read = in.read(b);
                                }
                            }
                            catch (IOException iOException) {
                                new File(newLocation, string).delete();
                            }
                            ++i;
                        }
                        break block20;
                    }
                    catch (Throwable throwable) {
                        Object var15_9 = null;
                        try {
                            new FileOutputStream(markerFile).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                new FileOutputStream(markerFile).close();
                return;
            }
            Object var15_8 = null;
            try {}
            catch (IOException iOException) {}
            new FileOutputStream(markerFile).close();
            return;
        }
        Object var15_10 = null;
        try {}
        catch (IOException iOException) {
            return;
        }
        new FileOutputStream(markerFile).close();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        if (this.decoratorManager != null) {
            this.decoratorManager.shutdown();
        }
    }
}

