/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.Arrays;
import org.eclipse.ui.internal.commands.Point;
import org.eclipse.ui.internal.commands.Util;

public final class CaptureEvent
implements Comparable {
    private static final int HASH_INITIAL = 27;
    private static final int HASH_FACTOR = 37;
    private int data;
    private int pen;
    private Point[] points;

    public static CaptureEvent create(int data, int pen, Point[] points) throws IllegalArgumentException {
        return new CaptureEvent(data, pen, points);
    }

    private CaptureEvent(int data, int pen, Point[] points) throws IllegalArgumentException {
        this.data = data;
        this.pen = pen;
        if (points == null) {
            throw new IllegalArgumentException();
        }
        points = (Point[])points.clone();
        int i = 0;
        while (i < points.length) {
            if (points[i] == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        this.points = points;
    }

    public int compareTo(Object object) {
        CaptureEvent captureEvent = (CaptureEvent)object;
        int compareTo = this.data - captureEvent.data;
        if (compareTo == 0 && (compareTo = this.pen - captureEvent.pen) == 0) {
            compareTo = Util.compare(this.points, captureEvent.points);
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CaptureEvent)) {
            return false;
        }
        CaptureEvent captureEvent = (CaptureEvent)object;
        return this.data == captureEvent.data && this.pen == captureEvent.pen && Arrays.equals(this.points, captureEvent.points);
    }

    public int getData() {
        return this.data;
    }

    public int getPen() {
        return this.pen;
    }

    public Point[] getPoints() {
        return (Point[])this.points.clone();
    }

    public int hashCode() {
        int result = 27;
        result = result * 37 + this.data;
        result = result * 37 + this.pen;
        int i = 0;
        while (i < this.points.length) {
            result = result * 37 + this.points[i].hashCode();
            ++i;
        }
        return result;
    }
}

