/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.internal.commands.GestureStroke;
import org.eclipse.ui.internal.commands.Point;
import org.eclipse.ui.internal.commands.Util;

public final class GestureSequence
implements Comparable {
    private static final int HASH_INITIAL = 47;
    private static final int HASH_FACTOR = 57;
    private List gestureStrokes;

    public static GestureSequence create() {
        return new GestureSequence(Collections.EMPTY_LIST);
    }

    public static GestureSequence create(GestureStroke gestureStroke) throws IllegalArgumentException {
        return new GestureSequence(Collections.singletonList(gestureStroke));
    }

    public static GestureSequence create(GestureStroke[] gestureStrokes) throws IllegalArgumentException {
        return new GestureSequence(Arrays.asList(gestureStrokes));
    }

    public static GestureSequence create(List gestureStrokes) throws IllegalArgumentException {
        return new GestureSequence(gestureStrokes);
    }

    public static GestureSequence parse(String gestureString) throws IllegalArgumentException {
        return GestureSequence.create();
    }

    public static GestureSequence recognize(Point[] points, int sensitivity) {
        GestureStroke gestureStroke = null;
        ArrayList<GestureStroke> gestureStrokes = new ArrayList<GestureStroke>();
        int x0 = 0;
        int y0 = 0;
        int i = 0;
        while (i < points.length) {
            Point point = points[i];
            if (i == 0) {
                x0 = point.getX();
                y0 = point.getY();
            } else {
                int x1 = point.getX();
                int y1 = point.getY();
                int dx = (x1 - x0) / sensitivity;
                int dy = (y1 - y0) / sensitivity;
                if (dx != 0 || dy != 0) {
                    if (dx > 0 && !GestureStroke.EAST.equals(gestureStroke)) {
                        gestureStroke = GestureStroke.EAST;
                        gestureStrokes.add(gestureStroke);
                    } else if (dx < 0 && !GestureStroke.WEST.equals(gestureStroke)) {
                        gestureStroke = GestureStroke.WEST;
                        gestureStrokes.add(gestureStroke);
                    } else if (dy > 0 && !GestureStroke.SOUTH.equals(gestureStroke)) {
                        gestureStroke = GestureStroke.SOUTH;
                        gestureStrokes.add(gestureStroke);
                    } else if (dy < 0 && !GestureStroke.NORTH.equals(gestureStroke)) {
                        gestureStroke = GestureStroke.NORTH;
                        gestureStrokes.add(gestureStroke);
                    }
                    x0 = x1;
                    y0 = y1;
                }
            }
            ++i;
        }
        return GestureSequence.create(gestureStrokes);
    }

    private GestureSequence(List gestureStrokes) throws IllegalArgumentException {
        if (gestureStrokes == null) {
            throw new IllegalArgumentException();
        }
        this.gestureStrokes = Collections.unmodifiableList(new ArrayList(gestureStrokes));
        Iterator iterator = this.gestureStrokes.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof GestureStroke) continue;
            throw new IllegalArgumentException();
        }
    }

    public int compareTo(Object object) {
        return Util.compare(this.gestureStrokes, ((GestureSequence)object).gestureStrokes);
    }

    public boolean equals(Object object) {
        return object instanceof GestureSequence && this.gestureStrokes.equals(((GestureSequence)object).gestureStrokes);
    }

    public List getGestureStrokes() {
        return this.gestureStrokes;
    }

    public int hashCode() {
        int result = 47;
        Iterator iterator = this.gestureStrokes.iterator();
        while (iterator.hasNext()) {
            result = result * 57 + ((GestureStroke)iterator.next()).hashCode();
        }
        return result;
    }

    public boolean isChildOf(GestureSequence gestureSequence, boolean equals) {
        if (gestureSequence == null) {
            return false;
        }
        return Util.isChildOf(this.gestureStrokes, gestureSequence.gestureStrokes, equals);
    }
}

