/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import org.eclipse.ui.internal.commands.KeyBinding;

public final class KeyBindingMatch
implements Comparable {
    private static final int HASH_INITIAL = 57;
    private static final int HASH_FACTOR = 67;
    private KeyBinding keyBinding;
    private int value;

    static KeyBindingMatch create(KeyBinding keyBinding, int value) throws IllegalArgumentException {
        return new KeyBindingMatch(keyBinding, value);
    }

    private KeyBindingMatch(KeyBinding keyBinding, int value) throws IllegalArgumentException {
        if (keyBinding == null || value < 0) {
            throw new IllegalArgumentException();
        }
        this.keyBinding = keyBinding;
        this.value = value;
    }

    public int compareTo(Object object) {
        KeyBindingMatch keyBindingMatch = (KeyBindingMatch)object;
        int compareTo = this.keyBinding.compareTo(keyBindingMatch.keyBinding);
        if (compareTo == 0) {
            compareTo = this.value - keyBindingMatch.value;
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyBindingMatch)) {
            return false;
        }
        KeyBindingMatch keyBindingMatch = (KeyBindingMatch)object;
        return this.keyBinding.equals(keyBindingMatch.keyBinding) && this.value == keyBindingMatch.value;
    }

    public KeyBinding getKeyBinding() {
        return this.keyBinding;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 57;
        result = result * 67 + this.keyBinding.hashCode();
        result = result * 67 + this.value;
        return result;
    }
}

