/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.ui.internal.commands.Util;

public final class KeyConfiguration
implements Comparable {
    private static final int HASH_INITIAL = 11;
    private static final int HASH_FACTOR = 21;
    private static Comparator nameComparator;
    private String description;
    private String id;
    private String name;
    private String parent;
    private String plugin;

    public static KeyConfiguration create(String description, String id, String name, String parent, String plugin) throws IllegalArgumentException {
        return new KeyConfiguration(description, id, name, parent, plugin);
    }

    public static Comparator nameComparator() {
        if (nameComparator == null) {
            nameComparator = new Comparator(){

                public int compare(Object left, Object right) {
                    return Collator.getInstance().compare(((KeyConfiguration)left).name, ((KeyConfiguration)right).name);
                }
            };
        }
        return nameComparator;
    }

    public static SortedMap sortedMapById(List keyConfigurations) throws IllegalArgumentException {
        if (keyConfigurations == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, KeyConfiguration> sortedMap = new TreeMap<String, KeyConfiguration>();
        Iterator iterator = keyConfigurations.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof KeyConfiguration)) {
                throw new IllegalArgumentException();
            }
            KeyConfiguration keyConfiguration = (KeyConfiguration)object;
            sortedMap.put(keyConfiguration.id, keyConfiguration);
        }
        return sortedMap;
    }

    public static SortedMap sortedMapByName(List keyConfigurations) throws IllegalArgumentException {
        if (keyConfigurations == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, KeyConfiguration> sortedMap = new TreeMap<String, KeyConfiguration>();
        Iterator iterator = keyConfigurations.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof KeyConfiguration)) {
                throw new IllegalArgumentException();
            }
            KeyConfiguration keyConfiguration = (KeyConfiguration)object;
            sortedMap.put(keyConfiguration.name, keyConfiguration);
        }
        return sortedMap;
    }

    private KeyConfiguration(String description, String id, String name, String parent, String plugin) throws IllegalArgumentException {
        if (id == null || name == null) {
            throw new IllegalArgumentException();
        }
        this.description = description;
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.plugin = plugin;
    }

    public int compareTo(Object object) {
        KeyConfiguration item = (KeyConfiguration)object;
        int compareTo = this.id.compareTo(item.id);
        if (compareTo == 0 && (compareTo = this.name.compareTo(item.name)) == 0) {
            Util.compare((Comparable)((Object)this.description), (Comparable)((Object)item.description));
            if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.parent), (Comparable)((Object)item.parent))) == 0) {
                compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)item.plugin));
            }
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyConfiguration)) {
            return false;
        }
        KeyConfiguration keyConfiguration = (KeyConfiguration)object;
        return Util.equals(this.description, keyConfiguration.description) && this.id.equals(keyConfiguration.id) && this.name.equals(keyConfiguration.name) && Util.equals(this.parent, keyConfiguration.parent) && Util.equals(this.plugin, keyConfiguration.plugin);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public int hashCode() {
        int result = 11;
        result = result * 21 + Util.hashCode(this.description);
        result = result * 21 + this.id.hashCode();
        result = result * 21 + this.name.hashCode();
        result = result * 21 + Util.hashCode(this.parent);
        result = result * 21 + Util.hashCode(this.plugin);
        return result;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.id + ')';
    }
}

