/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WWinKeyBindingService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.commands.ActiveKeyConfiguration;
import org.eclipse.ui.internal.commands.Category;
import org.eclipse.ui.internal.commands.Command;
import org.eclipse.ui.internal.commands.CoreRegistry;
import org.eclipse.ui.internal.commands.ImageFactory;
import org.eclipse.ui.internal.commands.KeyBinding;
import org.eclipse.ui.internal.commands.KeyConfiguration;
import org.eclipse.ui.internal.commands.KeyManager;
import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.LocalRegistry;
import org.eclipse.ui.internal.commands.Path;
import org.eclipse.ui.internal.commands.PreferenceRegistry;
import org.eclipse.ui.internal.commands.Scope;
import org.eclipse.ui.internal.commands.State;
import org.eclipse.ui.internal.commands.Util;

public class KeyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final ResourceBundle resourceBundle;
    private static final String COMMAND_CONFLICT;
    private static final String COMMAND_UNDEFINED;
    private static final int DIFFERENCE_ADD = 0;
    private static final int DIFFERENCE_CHANGE = 1;
    private static final int DIFFERENCE_MINUS = 2;
    private static final int DIFFERENCE_NONE = 3;
    private static final Image IMAGE_CHANGE;
    private static final Image IMAGE_MINUS;
    private static final Image IMAGE_PLUS;
    private static final RGB RGB_CONFLICT;
    private static final RGB RGB_CONFLICT_MINUS;
    private static final RGB RGB_MINUS;
    private static final char SPACE = ' ';
    private static final String ZERO_LENGTH_STRING = "";
    private Label labelActiveKeyConfiguration;
    private Combo comboActiveKeyConfiguration;
    private Label labelCommands;
    private TreeViewer treeViewerCommands;
    private Label labelKeySequencesForCommand;
    private Table tableKeySequencesForCommand;
    private Label labelKeySequence;
    private Combo comboKeySequence;
    private Label labelScope;
    private Combo comboScope;
    private Label labelKeyConfiguration;
    private Combo comboKeyConfiguration;
    private Button buttonChange;
    private Label labelCommandsForKeySequence;
    private Table tableCommandsForKeySequence;
    private IWorkbench workbench;
    private State[] states;
    private List categories;
    private SortedMap categoriesById;
    private SortedMap categoriesByName;
    private List commands;
    private SortedMap commandsById;
    private SortedMap commandsByName;
    private List scopes;
    private SortedMap scopesById;
    private SortedMap scopesByName;
    private List coreActiveKeyConfigurations;
    private List coreKeyBindings;
    private List coreKeyConfigurations;
    private List coreRegionalKeyBindings;
    private List localActiveKeyConfigurations;
    private List localKeyBindings;
    private List localKeyConfigurations;
    private List localRegionalKeyBindings;
    private List preferenceActiveKeyConfigurations;
    private List preferenceKeyBindings;
    private List preferenceKeyConfigurations;
    private List preferenceRegionalKeyBindings;
    private ActiveKeyConfiguration activeKeyConfiguration;
    private List activeKeyConfigurations;
    private List keyBindings;
    private List keyConfigurations;
    private SortedMap keyConfigurationsById;
    private SortedMap keyConfigurationsByName;
    private List regionalKeyBindings;
    private SortedMap tree;
    private List commandRecords = new ArrayList();
    private List keySequenceRecords = new ArrayList();
    private SortedMap keySequencesByName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.KeyPreferencePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        resourceBundle = ResourceBundle.getBundle(clazz.getName());
        COMMAND_CONFLICT = Util.getString(resourceBundle, "commandConflict");
        COMMAND_UNDEFINED = Util.getString(resourceBundle, "commandUndefined");
        IMAGE_CHANGE = ImageFactory.getImage("change");
        IMAGE_MINUS = ImageFactory.getImage("minus");
        IMAGE_PLUS = ImageFactory.getImage("plus");
        RGB_CONFLICT = new RGB(255, 0, 0);
        RGB_CONFLICT_MINUS = new RGB(255, 192, 192);
        RGB_MINUS = new RGB(192, 192, 192);
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
        ArrayList<Path> pathItems = new ArrayList<Path>();
        pathItems.add(KeyManager.systemPlatform());
        pathItems.add(KeyManager.systemLocale());
        this.states = new State[]{State.create(pathItems)};
        PreferenceRegistry preferenceRegistry = PreferenceRegistry.getInstance();
        try {
            preferenceRegistry.load();
        }
        catch (IOException iOException) {}
        this.preferenceActiveKeyConfigurations = new ArrayList(preferenceRegistry.getActiveKeyConfigurations());
        this.preferenceKeyBindings = new ArrayList(preferenceRegistry.getKeyBindings());
        this.preferenceKeyConfigurations = new ArrayList(preferenceRegistry.getKeyConfigurations());
        this.preferenceRegionalKeyBindings = new ArrayList(preferenceRegistry.getRegionalKeyBindings());
    }

    public boolean performOk() {
        this.copyFromUI();
        PreferenceRegistry preferenceRegistry = PreferenceRegistry.getInstance();
        preferenceRegistry.setActiveKeyConfigurations(this.preferenceActiveKeyConfigurations);
        preferenceRegistry.setKeyBindings(this.preferenceKeyBindings);
        preferenceRegistry.setKeyConfigurations(this.preferenceKeyConfigurations);
        preferenceRegistry.setRegionalKeyBindings(this.preferenceRegionalKeyBindings);
        try {
            preferenceRegistry.save();
        }
        catch (IOException iOException) {}
        if (this.workbench instanceof Workbench) {
            Workbench workbench = (Workbench)this.workbench;
            KeyManager.getInstance().getKeyMachine().setKeyConfiguration(this.activeKeyConfiguration != null ? this.activeKeyConfiguration.getValue() : ZERO_LENGTH_STRING);
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            if (workbenchWindow != null && workbenchWindow instanceof WorkbenchWindow) {
                WWinKeyBindingService wWinKeyBindingService = ((WorkbenchWindow)workbenchWindow).getKeyBindingService();
                if (wWinKeyBindingService != null) {
                    wWinKeyBindingService.clear();
                }
                MenuManager menuManager = ((WorkbenchWindow)workbenchWindow).getMenuManager();
                menuManager.update("text");
            }
        }
        KeyManager.getInstance().update();
        return super.performOk();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            CoreRegistry coreRegistry = CoreRegistry.getInstance();
            LocalRegistry localRegistry = LocalRegistry.getInstance();
            PreferenceRegistry preferenceRegistry = PreferenceRegistry.getInstance();
            try {
                coreRegistry.load();
            }
            catch (IOException iOException) {}
            try {
                localRegistry.load();
            }
            catch (IOException iOException) {}
            try {
                preferenceRegistry.load();
            }
            catch (IOException iOException) {}
            boolean categoriesChanged = false;
            ArrayList categories = new ArrayList();
            categories.addAll(coreRegistry.getCategories());
            categories.addAll(localRegistry.getCategories());
            categories.addAll(preferenceRegistry.getCategories());
            if (!Util.equals(categories, this.categories)) {
                this.categories = Collections.unmodifiableList(categories);
                this.categoriesById = Collections.unmodifiableSortedMap(Category.sortedMapById(this.categories));
                this.categoriesByName = Collections.unmodifiableSortedMap(Category.sortedMapByName(this.categories));
                categoriesChanged = true;
            }
            boolean commandsChanged = false;
            ArrayList commands = new ArrayList();
            commands.addAll(coreRegistry.getCommands());
            commands.addAll(localRegistry.getCommands());
            commands.addAll(preferenceRegistry.getCommands());
            if (!Util.equals(commands, this.commands)) {
                this.commands = Collections.unmodifiableList(commands);
                this.commandsById = Collections.unmodifiableSortedMap(Command.sortedMapById(this.commands));
                this.commandsByName = Collections.unmodifiableSortedMap(Command.sortedMapByName(this.commands));
                commandsChanged = true;
            }
            if (categoriesChanged || commandsChanged) {
                this.treeViewerCommands.setInput(new Object());
            }
            ArrayList scopes = new ArrayList();
            scopes.addAll(coreRegistry.getScopes());
            scopes.addAll(localRegistry.getScopes());
            scopes.addAll(preferenceRegistry.getScopes());
            if (!Util.equals(scopes, this.scopes)) {
                this.scopes = Collections.unmodifiableList(scopes);
                this.scopesById = Collections.unmodifiableSortedMap(Scope.sortedMapById(this.scopes));
                this.scopesByName = Collections.unmodifiableSortedMap(Scope.sortedMapByName(this.scopes));
                Set scopeNameSet = this.scopesByName.keySet();
                this.comboScope.setItems(scopeNameSet.toArray(new String[scopeNameSet.size()]));
            }
            this.coreActiveKeyConfigurations = new ArrayList(coreRegistry.getActiveKeyConfigurations());
            this.coreKeyBindings = new ArrayList(coreRegistry.getKeyBindings());
            this.coreKeyConfigurations = new ArrayList(coreRegistry.getKeyConfigurations());
            this.coreRegionalKeyBindings = new ArrayList(coreRegistry.getRegionalKeyBindings());
            this.localActiveKeyConfigurations = new ArrayList(localRegistry.getActiveKeyConfigurations());
            this.localKeyBindings = new ArrayList(localRegistry.getKeyBindings());
            this.localKeyConfigurations = new ArrayList(localRegistry.getKeyConfigurations());
            this.localRegionalKeyBindings = new ArrayList(localRegistry.getRegionalKeyBindings());
            this.copyToUI();
            this.update();
        } else {
            this.copyFromUI();
        }
        super.setVisible(visible);
    }

    protected Control createContents(Composite parent) {
        return this.createUI(parent);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        MessageBox restoreDefaultsMessageBox = new MessageBox(this.getShell(), 65736);
        restoreDefaultsMessageBox.setText(Util.getString(resourceBundle, "restoreDefaultsMessageBoxText"));
        restoreDefaultsMessageBox.setMessage(Util.getString(resourceBundle, "restoreDefaultsMessageBoxMessage"));
        if (restoreDefaultsMessageBox.open() == 64) {
            this.preferenceActiveKeyConfigurations = new ArrayList();
            this.preferenceKeyBindings = new ArrayList();
            this.preferenceKeyConfigurations = new ArrayList();
            this.preferenceRegionalKeyBindings = new ArrayList();
            this.copyToUI();
        }
    }

    private void copyFromUI() {
        this.activeKeyConfiguration = null;
        this.preferenceActiveKeyConfigurations = new ArrayList();
        int index = this.comboActiveKeyConfiguration.getSelectionIndex();
        if (index >= 0) {
            KeyConfiguration keyConfiguration = (KeyConfiguration)this.keyConfigurationsByName.get(this.comboActiveKeyConfiguration.getItem(index));
            this.activeKeyConfiguration = ActiveKeyConfiguration.create(null, keyConfiguration.getId());
            this.preferenceActiveKeyConfigurations.add(this.activeKeyConfiguration);
        }
        this.preferenceKeyBindings = new ArrayList(this.solve(this.tree));
        this.preferenceRegionalKeyBindings = new ArrayList();
    }

    private void copyToUI() {
        KeyConfiguration keyConfiguration;
        ArrayList activeKeyConfigurations = new ArrayList();
        activeKeyConfigurations.addAll(this.coreActiveKeyConfigurations);
        activeKeyConfigurations.addAll(this.localActiveKeyConfigurations);
        activeKeyConfigurations.addAll(this.preferenceActiveKeyConfigurations);
        if (!Util.equals(activeKeyConfigurations, this.activeKeyConfigurations)) {
            this.activeKeyConfigurations = Collections.unmodifiableList(activeKeyConfigurations);
            this.activeKeyConfiguration = (ActiveKeyConfiguration)this.activeKeyConfigurations.get(this.activeKeyConfigurations.size() - 1);
        }
        ArrayList keyConfigurations = new ArrayList();
        keyConfigurations.addAll(this.coreKeyConfigurations);
        keyConfigurations.addAll(this.localKeyConfigurations);
        keyConfigurations.addAll(this.preferenceKeyConfigurations);
        if (!Util.equals(keyConfigurations, this.keyConfigurations)) {
            this.keyConfigurations = Collections.unmodifiableList(keyConfigurations);
            this.keyConfigurationsById = Collections.unmodifiableSortedMap(KeyConfiguration.sortedMapById(this.keyConfigurations));
            this.keyConfigurationsByName = Collections.unmodifiableSortedMap(KeyConfiguration.sortedMapByName(this.keyConfigurations));
            Set keyConfigurationNameSet = this.keyConfigurationsByName.keySet();
            this.comboActiveKeyConfiguration.setItems(keyConfigurationNameSet.toArray(new String[keyConfigurationNameSet.size()]));
            this.comboKeyConfiguration.setItems(keyConfigurationNameSet.toArray(new String[keyConfigurationNameSet.size()]));
        }
        int index = -1;
        if (this.activeKeyConfiguration != null && (keyConfiguration = (KeyConfiguration)this.keyConfigurationsById.get(this.activeKeyConfiguration.getValue())) != null) {
            index = this.comboActiveKeyConfiguration.indexOf(keyConfiguration.getName());
        }
        if (index >= 0) {
            this.comboActiveKeyConfiguration.select(index);
        } else {
            this.comboActiveKeyConfiguration.clearSelection();
            this.comboActiveKeyConfiguration.deselectAll();
        }
        TreeSet coreKeyBindingSet = new TreeSet();
        coreKeyBindingSet.addAll(this.coreKeyBindings);
        TreeSet coreRegionalKeyBindingSet = new TreeSet();
        coreRegionalKeyBindingSet.addAll(this.coreRegionalKeyBindings);
        coreKeyBindingSet.addAll(KeyManager.solveRegionalKeyBindingSet(coreRegionalKeyBindingSet, this.states));
        TreeSet localKeyBindingSet = new TreeSet();
        localKeyBindingSet.addAll(this.localKeyBindings);
        TreeSet localRegionalKeyBindingSet = new TreeSet();
        localRegionalKeyBindingSet.addAll(this.localRegionalKeyBindings);
        localKeyBindingSet.addAll(KeyManager.solveRegionalKeyBindingSet(localRegionalKeyBindingSet, this.states));
        TreeSet preferenceKeyBindingSet = new TreeSet();
        preferenceKeyBindingSet.addAll(this.preferenceKeyBindings);
        TreeSet preferenceRegionalKeyBindingSet = new TreeSet();
        preferenceRegionalKeyBindingSet.addAll(this.preferenceRegionalKeyBindings);
        preferenceKeyBindingSet.addAll(KeyManager.solveRegionalKeyBindingSet(preferenceRegionalKeyBindingSet, this.states));
        this.tree = new TreeMap();
        TreeSet keyBindingSet = new TreeSet();
        keyBindingSet.addAll(coreKeyBindingSet);
        keyBindingSet.addAll(localKeyBindingSet);
        keyBindingSet.addAll(preferenceKeyBindingSet);
        Iterator<Object> iterator = keyBindingSet.iterator();
        while (iterator.hasNext()) {
            KeyBinding keyBinding = (KeyBinding)iterator.next();
            this.set(this.tree, keyBinding, false);
        }
        this.keySequencesByName = new TreeMap();
        iterator = this.tree.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof KeySequence)) continue;
            KeySequence keySequence = (KeySequence)object;
            String name = keySequence.toString();
            this.keySequencesByName.put(name, keySequence);
        }
        Set keySequenceNameSet = this.keySequencesByName.keySet();
        this.comboKeySequence.setItems(keySequenceNameSet.toArray(new String[keySequenceNameSet.size()]));
        this.selectedTreeViewerCommands();
    }

    private Control createUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Composite compositeActiveKeyConfiguration = new Composite(composite, 0);
        compositeActiveKeyConfiguration.setFont(composite.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 5;
        compositeActiveKeyConfiguration.setLayout((Layout)gridLayout);
        this.labelActiveKeyConfiguration = new Label(compositeActiveKeyConfiguration, 16384);
        this.labelActiveKeyConfiguration.setFont(compositeActiveKeyConfiguration.getFont());
        this.labelActiveKeyConfiguration.setText(Util.getString(resourceBundle, "labelActiveKeyConfiguration"));
        this.comboActiveKeyConfiguration = new Combo(compositeActiveKeyConfiguration, 8);
        this.comboActiveKeyConfiguration.setFont(compositeActiveKeyConfiguration.getFont());
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        this.comboActiveKeyConfiguration.setLayoutData((Object)gridData);
        Label labelSeparator = new Label(composite, 258);
        labelSeparator.setLayoutData((Object)new GridData(768));
        Composite compositeAssignment = new Composite(composite, 0);
        compositeAssignment.setFont(composite.getFont());
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 7;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        compositeAssignment.setLayout((Layout)gridLayout);
        compositeAssignment.setLayoutData((Object)new GridData(1808));
        this.labelCommands = new Label(compositeAssignment, 16384);
        this.labelCommands.setFont(compositeAssignment.getFont());
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.labelCommands.setLayoutData((Object)gridData);
        this.labelCommands.setText(Util.getString(resourceBundle, "labelCommands"));
        Composite compositeAssignmentLeft = new Composite(compositeAssignment, 0);
        compositeAssignmentLeft.setFont(compositeAssignment.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        compositeAssignmentLeft.setLayout((Layout)gridLayout);
        compositeAssignmentLeft.setLayoutData((Object)new GridData(1040));
        this.treeViewerCommands = new TreeViewer(compositeAssignmentLeft);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 220;
        this.treeViewerCommands.getControl().setLayoutData((Object)gridData);
        this.treeViewerCommands.setContentProvider((IContentProvider)new TreeViewerCommandsContentProvider());
        this.treeViewerCommands.setLabelProvider((IBaseLabelProvider)new TreeViewerCommandsLabelProvider());
        Composite compositeAssignmentRight = new Composite(compositeAssignment, 0);
        compositeAssignmentRight.setFont(compositeAssignment.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        compositeAssignmentRight.setLayout((Layout)gridLayout);
        compositeAssignmentRight.setLayoutData((Object)new GridData(1808));
        this.labelKeySequencesForCommand = new Label(compositeAssignmentRight, 16384);
        this.labelKeySequencesForCommand.setFont(compositeAssignmentRight.getFont());
        this.labelKeySequencesForCommand.setLayoutData((Object)new GridData(768));
        this.labelKeySequencesForCommand.setText(Util.getString(resourceBundle, "labelKeySequencesForCommand.noSelection"));
        this.tableKeySequencesForCommand = new Table(compositeAssignmentRight, 68352);
        this.tableKeySequencesForCommand.setFont(compositeAssignmentRight.getFont());
        this.tableKeySequencesForCommand.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 90;
        gridData.widthHint = 400;
        this.tableKeySequencesForCommand.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.tableKeySequencesForCommand, 0, 0);
        tableColumn.setResizable(false);
        tableColumn.setText(ZERO_LENGTH_STRING);
        tableColumn.setWidth(20);
        tableColumn = new TableColumn(this.tableKeySequencesForCommand, 0, 1);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnScope"));
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.tableKeySequencesForCommand, 0, 2);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnKeyConfiguration"));
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.tableKeySequencesForCommand, 0, 3);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnKeySequence"));
        tableColumn.setWidth(220);
        Composite compositeAssignmentChange = new Composite(compositeAssignmentRight, 0);
        compositeAssignmentChange.setFont(compositeAssignmentRight.getFont());
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        gridLayout.numColumns = 2;
        compositeAssignmentChange.setLayout((Layout)gridLayout);
        this.labelScope = new Label(compositeAssignmentChange, 16384);
        this.labelScope.setFont(compositeAssignmentChange.getFont());
        this.labelScope.setText(Util.getString(resourceBundle, "labelScope"));
        this.comboScope = new Combo(compositeAssignmentChange, 8);
        this.comboScope.setFont(compositeAssignmentChange.getFont());
        gridData = new GridData();
        gridData.widthHint = 150;
        this.comboScope.setLayoutData((Object)gridData);
        this.labelKeyConfiguration = new Label(compositeAssignmentChange, 16384);
        this.labelKeyConfiguration.setFont(compositeAssignmentChange.getFont());
        this.labelKeyConfiguration.setText(Util.getString(resourceBundle, "labelKeyConfiguration"));
        this.comboKeyConfiguration = new Combo(compositeAssignmentChange, 8);
        this.comboKeyConfiguration.setFont(compositeAssignmentChange.getFont());
        gridData = new GridData();
        gridData.widthHint = 150;
        this.comboKeyConfiguration.setLayoutData((Object)gridData);
        this.labelKeySequence = new Label(compositeAssignmentChange, 16384);
        this.labelKeySequence.setFont(compositeAssignmentChange.getFont());
        this.labelKeySequence.setText(Util.getString(resourceBundle, "labelKeySequence"));
        this.comboKeySequence = new Combo(compositeAssignmentChange, 0);
        this.comboKeySequence.setFont(compositeAssignmentChange.getFont());
        gridData = new GridData();
        gridData.widthHint = 220;
        this.comboKeySequence.setLayoutData((Object)gridData);
        Composite spacer = new Composite(compositeAssignmentChange, 0);
        gridData = new GridData();
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 0;
        spacer.setLayoutData((Object)gridData);
        spacer = new Composite(compositeAssignmentChange, 0);
        gridData = new GridData();
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        spacer.setLayoutData((Object)gridData);
        this.buttonChange = new Button(compositeAssignmentChange, 0x1000008);
        this.buttonChange.setFont(compositeAssignmentChange.getFont());
        gridData = new GridData();
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        this.buttonChange.setText(Util.getString(resourceBundle, "buttonChange"));
        gridData.widthHint = Math.max(widthHint, this.buttonChange.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonChange.setLayoutData((Object)gridData);
        spacer = new Composite(compositeAssignmentRight, 0);
        gridData = new GridData();
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        spacer.setLayoutData((Object)gridData);
        spacer = new Composite(compositeAssignmentRight, 0);
        gridData = new GridData();
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        spacer.setLayoutData((Object)gridData);
        this.labelCommandsForKeySequence = new Label(compositeAssignmentRight, 16384);
        this.labelCommandsForKeySequence.setFont(compositeAssignmentRight.getFont());
        this.labelCommandsForKeySequence.setLayoutData((Object)new GridData(768));
        this.labelCommandsForKeySequence.setText(Util.getString(resourceBundle, "labelCommandsForKeySequence.noSelection"));
        this.tableCommandsForKeySequence = new Table(compositeAssignmentRight, 68352);
        this.tableCommandsForKeySequence.setFont(compositeAssignmentRight.getFont());
        this.tableCommandsForKeySequence.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 60;
        gridData.widthHint = 400;
        this.tableCommandsForKeySequence.setLayoutData((Object)gridData);
        tableColumn = new TableColumn(this.tableCommandsForKeySequence, 0, 0);
        tableColumn.setResizable(false);
        tableColumn.setText(ZERO_LENGTH_STRING);
        tableColumn.setWidth(20);
        tableColumn = new TableColumn(this.tableCommandsForKeySequence, 0, 1);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnScope"));
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.tableCommandsForKeySequence, 0, 2);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnKeyConfiguration"));
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.tableCommandsForKeySequence, 0, 3);
        tableColumn.setResizable(true);
        tableColumn.setText(Util.getString(resourceBundle, "tableColumnCommand"));
        tableColumn.setWidth(220);
        this.comboActiveKeyConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedComboActiveKeyConfiguration();
            }
        });
        this.treeViewerCommands.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                KeyPreferencePage.this.doubleClickedTreeViewerCommands();
            }
        });
        this.treeViewerCommands.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                KeyPreferencePage.this.selectedTreeViewerCommands();
            }
        });
        this.tableKeySequencesForCommand.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                KeyPreferencePage.this.doubleClickedTableKeySequencesForCommand();
            }
        });
        this.tableKeySequencesForCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedTableKeySequencesForCommand();
            }
        });
        this.comboKeySequence.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeyPreferencePage.this.modifiedComboKeySequence();
            }
        });
        this.comboKeySequence.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedComboKeySequence();
            }
        });
        this.comboScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedComboScope();
            }
        });
        this.comboKeyConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedComboKeyConfiguration();
            }
        });
        this.buttonChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedButtonChange();
            }
        });
        this.tableCommandsForKeySequence.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                KeyPreferencePage.this.doubleClickedTableCommandsForKeySequence();
            }
        });
        this.tableCommandsForKeySequence.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyPreferencePage.this.selectedTableCommandsForKeySequence();
            }
        });
        return composite;
    }

    private void selectedComboActiveKeyConfiguration() {
    }

    private void doubleClickedTreeViewerCommands() {
    }

    private void selectedTreeViewerCommands() {
        Object object;
        this.commandRecords.clear();
        ISelection selection = this.treeViewerCommands.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof Command) {
            this.buildCommandRecords(this.tree, ((Command)object).getId(), this.commandRecords);
        }
        this.buildTableCommand();
        KeySequence keySequence = this.getKeySequence();
        String scopeId = this.getScopeId();
        String keyConfigurationId = this.getKeyConfigurationId();
        this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
        this.update();
    }

    private void doubleClickedTableKeySequencesForCommand() {
    }

    private void selectedTableKeySequencesForCommand() {
        CommandRecord commandRecord = this.getSelectedCommandRecord();
        if (commandRecord != null) {
            this.setScopeId(commandRecord.scopeId);
            this.setKeyConfigurationId(commandRecord.keyConfigurationId);
            this.setKeySequence(commandRecord.keySequence);
        }
        this.update();
    }

    private void modifiedComboKeySequence() {
        this.selectedComboKeySequence();
    }

    private void selectedComboKeySequence() {
        KeySequence keySequence = this.getKeySequence();
        String scopeId = this.getScopeId();
        String keyConfigurationId = this.getKeyConfigurationId();
        this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
        this.keySequenceRecords.clear();
        this.buildKeySequenceRecords(this.tree, keySequence, this.keySequenceRecords);
        this.buildTableKeySequence();
        this.selectTableKeySequence(scopeId, keyConfigurationId);
        this.update();
    }

    private void selectedComboScope() {
        KeySequence keySequence = this.getKeySequence();
        String scopeId = this.getScopeId();
        String keyConfigurationId = this.getKeyConfigurationId();
        this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
        this.selectTableKeySequence(scopeId, keyConfigurationId);
        this.update();
    }

    private void selectedComboKeyConfiguration() {
        KeySequence keySequence = this.getKeySequence();
        String scopeId = this.getScopeId();
        String keyConfigurationId = this.getKeyConfigurationId();
        this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
        this.selectTableKeySequence(scopeId, keyConfigurationId);
        this.update();
    }

    private void selectedButtonChange() {
        boolean validKeyConfigurationId;
        KeySequence keySequence = this.getKeySequence();
        boolean validKeySequence = keySequence != null && !keySequence.getKeyStrokes().isEmpty();
        String scopeId = this.getScopeId();
        boolean validScopeId = scopeId != null && this.scopesById.get(scopeId) != null;
        String keyConfigurationId = this.getKeyConfigurationId();
        boolean bl = validKeyConfigurationId = keyConfigurationId != null && this.keyConfigurationsById.get(keyConfigurationId) != null;
        if (validKeySequence && validScopeId && validKeyConfigurationId) {
            CommandRecord commandRecord;
            Object object;
            String commandId = null;
            ISelection selection = this.treeViewerCommands.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof Command) {
                commandId = ((Command)object).getId();
            }
            if ((commandRecord = this.getSelectedCommandRecord()) == null) {
                this.set(this.tree, KeyBinding.create(commandId, keyConfigurationId, keySequence, null, 0, scopeId), true);
            } else if (!commandRecord.customSet.isEmpty()) {
                this.clear(this.tree, keySequence, scopeId, keyConfigurationId);
            } else {
                this.set(this.tree, KeyBinding.create(null, keyConfigurationId, keySequence, null, 0, scopeId), true);
            }
            this.commandRecords.clear();
            this.buildCommandRecords(this.tree, commandId, this.commandRecords);
            this.buildTableCommand();
            this.selectTableCommand(scopeId, keyConfigurationId, keySequence);
            this.keySequenceRecords.clear();
            this.buildKeySequenceRecords(this.tree, keySequence, this.keySequenceRecords);
            this.buildTableKeySequence();
            this.selectTableKeySequence(scopeId, keyConfigurationId);
            this.update();
        }
    }

    private void doubleClickedTableCommandsForKeySequence() {
    }

    private void selectedTableCommandsForKeySequence() {
    }

    private void update() {
        Object object;
        Command command = null;
        ISelection selection = this.treeViewerCommands.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof Command) {
            command = (Command)object;
        }
        boolean commandSelected = command != null;
        KeySequence keySequence = this.getKeySequence();
        boolean validKeySequence = keySequence != null && !keySequence.getKeyStrokes().isEmpty();
        String scopeId = this.getScopeId();
        boolean validScopeId = scopeId != null && this.scopesById.get(scopeId) != null;
        String keyConfigurationId = this.getKeyConfigurationId();
        boolean validKeyConfigurationId = keyConfigurationId != null && this.keyConfigurationsById.get(keyConfigurationId) != null;
        this.labelKeySequencesForCommand.setEnabled(commandSelected);
        this.tableKeySequencesForCommand.setEnabled(commandSelected);
        this.labelKeySequence.setEnabled(commandSelected);
        this.comboKeySequence.setEnabled(commandSelected);
        this.labelScope.setEnabled(commandSelected);
        this.comboScope.setEnabled(commandSelected);
        this.labelKeyConfiguration.setEnabled(commandSelected);
        this.comboKeyConfiguration.setEnabled(commandSelected);
        this.buttonChange.setEnabled(commandSelected && validKeySequence && validScopeId && validKeyConfigurationId);
        this.labelCommandsForKeySequence.setEnabled(validKeySequence);
        this.tableCommandsForKeySequence.setEnabled(validKeySequence);
        if (commandSelected) {
            String text = MessageFormat.format(Util.getString(resourceBundle, "labelKeySequencesForCommand.selection"), String.valueOf('\'') + command.getName() + '\'');
            this.labelKeySequencesForCommand.setText(text);
        } else {
            this.labelKeySequencesForCommand.setText(Util.getString(resourceBundle, "labelKeySequencesForCommand.noSelection"));
        }
        CommandRecord commandRecord = this.getSelectedCommandRecord();
        if (commandRecord == null) {
            this.buttonChange.setText(Util.getString(resourceBundle, "buttonChange.add"));
        } else if (!commandRecord.customSet.isEmpty() && !commandRecord.defaultSet.isEmpty()) {
            this.buttonChange.setText(Util.getString(resourceBundle, "buttonChange.restore"));
        } else {
            this.buttonChange.setText(Util.getString(resourceBundle, "buttonChange.remove"));
        }
        if (validKeySequence) {
            String text = MessageFormat.format(Util.getString(resourceBundle, "labelCommandsForKeySequence.selection"), String.valueOf('\'') + keySequence.toString() + '\'');
            this.labelCommandsForKeySequence.setText(text);
        } else {
            this.labelCommandsForKeySequence.setText(Util.getString(resourceBundle, "labelCommandsForKeySequence.noSelection"));
        }
    }

    private void buildCommandRecords(SortedMap tree, String commandId, List commandRecords) {
        if (commandRecords != null) {
            commandRecords.clear();
            if (tree != null) {
                Iterator iterator = tree.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    KeySequence keySequence = (KeySequence)entry.getKey();
                    Map scopeMap = (Map)entry.getValue();
                    if (scopeMap == null) continue;
                    Iterator iterator2 = scopeMap.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry2 = iterator2.next();
                        String scopeId = (String)entry2.getKey();
                        Map keyConfigurationMap = (Map)entry2.getValue();
                        Iterator iterator3 = keyConfigurationMap.entrySet().iterator();
                        while (iterator3.hasNext()) {
                            Map.Entry entry3 = iterator3.next();
                            String keyConfigurationId = (String)entry3.getKey();
                            Map pluginMap = (Map)entry3.getValue();
                            HashSet customSet = new HashSet();
                            HashSet defaultSet = new HashSet();
                            this.buildPluginSets(pluginMap, customSet, defaultSet);
                            if (!customSet.contains(commandId) && !defaultSet.contains(commandId)) continue;
                            CommandRecord commandRecord = new CommandRecord();
                            commandRecord.commandId = commandId;
                            commandRecord.keySequence = keySequence;
                            commandRecord.scopeId = scopeId;
                            commandRecord.keyConfigurationId = keyConfigurationId;
                            commandRecord.customSet = customSet;
                            commandRecord.defaultSet = defaultSet;
                            commandRecord.calculate();
                            commandRecords.add(commandRecord);
                        }
                    }
                }
            }
        }
    }

    private void buildKeySequenceRecords(SortedMap tree, KeySequence keySequence, List keySequenceRecords) {
        if (keySequenceRecords != null) {
            Map scopeMap;
            keySequenceRecords.clear();
            if (tree != null && keySequence != null && (scopeMap = (Map)tree.get(keySequence)) != null) {
                Iterator iterator = scopeMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String scopeId2 = (String)entry.getKey();
                    Map keyConfigurationMap = (Map)entry.getValue();
                    Iterator iterator2 = keyConfigurationMap.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry2 = iterator2.next();
                        String keyConfigurationId2 = (String)entry2.getKey();
                        Map pluginMap = (Map)entry2.getValue();
                        KeySequenceRecord keySequenceRecord = new KeySequenceRecord();
                        keySequenceRecord.scopeId = scopeId2;
                        keySequenceRecord.keyConfigurationId = keyConfigurationId2;
                        keySequenceRecord.customSet = new HashSet();
                        keySequenceRecord.defaultSet = new HashSet();
                        this.buildPluginSets(pluginMap, keySequenceRecord.customSet, keySequenceRecord.defaultSet);
                        keySequenceRecord.calculate();
                        keySequenceRecords.add(keySequenceRecord);
                    }
                }
            }
        }
    }

    private void buildPluginSets(Map pluginMap, Set customSet, Set defaultSet) {
        Iterator iterator = pluginMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String pluginId = (String)entry.getKey();
            Map commandMap = (Map)entry.getValue();
            Iterator iterator2 = commandMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String commandId = (String)iterator2.next();
                if (pluginId == null) {
                    customSet.add(commandId);
                    continue;
                }
                defaultSet.add(commandId);
            }
        }
    }

    private void buildTableCommand() {
        this.tableKeySequencesForCommand.removeAll();
        int i = 0;
        while (i < this.commandRecords.size()) {
            Command command;
            CommandRecord commandRecord = (CommandRecord)this.commandRecords.get(i);
            Set customSet = commandRecord.customSet;
            Set defaultSet = commandRecord.defaultSet;
            int difference = 3;
            boolean commandConflict = false;
            String alternateCommandId = null;
            boolean alternateCommandConflict = false;
            if (customSet.isEmpty()) {
                if (defaultSet.contains(commandRecord.commandId)) {
                    commandConflict = commandRecord.defaultConflict;
                }
            } else if (defaultSet.isEmpty()) {
                if (customSet.contains(commandRecord.commandId)) {
                    difference = 0;
                    commandConflict = commandRecord.customConflict;
                }
            } else if (customSet.contains(commandRecord.commandId)) {
                difference = 1;
                commandConflict = commandRecord.customConflict;
                alternateCommandId = commandRecord.defaultCommandId;
                alternateCommandConflict = commandRecord.defaultConflict;
            } else if (defaultSet.contains(commandRecord.commandId)) {
                difference = 2;
                commandConflict = commandRecord.defaultConflict;
                alternateCommandId = commandRecord.customCommandId;
                alternateCommandConflict = commandRecord.customConflict;
            }
            TableItem tableItem = new TableItem(this.tableKeySequencesForCommand, 0);
            switch (difference) {
                case 0: {
                    tableItem.setImage(0, IMAGE_PLUS);
                    break;
                }
                case 1: {
                    tableItem.setImage(0, IMAGE_CHANGE);
                    break;
                }
                case 2: {
                    tableItem.setImage(0, IMAGE_MINUS);
                    break;
                }
            }
            Scope scope = (Scope)this.scopesById.get(commandRecord.scopeId);
            tableItem.setText(1, scope != null ? scope.getName() : this.bracket(commandRecord.scopeId));
            KeyConfiguration keyConfiguration = (KeyConfiguration)this.keyConfigurationsById.get(commandRecord.keyConfigurationId);
            tableItem.setText(2, keyConfiguration != null ? keyConfiguration.getName() : this.bracket(commandRecord.keyConfigurationId));
            boolean conflict = commandConflict || alternateCommandConflict;
            StringBuffer stringBuffer = new StringBuffer();
            if (commandRecord.keySequence != null) {
                stringBuffer.append(commandRecord.keySequence.toString());
            }
            if (commandConflict) {
                stringBuffer.append(String.valueOf(' ') + COMMAND_CONFLICT);
            }
            String alternateCommandName = null;
            alternateCommandName = alternateCommandId == null ? COMMAND_UNDEFINED : ((command = (Command)this.commandsById.get(alternateCommandId)) != null ? command.getName() : this.bracket(alternateCommandId));
            if (alternateCommandConflict) {
                alternateCommandName = String.valueOf(alternateCommandName) + ' ' + COMMAND_CONFLICT;
            }
            stringBuffer.append(' ');
            if (difference == 1) {
                stringBuffer.append(MessageFormat.format(Util.getString(resourceBundle, "was"), alternateCommandName));
            } else if (difference == 2) {
                stringBuffer.append(MessageFormat.format(Util.getString(resourceBundle, "now"), alternateCommandName));
            }
            tableItem.setText(3, stringBuffer.toString());
            if (difference == 2) {
                if (conflict) {
                    tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_CONFLICT_MINUS));
                } else {
                    tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_MINUS));
                }
            } else if (conflict) {
                tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_CONFLICT));
            }
            ++i;
        }
    }

    private void buildTableKeySequence() {
        this.tableCommandsForKeySequence.removeAll();
        int i = 0;
        while (i < this.keySequenceRecords.size()) {
            Command command;
            Command command2;
            KeySequenceRecord keySequenceRecord = (KeySequenceRecord)this.keySequenceRecords.get(i);
            int difference = 3;
            String commandId = null;
            boolean commandConflict = false;
            String alternateCommandId = null;
            boolean alternateCommandConflict = false;
            if (keySequenceRecord.customSet.isEmpty()) {
                commandId = keySequenceRecord.defaultCommandId;
                commandConflict = keySequenceRecord.defaultConflict;
            } else {
                commandId = keySequenceRecord.customCommandId;
                commandConflict = keySequenceRecord.customConflict;
                if (keySequenceRecord.defaultSet.isEmpty()) {
                    difference = 0;
                } else {
                    difference = 1;
                    alternateCommandId = keySequenceRecord.defaultCommandId;
                    alternateCommandConflict = keySequenceRecord.defaultConflict;
                }
            }
            TableItem tableItem = new TableItem(this.tableCommandsForKeySequence, 0);
            switch (difference) {
                case 0: {
                    tableItem.setImage(0, IMAGE_PLUS);
                    break;
                }
                case 1: {
                    tableItem.setImage(0, IMAGE_CHANGE);
                    break;
                }
                case 2: {
                    tableItem.setImage(0, IMAGE_MINUS);
                    break;
                }
            }
            Scope scope = (Scope)this.scopesById.get(keySequenceRecord.scopeId);
            tableItem.setText(1, scope != null ? scope.getName() : this.bracket(keySequenceRecord.scopeId));
            KeyConfiguration keyConfiguration = (KeyConfiguration)this.keyConfigurationsById.get(keySequenceRecord.keyConfigurationId);
            tableItem.setText(2, keyConfiguration != null ? keyConfiguration.getName() : this.bracket(keySequenceRecord.keyConfigurationId));
            boolean conflict = commandConflict || alternateCommandConflict;
            StringBuffer stringBuffer = new StringBuffer();
            String commandName = null;
            commandName = commandId == null ? COMMAND_UNDEFINED : ((command2 = (Command)this.commandsById.get(commandId)) != null ? command2.getName() : this.bracket(commandId));
            stringBuffer.append(commandName);
            if (commandConflict) {
                stringBuffer.append(String.valueOf(' ') + COMMAND_CONFLICT);
            }
            String alternateCommandName = null;
            alternateCommandName = alternateCommandId == null ? COMMAND_UNDEFINED : ((command = (Command)this.commandsById.get(alternateCommandId)) != null ? command.getName() : this.bracket(alternateCommandId));
            if (alternateCommandConflict) {
                alternateCommandName = String.valueOf(alternateCommandName) + ' ' + COMMAND_CONFLICT;
            }
            stringBuffer.append(' ');
            if (difference == 1) {
                stringBuffer.append(MessageFormat.format(Util.getString(resourceBundle, "was"), alternateCommandName));
            }
            tableItem.setText(3, stringBuffer.toString());
            if (difference == 2) {
                if (conflict) {
                    tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_CONFLICT_MINUS));
                } else {
                    tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_MINUS));
                }
            } else if (conflict) {
                tableItem.setForeground(new Color((Device)this.getShell().getDisplay(), RGB_CONFLICT));
            }
            ++i;
        }
    }

    private void selectTableCommand(String scopeId, String keyConfigurationId, KeySequence keySequence) {
        int selection = -1;
        int i = 0;
        while (i < this.commandRecords.size()) {
            CommandRecord commandRecord = (CommandRecord)this.commandRecords.get(i);
            if (Util.equals(scopeId, commandRecord.scopeId) && Util.equals(keyConfigurationId, commandRecord.keyConfigurationId) && Util.equals(keySequence, commandRecord.keySequence)) {
                selection = i;
                break;
            }
            ++i;
        }
        if (this.tableKeySequencesForCommand.getSelectionCount() > 1) {
            this.tableKeySequencesForCommand.deselectAll();
        }
        if (selection != this.tableKeySequencesForCommand.getSelectionIndex()) {
            if (selection == -1 || selection >= this.tableKeySequencesForCommand.getItemCount()) {
                this.tableKeySequencesForCommand.deselectAll();
            } else {
                this.tableKeySequencesForCommand.select(selection);
            }
        }
    }

    private void selectTableKeySequence(String scopeId, String keyConfigurationId) {
        int selection = -1;
        int i = 0;
        while (i < this.keySequenceRecords.size()) {
            KeySequenceRecord keySequenceRecord = (KeySequenceRecord)this.keySequenceRecords.get(i);
            if (Util.equals(scopeId, keySequenceRecord.scopeId) && Util.equals(keyConfigurationId, keySequenceRecord.keyConfigurationId)) {
                selection = i;
                break;
            }
            ++i;
        }
        if (this.tableCommandsForKeySequence.getSelectionCount() > 1) {
            this.tableCommandsForKeySequence.deselectAll();
        }
        if (selection != this.tableCommandsForKeySequence.getSelectionIndex()) {
            if (selection == -1 || selection >= this.tableCommandsForKeySequence.getItemCount()) {
                this.tableCommandsForKeySequence.deselectAll();
            } else {
                this.tableCommandsForKeySequence.select(selection);
            }
        }
    }

    private void clear(SortedMap tree, KeySequence keySequence, String scope, String keyConfiguration) {
        Map pluginMap;
        Map keyConfigurationMap;
        Map scopeMap = (Map)tree.get(keySequence);
        if (scopeMap != null && (keyConfigurationMap = (Map)scopeMap.get(scope)) != null && (pluginMap = (Map)keyConfigurationMap.get(keyConfiguration)) != null) {
            pluginMap.remove(null);
            if (pluginMap.isEmpty()) {
                keyConfigurationMap.remove(keyConfiguration);
                if (keyConfigurationMap.isEmpty()) {
                    scopeMap.remove(scope);
                    if (scopeMap.isEmpty()) {
                        tree.remove(keySequence);
                    }
                }
            }
        }
    }

    private void set(SortedMap tree, KeyBinding binding, boolean consolidate) {
        TreeSet<KeyBinding> bindingSet;
        HashMap<String, TreeSet<KeyBinding>> commandMap;
        HashMap pluginMap;
        TreeMap keyConfigurationMap;
        TreeMap scopeMap = (TreeMap)tree.get(binding.getKeySequence());
        if (scopeMap == null) {
            scopeMap = new TreeMap();
            tree.put(binding.getKeySequence(), scopeMap);
        }
        if ((keyConfigurationMap = (TreeMap)scopeMap.get(binding.getScope())) == null) {
            keyConfigurationMap = new TreeMap();
            scopeMap.put(binding.getScope(), keyConfigurationMap);
        }
        if ((pluginMap = (HashMap)keyConfigurationMap.get(binding.getKeyConfiguration())) == null) {
            pluginMap = new HashMap();
            keyConfigurationMap.put(binding.getKeyConfiguration(), pluginMap);
        }
        HashMap<String, TreeSet<KeyBinding>> hashMap = commandMap = consolidate ? null : (HashMap<String, TreeSet<KeyBinding>>)pluginMap.get(binding.getPlugin());
        if (commandMap == null) {
            commandMap = new HashMap<String, TreeSet<KeyBinding>>();
            pluginMap.put(binding.getPlugin(), commandMap);
        }
        if ((bindingSet = (TreeSet<KeyBinding>)commandMap.get(binding.getCommand())) == null) {
            bindingSet = new TreeSet<KeyBinding>();
            commandMap.put(binding.getCommand(), bindingSet);
        }
        if (consolidate) {
            bindingSet.clear();
        }
        bindingSet.add(binding);
    }

    private SortedSet solve(SortedMap tree) {
        TreeSet bindingSet = new TreeSet();
        Iterator iterator = tree.values().iterator();
        while (iterator.hasNext()) {
            Map scopeMap = (Map)iterator.next();
            Iterator iterator2 = scopeMap.values().iterator();
            while (iterator2.hasNext()) {
                Map keyConfigurationMap = (Map)iterator2.next();
                Iterator iterator3 = keyConfigurationMap.values().iterator();
                while (iterator3.hasNext()) {
                    Map pluginMap = (Map)iterator3.next();
                    Map commandMap = (Map)pluginMap.get(null);
                    if (commandMap == null) continue;
                    Iterator iterator4 = commandMap.values().iterator();
                    while (iterator4.hasNext()) {
                        bindingSet.addAll((Set)iterator4.next());
                    }
                }
            }
        }
        return bindingSet;
    }

    private CommandRecord getSelectedCommandRecord() {
        int selection = this.tableKeySequencesForCommand.getSelectionIndex();
        if (selection >= 0 && selection < this.commandRecords.size() && this.tableKeySequencesForCommand.getSelectionCount() == 1) {
            return (CommandRecord)this.commandRecords.get(selection);
        }
        return null;
    }

    private KeySequenceRecord getSelectedKeySequenceRecord() {
        int selection = this.tableCommandsForKeySequence.getSelectionIndex();
        if (selection >= 0 && selection < this.keySequenceRecords.size() && this.tableCommandsForKeySequence.getSelectionCount() == 1) {
            return (KeySequenceRecord)this.keySequenceRecords.get(selection);
        }
        return null;
    }

    private KeySequence getKeySequence() {
        KeySequence keySequence = null;
        String name = this.comboKeySequence.getText();
        keySequence = (KeySequence)this.keySequencesByName.get(name);
        if (keySequence == null) {
            keySequence = KeySequence.parse(name);
        }
        return keySequence;
    }

    private void setKeySequence(KeySequence keySequence) {
        this.comboKeySequence.setText(keySequence != null ? keySequence.toString() : ZERO_LENGTH_STRING);
    }

    private String getScopeId() {
        int selection = this.comboScope.getSelectionIndex();
        ArrayList scopes = new ArrayList(this.scopesByName.values());
        if (selection >= 0 && selection < scopes.size()) {
            Scope scope = (Scope)scopes.get(selection);
            return scope.getId();
        }
        return null;
    }

    private void setScopeId(String scopeId) {
        this.comboScope.clearSelection();
        this.comboScope.deselectAll();
        if (scopeId != null) {
            ArrayList scopes = new ArrayList(this.scopesByName.values());
            int i = 0;
            while (i < scopes.size()) {
                Scope scope = (Scope)scopes.get(i);
                if (scope.getId().equals(scopeId)) {
                    this.comboScope.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private String getKeyConfigurationId() {
        int selection = this.comboKeyConfiguration.getSelectionIndex();
        ArrayList keyConfigurations = new ArrayList(this.keyConfigurationsByName.values());
        if (selection >= 0 && selection < keyConfigurations.size()) {
            KeyConfiguration keyConfiguration = (KeyConfiguration)keyConfigurations.get(selection);
            return keyConfiguration.getId();
        }
        return null;
    }

    private void setKeyConfigurationId(String keyConfigurationId) {
        this.comboKeyConfiguration.clearSelection();
        this.comboKeyConfiguration.deselectAll();
        if (keyConfigurationId != null) {
            ArrayList keyConfigurations = new ArrayList(this.keyConfigurationsByName.values());
            int i = 0;
            while (i < keyConfigurations.size()) {
                KeyConfiguration keyConfiguration = (KeyConfiguration)keyConfigurations.get(i);
                if (keyConfiguration.getId().equals(keyConfigurationId)) {
                    this.comboKeyConfiguration.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    private String bracket(String string) {
        return string != null ? String.valueOf('[') + string + ']' : "[]";
    }

    private String doubleQuote(String string) {
        return string != null ? String.valueOf('\"') + string + '\"' : "\"\"";
    }

    private String singleQuote(String string) {
        return string != null ? String.valueOf('\'') + string + '\'' : "''";
    }

    private final class CommandRecord {
        String commandId;
        KeySequence keySequence;
        String scopeId;
        String keyConfigurationId;
        Set customSet;
        Set defaultSet;
        boolean customConflict = false;
        String customCommandId = null;
        boolean defaultConflict = false;
        String defaultCommandId = null;

        CommandRecord() {
        }

        void calculate() {
            if (this.customSet.size() > 1) {
                this.customConflict = true;
            } else if (!this.customSet.isEmpty()) {
                this.customCommandId = (String)this.customSet.iterator().next();
            }
            if (this.defaultSet.size() > 1) {
                this.defaultConflict = true;
            } else if (!this.defaultSet.isEmpty()) {
                this.defaultCommandId = (String)this.defaultSet.iterator().next();
            }
        }
    }

    private final class KeySequenceRecord {
        String scopeId;
        String keyConfigurationId;
        Set customSet;
        Set defaultSet;
        boolean customConflict = false;
        String customCommandId = null;
        boolean defaultConflict = false;
        String defaultCommandId = null;

        KeySequenceRecord() {
        }

        void calculate() {
            if (this.customSet.size() > 1) {
                this.customConflict = true;
            } else if (!this.customSet.isEmpty()) {
                this.customCommandId = (String)this.customSet.iterator().next();
            }
            if (this.defaultSet.size() > 1) {
                this.defaultConflict = true;
            } else if (!this.defaultSet.isEmpty()) {
                this.defaultCommandId = (String)this.defaultSet.iterator().next();
            }
        }
    }

    private class TreeViewerCommandsContentProvider
    implements ITreeContentProvider {
        TreeViewerCommandsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Command> children = new ArrayList<Command>();
            if (parentElement instanceof Category) {
                if (KeyPreferencePage.this.commands != null) {
                    Category category = (Category)parentElement;
                    int i = 0;
                    while (i < KeyPreferencePage.this.commands.size()) {
                        Command command = (Command)KeyPreferencePage.this.commands.get(i);
                        if (category.getId().equals(command.getCategory())) {
                            children.add(command);
                        }
                        ++i;
                    }
                }
            } else if (parentElement == null && KeyPreferencePage.this.categories != null && KeyPreferencePage.this.commands != null) {
                ArrayList categories = new ArrayList(KeyPreferencePage.this.categories);
                Collections.sort(categories, Category.nameComparator());
                children.addAll(categories);
                ArrayList<Command> commands = new ArrayList<Command>();
                int i = 0;
                while (i < KeyPreferencePage.this.commands.size()) {
                    Command command = (Command)KeyPreferencePage.this.commands.get(i);
                    if (command.getCategory() == null) {
                        commands.add(command);
                    }
                    ++i;
                }
                Collections.sort(commands, Command.nameComparator());
                children.addAll(commands);
            }
            return children.toArray();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(null);
        }

        public Object getParent(Object element) {
            String category;
            if (element instanceof Command && KeyPreferencePage.this.categoriesById != null && (category = ((Command)element).getCategory()) != null) {
                return KeyPreferencePage.this.categoriesById.get(category);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length >= 1;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TreeViewerCommandsLabelProvider
    extends LabelProvider {
        TreeViewerCommandsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Category) {
                return ((Category)element).getName();
            }
            if (element instanceof Command) {
                return ((Command)element).getName();
            }
            return super.getText(element);
        }
    }
}

