/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.AbstractMutableRegistry;
import org.eclipse.ui.internal.commands.ActiveKeyConfiguration;
import org.eclipse.ui.internal.commands.KeyBinding;
import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.KeyStroke;
import org.eclipse.ui.internal.commands.Persistence;

public final class PreferenceRegistry
extends AbstractMutableRegistry {
    private static final String DEPRECATED_KEY_ACTIVE_KEY_CONFIGURATIONS = "acceleratorConfigurationId";
    private static final String DEPRECATED_KEY_KEY_BINDINGS = "org.eclipse.ui.keybindings";
    private static final String DEPRECATED_TAG_BINDING = "binding";
    private static final String DEPRECATED_TAG_BINDINGS = "bindings";
    private static final String DEPRECATED_TAG_ACCELERATOR = "accelerator";
    private static final String DEPRECATED_TAG_ACTION = "action";
    private static final String DEPRECATED_TAG_CONFIGURATION = "configuration";
    private static final String DEPRECATED_TAG_KEY_SEQUENCE = "keysequence";
    private static final String DEPRECATED_TAG_KEY_STROKE = "keystroke";
    private static final String DEPRECATED_TAG_PLUGIN = "plugin";
    private static final String DEPRECATED_TAG_RANK = "rank";
    private static final String DEPRECATED_TAG_SCOPE = "scope";
    private static final String KEY = "org.eclipse.ui.commands";
    private static final String TAG_ROOT = "org.eclipse.ui.commands";
    public static PreferenceRegistry instance;

    public static PreferenceRegistry getInstance() {
        if (instance == null) {
            instance = new PreferenceRegistry();
        }
        return instance;
    }

    private PreferenceRegistry() {
    }

    public void load() throws IOException {
        String preferenceString;
        Object var9_12;
        IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        String deprecatedActiveKeyConfigurationsString = preferenceStore.getString(DEPRECATED_KEY_ACTIVE_KEY_CONFIGURATIONS);
        List<ActiveKeyConfiguration> deprecatedActiveKeyConfigurations = Collections.EMPTY_LIST;
        if (deprecatedActiveKeyConfigurationsString != null && deprecatedActiveKeyConfigurationsString.length() != 0) {
            deprecatedActiveKeyConfigurations = Collections.singletonList(ActiveKeyConfiguration.create(null, deprecatedActiveKeyConfigurationsString));
        }
        String deprecatedKeyBindingsString = preferenceStore.getString(DEPRECATED_KEY_KEY_BINDINGS);
        List deprecatedKeyBindings = Collections.EMPTY_LIST;
        if (deprecatedKeyBindingsString != null && deprecatedKeyBindingsString.length() != 0) {
            BufferedReader reader = new BufferedReader(new StringReader(deprecatedKeyBindingsString));
            try {
                try {
                    XMLMemento memento = XMLMemento.createReadRoot(reader);
                    IMemento mementoKeyBindings = memento.getChild(DEPRECATED_TAG_BINDINGS);
                    if (mementoKeyBindings != null) {
                        deprecatedKeyBindings = Collections.unmodifiableList(PreferenceRegistry.readDeprecatedKeyBindings(mementoKeyBindings, DEPRECATED_TAG_BINDING));
                    }
                }
                catch (WorkbenchException workbenchException) {
                    throw new IOException();
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                ((Reader)reader).close();
                throw throwable;
            }
            var9_12 = null;
            ((Reader)reader).close();
        }
        if ((preferenceString = preferenceStore.getString("org.eclipse.ui.commands")) != null && preferenceString.length() != 0) {
            StringReader reader = new StringReader(preferenceString);
            try {
                try {
                    XMLMemento memento = XMLMemento.createReadRoot(reader);
                    this.activeGestureConfigurations = Collections.unmodifiableList(Persistence.readActiveGestureConfigurations(memento, "activeGestureConfiguration", null));
                    this.activeKeyConfigurations = Collections.unmodifiableList(Persistence.readActiveKeyConfigurations(memento, "activeKeyConfiguration", null));
                    this.categories = Collections.unmodifiableList(Persistence.readCategories(memento, "category", null));
                    this.commands = Collections.unmodifiableList(Persistence.readCommands(memento, "command", null));
                    this.gestureBindings = Collections.unmodifiableList(Persistence.readGestureBindings(memento, "gestureBinding", null));
                    this.gestureConfigurations = Collections.unmodifiableList(Persistence.readGestureConfigurations(memento, "gestureConfiguration", null));
                    this.keyBindings = Collections.unmodifiableList(Persistence.readKeyBindings(memento, "keyBinding", null));
                    this.keyConfigurations = Collections.unmodifiableList(Persistence.readKeyConfigurations(memento, "keyConfiguration", null));
                    this.regionalGestureBindings = Collections.unmodifiableList(Persistence.readRegionalGestureBindings(memento, "regionalGestureBinding", null));
                    this.regionalKeyBindings = Collections.unmodifiableList(Persistence.readRegionalKeyBindings(memento, "regionalKeyBinding", null));
                    this.scopes = Collections.unmodifiableList(Persistence.readScopes(memento, DEPRECATED_TAG_SCOPE, null));
                }
                catch (WorkbenchException workbenchException) {
                    throw new IOException();
                }
            }
            catch (Throwable throwable) {
                var9_12 = null;
                ((Reader)reader).close();
                throw throwable;
            }
            var9_12 = null;
            ((Reader)reader).close();
        }
        ArrayList<ActiveKeyConfiguration> activeKeyConfigurations = new ArrayList<ActiveKeyConfiguration>();
        activeKeyConfigurations.addAll(deprecatedActiveKeyConfigurations);
        activeKeyConfigurations.addAll(this.activeKeyConfigurations);
        this.activeKeyConfigurations = Collections.unmodifiableList(activeKeyConfigurations);
        ArrayList keyBindings = new ArrayList();
        keyBindings.addAll(deprecatedKeyBindings);
        keyBindings.addAll(this.keyBindings);
        this.keyBindings = Collections.unmodifiableList(keyBindings);
    }

    public void save() throws IOException {
        XMLMemento xmlMemento = XMLMemento.createWriteRoot("org.eclipse.ui.commands");
        Persistence.writeActiveGestureConfigurations(xmlMemento, "activeGestureConfiguration", this.activeGestureConfigurations);
        Persistence.writeActiveKeyConfigurations(xmlMemento, "activeKeyConfiguration", this.activeKeyConfigurations);
        Persistence.writeCategories(xmlMemento, "category", this.categories);
        Persistence.writeCommands(xmlMemento, "command", this.commands);
        Persistence.writeGestureBindings(xmlMemento, "gestureBinding", this.gestureBindings);
        Persistence.writeGestureConfigurations(xmlMemento, "gestureConfiguration", this.gestureConfigurations);
        Persistence.writeKeyBindings(xmlMemento, "keyBinding", this.keyBindings);
        Persistence.writeKeyConfigurations(xmlMemento, "keyConfiguration", this.keyConfigurations);
        Persistence.writeRegionalGestureBindings(xmlMemento, "regionalGestureBinding", this.regionalGestureBindings);
        Persistence.writeRegionalKeyBindings(xmlMemento, "regionalKeyBinding", this.regionalKeyBindings);
        Persistence.writeScopes(xmlMemento, DEPRECATED_TAG_SCOPE, this.scopes);
        StringWriter writer = new StringWriter();
        try {
            xmlMemento.save(writer);
            IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue("org.eclipse.ui.commands", ((Object)writer).toString());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((Writer)writer).close();
            throw throwable;
        }
        Object var4_6 = null;
        ((Writer)writer).close();
    }

    private static KeyBinding readDeprecatedKeyBinding(IMemento memento) throws IllegalArgumentException {
        String scope;
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        String command = memento.getString(DEPRECATED_TAG_ACTION);
        String keyConfiguration = memento.getString(DEPRECATED_TAG_CONFIGURATION);
        if (keyConfiguration == null) {
            keyConfiguration = "";
        }
        KeySequence keySequence = null;
        IMemento mementoKeySequence = memento.getChild(DEPRECATED_TAG_KEY_SEQUENCE);
        if (mementoKeySequence != null) {
            keySequence = PreferenceRegistry.readDeprecatedKeySequence(mementoKeySequence);
        }
        if (keySequence == null) {
            keySequence = Persistence.ZERO_LENGTH_KEY_SEQUENCE;
        }
        String plugin = memento.getString(DEPRECATED_TAG_PLUGIN);
        Integer rank = memento.getInteger(DEPRECATED_TAG_RANK);
        if (rank == null) {
            rank = Persistence.ZERO;
        }
        if ((scope = memento.getString(DEPRECATED_TAG_SCOPE)) == null) {
            scope = "";
        }
        return KeyBinding.create(command, keyConfiguration, keySequence, plugin, rank, scope);
    }

    private static List readDeprecatedKeyBindings(IMemento memento, String name) throws IllegalArgumentException {
        if (memento == null || name == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<KeyBinding> list = new ArrayList<KeyBinding>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(PreferenceRegistry.readDeprecatedKeyBinding(mementos[i]));
            ++i;
        }
        return list;
    }

    private static KeySequence readDeprecatedKeySequence(IMemento memento) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        IMemento[] mementos = memento.getChildren(DEPRECATED_TAG_KEY_STROKE);
        if (mementos == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            keyStrokes.add(PreferenceRegistry.readDeprecatedKeyStroke(mementos[i]));
            ++i;
        }
        return KeySequence.create(keyStrokes);
    }

    private static KeyStroke readDeprecatedKeyStroke(IMemento memento) throws IllegalArgumentException {
        if (memento == null) {
            throw new IllegalArgumentException();
        }
        Integer value = memento.getInteger(DEPRECATED_TAG_ACCELERATOR);
        if (value == null) {
            value = Persistence.ZERO;
        }
        return KeyStroke.create(value);
    }
}

