/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.internal.commands.Path;
import org.eclipse.ui.internal.commands.Util;

public final class State
implements Comparable {
    static final int MAXIMUM_PATHS = 8;
    private static final int HASH_INITIAL = 117;
    private static final int HASH_FACTOR = 127;
    private List paths;

    static State create(List paths) throws IllegalArgumentException {
        return new State(paths);
    }

    private State(List paths) throws IllegalArgumentException {
        if (paths == null) {
            throw new IllegalArgumentException();
        }
        this.paths = Collections.unmodifiableList(new ArrayList(paths));
        if (this.paths.size() >= 8) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = this.paths.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Path) continue;
            throw new IllegalArgumentException();
        }
    }

    public int compareTo(Object object) {
        return Util.compare(this.paths, ((State)object).paths);
    }

    public boolean equals(Object object) {
        if (!(object instanceof State)) {
            return false;
        }
        return this.paths.equals(((State)object).paths);
    }

    public List getPaths() {
        return this.paths;
    }

    public int hashCode() {
        int result = 117;
        Iterator iterator = this.paths.iterator();
        while (iterator.hasNext()) {
            result = result * 127 + ((Path)iterator.next()).hashCode();
        }
        return result;
    }

    public int match(State state) {
        if (this.paths.size() != state.paths.size()) {
            return -1;
        }
        int match = 0;
        int i = 0;
        while (i < this.paths.size()) {
            int path = ((Path)this.paths.get(i)).match((Path)state.paths.get(i));
            if (path == -1 || path >= 16) {
                return -1;
            }
            match += path << (7 - i) * 4;
            ++i;
        }
        return match;
    }

    public String toString() {
        return this.paths.toString();
    }
}

