/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecorationReference;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class DecorationScheduler
implements IResourceChangeListener {
    private Map resultCache = Collections.synchronizedMap(new HashMap());
    private List awaitingDecoration = new ArrayList();
    private List pendingUpdate = new ArrayList();
    private Map awaitingDecorationValues = new HashMap();
    private DecoratorManager decoratorManager;
    private boolean shutdown = false;
    private Thread decoratorUpdateThread;
    private final int NUM_TO_BATCH = 50;

    DecorationScheduler(DecoratorManager manager) {
        this.decoratorManager = manager;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public String decorateWithText(String text, Object element, Object adaptedElement) {
        if (element == null) {
            return text;
        }
        DecorationResult decoration = (DecorationResult)this.resultCache.get(element);
        if (decoration == null) {
            this.queueForDecoration(element, adaptedElement);
            return text;
        }
        return decoration.decorateWithText(text);
    }

    private synchronized void queueForDecoration(Object element, Object adaptedElement) {
        if (this.decoratorUpdateThread == null) {
            this.createDecoratorThread();
            this.decoratorUpdateThread.start();
        }
        if (!this.awaitingDecorationValues.containsKey(element)) {
            DecorationReference reference = new DecorationReference(element, adaptedElement);
            this.awaitingDecorationValues.put(element, reference);
            this.awaitingDecoration.add(element);
            this.notify();
        }
    }

    public Image decorateWithOverlays(Image image, Object element, Object adaptedElement) {
        if (element == null) {
            return image;
        }
        DecorationResult decoration = (DecorationResult)this.resultCache.get(element);
        if (decoration == null) {
            this.queueForDecoration(element, adaptedElement);
            return image;
        }
        return decoration.decorateWithOverlays(image, this.decoratorManager.getLightweightManager().getOverlayCache());
    }

    public void decorated() {
        if (!this.shutdown) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (DecorationScheduler.this.pendingUpdate.isEmpty()) {
                        return;
                    }
                    Object[] elements = DecorationScheduler.this.pendingUpdate.toArray(new Object[DecorationScheduler.this.pendingUpdate.size()]);
                    DecorationScheduler.this.pendingUpdate.clear();
                    DecorationScheduler.this.decoratorManager.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DecorationScheduler.this.decoratorManager, elements));
                    DecorationScheduler.this.resultCache.clear();
                }
            });
        }
    }

    void shutdown() {
        this.shutdown = true;
        DecorationScheduler decorationScheduler = this;
        synchronized (decorationScheduler) {
            this.notifyAll();
        }
        try {
            if (this.decoratorUpdateThread != null) {
                this.decoratorUpdateThread.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                ArrayList changedObjects = new ArrayList();
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 8) {
                            return true;
                        }
                        switch (delta.getKind()) {
                            case 2: {
                                DecorationScheduler.this.resultCache.remove(resource);
                                break;
                            }
                            case 4: {
                                DecorationScheduler.this.resultCache.remove(resource);
                            }
                        }
                        return true;
                    }
                });
                changedObjects.clear();
            }
            catch (CoreException exception) {
                WorkbenchPlugin.getDefault().getLog().log(exception.getStatus());
            }
        }
    }

    synchronized DecorationReference next() {
        try {
            if (this.shutdown) {
                return null;
            }
            if (this.awaitingDecoration.isEmpty()) {
                this.wait();
            }
            if (this.shutdown) {
                return null;
            }
            Object element = this.awaitingDecoration.remove(0);
            return (DecorationReference)this.awaitingDecorationValues.remove(element);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private void createDecoratorThread() {
        Runnable decorationRunnable = new Runnable(){

            public void run() {
                while (true) {
                    DecorationReference reference = DecorationScheduler.this.next();
                    DecorationBuilder cacheResult = new DecorationBuilder();
                    if (reference == null) {
                        return;
                    }
                    if (!DecorationScheduler.this.resultCache.containsKey(reference.getElement())) {
                        Object adapted = reference.getAdaptedElement();
                        if (adapted != null) {
                            DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(adapted, cacheResult);
                            if (cacheResult.hasValue()) {
                                DecorationScheduler.this.resultCache.put(adapted, cacheResult.createResult());
                            }
                        }
                        DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(reference.getElement(), cacheResult);
                        if (cacheResult.hasValue()) {
                            DecorationScheduler.this.resultCache.put(reference.getElement(), cacheResult.createResult());
                            DecorationScheduler.this.pendingUpdate.add(reference.getElement());
                            cacheResult.clearContents();
                        }
                    }
                    if (!DecorationScheduler.this.awaitingDecoration.isEmpty()) continue;
                    DecorationScheduler.this.decorated();
                }
            }
        };
        this.decoratorUpdateThread = new Thread(decorationRunnable, "Decoration");
        this.decoratorUpdateThread.setPriority(1);
    }
}

