/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.internal.DefaultContributorResourceAdapter;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationScheduler;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.DecoratorRegistryReader;
import org.eclipse.ui.internal.decorators.FullDecoratorDefinition;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.decorators.LightweightDecoratorManager;

public class DecoratorManager
implements ILabelDecorator,
ILabelProviderListener,
IDecoratorManager {
    private DecorationScheduler scheduler;
    private LightweightDecoratorManager lightweightManager;
    private ListenerList listeners = new ListenerList();
    private HashMap cachedFullDecorators = new HashMap();
    private FullDecoratorDefinition[] fullDefinitions;
    private static final FullDecoratorDefinition[] EMPTY_FULL_DEF = new FullDecoratorDefinition[0];
    private final String PREFERENCE_SEPARATOR = ",";
    private final String VALUE_SEPARATOR = ":";
    private final String P_TRUE = "true";
    private final String P_FALSE = "false";
    static /* synthetic */ Class class$0;

    public DecoratorManager() {
        DecoratorRegistryReader reader = new DecoratorRegistryReader();
        Collection values = reader.readRegistry(Platform.getPluginRegistry());
        ArrayList<DecoratorDefinition> full = new ArrayList<DecoratorDefinition>();
        ArrayList<DecoratorDefinition> lightweight = new ArrayList<DecoratorDefinition>();
        Iterator allDefinitions = values.iterator();
        while (allDefinitions.hasNext()) {
            DecoratorDefinition nextDefinition = (DecoratorDefinition)allDefinitions.next();
            if (nextDefinition.isFull()) {
                full.add(nextDefinition);
                continue;
            }
            lightweight.add(nextDefinition);
        }
        this.fullDefinitions = new FullDecoratorDefinition[full.size()];
        full.toArray(this.fullDefinitions);
        LightweightDecoratorDefinition[] lightweightDefinitions = new LightweightDecoratorDefinition[lightweight.size()];
        lightweight.toArray(lightweightDefinitions);
        this.lightweightManager = new LightweightDecoratorManager(lightweightDefinitions);
        this.scheduler = new DecorationScheduler(this);
    }

    static Collection getDecoratorsFor(Object element, DecoratorDefinition[] enabledDefinitions) {
        ArrayList<DecoratorDefinition> decorators = new ArrayList<DecoratorDefinition>();
        int i = 0;
        while (i < enabledDefinitions.length) {
            if (enabledDefinitions[i].getEnablement().isEnabledForExpression(element, "objectClass")) {
                decorators.add(enabledDefinitions[i]);
            }
            ++i;
        }
        return decorators;
    }

    public void restoreListeners() {
        this.applyDecoratorsPreference();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireListeners(final LabelProviderChangedEvent event) {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ILabelProviderListener l = (ILabelProviderListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    DecoratorManager.this.removeListener(l);
                }
            });
            ++i;
        }
    }

    public String decorateText(String text, Object element) {
        String newResult;
        Object adapted = this.getResourceAdapter(element);
        String result = this.scheduler.decorateWithText(text, element, adapted);
        FullDecoratorDefinition[] decorators = this.getDecoratorsFor(element);
        int i = 0;
        while (i < decorators.length) {
            if (decorators[i].getEnablement().isEnabledFor(element) && (newResult = decorators[i].decorateText(result, element)) != null) {
                result = newResult;
            }
            ++i;
        }
        if (adapted != null) {
            decorators = this.getDecoratorsFor(adapted);
            i = 0;
            while (i < decorators.length) {
                if (decorators[i].isAdaptable() && decorators[i].getEnablement().isEnabledFor(adapted) && (newResult = decorators[i].decorateText(result, adapted)) != null) {
                    result = newResult;
                }
                ++i;
            }
        }
        return result;
    }

    public Image decorateImage(Image image, Object element) {
        Image newResult;
        Object adapted = this.getResourceAdapter(element);
        Image result = this.scheduler.decorateWithOverlays(image, element, adapted);
        FullDecoratorDefinition[] decorators = this.getDecoratorsFor(element);
        int i = 0;
        while (i < decorators.length) {
            if (decorators[i].getEnablement().isEnabledFor(element) && (newResult = decorators[i].decorateImage(result, element)) != null) {
                result = newResult;
            }
            ++i;
        }
        if (adapted != null) {
            decorators = this.getDecoratorsFor(adapted);
            i = 0;
            while (i < decorators.length) {
                if (decorators[i].isAdaptable() && decorators[i].getEnablement().isEnabledFor(adapted) && (newResult = decorators[i].decorateImage(result, adapted)) != null) {
                    result = newResult;
                }
                ++i;
            }
        }
        return result;
    }

    private Object getResourceAdapter(Object element) {
        if (element instanceof IAdaptable) {
            IResource adapted;
            Object resourceAdapter;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.IContributorResourceAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resourceAdapter = adaptable.getAdapter((Class)clazz)) == null) {
                resourceAdapter = DefaultContributorResourceAdapter.getDefault();
            }
            if ((adapted = ((IContributorResourceAdapter)resourceAdapter).getAdaptedResource(adaptable)) != element) {
                return adapted;
            }
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.isLabelProperty(element, property, true);
    }

    public boolean isLabelProperty(Object element, String property, boolean checkAdapted) {
        boolean fullCheck = this.isLabelProperty(element, property, this.getDecoratorsFor(element));
        if (fullCheck) {
            return fullCheck;
        }
        boolean lightweightCheck = this.isLabelProperty(element, property, this.lightweightManager.getDecoratorsFor(element));
        if (lightweightCheck) {
            return true;
        }
        if (checkAdapted) {
            Object adapted = this.getResourceAdapter(element);
            if (adapted == null || adapted == element) {
                return false;
            }
            fullCheck = this.isLabelProperty(adapted, property, this.getDecoratorsFor(adapted));
            if (fullCheck) {
                return fullCheck;
            }
            return this.isLabelProperty(adapted, property, this.lightweightManager.getDecoratorsFor(adapted));
        }
        return false;
    }

    private boolean isLabelProperty(Object element, String property, DecoratorDefinition[] decorators) {
        int i = 0;
        while (i < decorators.length) {
            if (decorators[i].getEnablement().isEnabledFor(element) && decorators[i].isLabelProperty(element, property)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Vector computeClassOrder(Class extensibleClass) {
        Vector result = new Vector(4);
        Class clazz = extensibleClass;
        while (clazz != null) {
            result.addElement(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List computeInterfaceOrder(List classList) {
        ArrayList result = new ArrayList(4);
        HashMap seen = new HashMap(4);
        Iterator list = classList.iterator();
        while (list.hasNext()) {
            Class[] interfaces = ((Class)list.next()).getInterfaces();
            this.internalComputeInterfaceOrder(interfaces, result, seen);
        }
        return result;
    }

    private void internalComputeInterfaceOrder(Class[] interfaces, List result, Map seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(seen.size());
        int i = 0;
        while (i < interfaces.length) {
            Class interfac = interfaces[i];
            if (seen.get(interfac) == null) {
                result.add(interfac);
                seen.put(interfac, interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator newList = newInterfaces.iterator();
        while (newList.hasNext()) {
            this.internalComputeInterfaceOrder(((Class)newList.next()).getInterfaces(), result, seen);
        }
    }

    private FullDecoratorDefinition[] enabledFullDefinitions() {
        ArrayList<FullDecoratorDefinition> result = new ArrayList<FullDecoratorDefinition>();
        int i = 0;
        while (i < this.fullDefinitions.length) {
            if (this.fullDefinitions[i].isEnabled()) {
                result.add(this.fullDefinitions[i]);
            }
            ++i;
        }
        FullDecoratorDefinition[] returnArray = new FullDecoratorDefinition[result.size()];
        result.toArray(returnArray);
        return returnArray;
    }

    public void dispose() {
    }

    public void reset() {
        this.cachedFullDecorators = new HashMap();
        this.lightweightManager.reset();
        this.fireListeners(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        this.writeDecoratorsPreference();
    }

    public DecoratorDefinition[] getAllDecoratorDefinitions() {
        LightweightDecoratorDefinition[] lightweightDefinitions = this.lightweightManager.getDefinitions();
        DecoratorDefinition[] returnValue = new DecoratorDefinition[this.fullDefinitions.length + lightweightDefinitions.length];
        System.arraycopy(this.fullDefinitions, 0, returnValue, 0, this.fullDefinitions.length);
        System.arraycopy(lightweightDefinitions, 0, returnValue, this.fullDefinitions.length, lightweightDefinitions.length);
        return returnValue;
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.fireListeners(event);
    }

    private void writeDecoratorsPreference() {
        StringBuffer enabledIds = new StringBuffer();
        this.writeDecoratorsPreference(enabledIds, this.fullDefinitions);
        this.writeDecoratorsPreference(enabledIds, this.lightweightManager.getDefinitions());
        WorkbenchPlugin.getDefault().getPreferenceStore().setValue("ENABLED_DECORATORS", enabledIds.toString());
    }

    private void writeDecoratorsPreference(StringBuffer enabledIds, DecoratorDefinition[] definitions) {
        int i = 0;
        while (i < definitions.length) {
            enabledIds.append(definitions[i].getId());
            enabledIds.append(":");
            if (definitions[i].isEnabled()) {
                enabledIds.append("true");
            } else {
                enabledIds.append("false");
            }
            enabledIds.append(",");
            ++i;
        }
    }

    private void applyDecoratorsPreference() {
        String id;
        String preferenceValue = WorkbenchPlugin.getDefault().getPreferenceStore().getString("ENABLED_DECORATORS");
        StringTokenizer tokenizer = new StringTokenizer(preferenceValue, ",");
        HashSet<String> enabledIds = new HashSet<String>();
        HashSet<String> disabledIds = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String nextValuePair = tokenizer.nextToken();
            id = nextValuePair.substring(0, nextValuePair.indexOf(":"));
            if (nextValuePair.endsWith("true")) {
                enabledIds.add(id);
                continue;
            }
            disabledIds.add(id);
        }
        int i = 0;
        while (i < this.fullDefinitions.length) {
            id = this.fullDefinitions[i].getId();
            if (enabledIds.contains(id)) {
                this.fullDefinitions[i].setEnabledWithErrorHandling(true);
            } else if (disabledIds.contains(id)) {
                this.fullDefinitions[i].setEnabledWithErrorHandling(false);
            }
            ++i;
        }
        LightweightDecoratorDefinition[] lightweightDefinitions = this.lightweightManager.getDefinitions();
        int i2 = 0;
        while (i2 < lightweightDefinitions.length) {
            String id2 = lightweightDefinitions[i2].getId();
            if (enabledIds.contains(id2)) {
                lightweightDefinitions[i2].setEnabledWithErrorHandling(true);
            } else if (disabledIds.contains(id2)) {
                lightweightDefinitions[i2].setEnabledWithErrorHandling(false);
            }
            ++i2;
        }
    }

    public void shutdown() {
        int i = 0;
        while (i < this.fullDefinitions.length) {
            if (this.fullDefinitions[i].isEnabled()) {
                this.fullDefinitions[i].setEnabledWithErrorHandling(false);
            }
            ++i;
        }
        this.lightweightManager.shutdown();
        this.scheduler.shutdown();
    }

    public boolean getEnabled(String decoratorId) {
        DecoratorDefinition definition = this.getDecoratorDefinition(decoratorId);
        if (definition == null) {
            return false;
        }
        return definition.isEnabled();
    }

    public ILabelDecorator getLabelDecorator() {
        return this;
    }

    public void setEnabled(String decoratorId, boolean enabled) throws CoreException {
        DecoratorDefinition definition = this.getDecoratorDefinition(decoratorId);
        if (definition != null) {
            definition.setEnabled(enabled);
        }
    }

    public IBaseLabelProvider getBaseLabelProvider(String decoratorId) {
        ILabelDecorator fullProvider = this.getLabelDecorator(decoratorId);
        if (fullProvider == null) {
            return this.getLightweightLabelDecorator(decoratorId);
        }
        return fullProvider;
    }

    public ILabelDecorator getLabelDecorator(String decoratorId) {
        FullDecoratorDefinition definition = this.getFullDecoratorDefinition(decoratorId);
        if (definition != null && definition.isEnabled()) {
            return definition.getDecorator();
        }
        return null;
    }

    public ILightweightLabelDecorator getLightweightLabelDecorator(String decoratorId) {
        LightweightDecoratorDefinition definition = this.lightweightManager.getDecoratorDefinition(decoratorId);
        if (definition != null && definition.isEnabled()) {
            return definition.getDecorator();
        }
        return null;
    }

    private DecoratorDefinition getDecoratorDefinition(String decoratorId) {
        FullDecoratorDefinition returnValue = this.getFullDecoratorDefinition(decoratorId);
        if (returnValue == null) {
            return this.lightweightManager.getDecoratorDefinition(decoratorId);
        }
        return returnValue;
    }

    private FullDecoratorDefinition getFullDecoratorDefinition(String decoratorId) {
        int i = 0;
        while (i < this.fullDefinitions.length) {
            if (this.fullDefinitions[i].getId().equals(decoratorId)) {
                return this.fullDefinitions[i];
            }
            ++i;
        }
        return null;
    }

    private FullDecoratorDefinition[] getDecoratorsFor(Object element) {
        if (element == null) {
            return EMPTY_FULL_DEF;
        }
        String className = element.getClass().getName();
        FullDecoratorDefinition[] decoratorArray = (FullDecoratorDefinition[])this.cachedFullDecorators.get(className);
        if (decoratorArray != null) {
            return decoratorArray;
        }
        Collection decorators = DecoratorManager.getDecoratorsFor(element, this.enabledFullDefinitions());
        if (decorators.size() == 0) {
            decoratorArray = EMPTY_FULL_DEF;
        } else {
            decoratorArray = new FullDecoratorDefinition[decorators.size()];
            decorators.toArray(decoratorArray);
        }
        this.cachedFullDecorators.put(className, decoratorArray);
        return decoratorArray;
    }

    LightweightDecoratorManager getLightweightManager() {
        return this.lightweightManager;
    }

    public void update(String decoratorId) {
        IBaseLabelProvider provider = this.getBaseLabelProvider(decoratorId);
        if (provider != null) {
            this.fireListeners(new LabelProviderChangedEvent(provider));
        }
    }
}

