/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.decorators.FullDecoratorDefinition;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.registry.RegistryReader;

class DecoratorRegistryReader
extends RegistryReader {
    static Collection values;
    static Collection ids;
    private static String EXTENSION_ID;
    private static String ATT_LABEL;
    private static String ATT_ADAPTABLE;
    private static String ATT_ID;
    private static String ATT_DESCRIPTION;
    private static String ATT_ICON;
    private static String ATT_QUADRANT;
    private static String ATT_LOCATION;
    private static String ATT_ENABLED;
    private static String CHILD_ENABLEMENT;
    private static String P_TRUE;
    private static String ATT_OBJECT_CLASS;
    private static String ATT_LIGHTWEIGHT;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int UNDERLAY = 4;
    private static final String TOP_LEFT_STRING = "TOP_LEFT";
    private static final String TOP_RIGHT_STRING = "TOP_RIGHT";
    private static final String BOTTOM_LEFT_STRING = "BOTTOM_LEFT";
    private static final String BOTTOM_RIGHT_STRING = "BOTTOM_RIGHT";
    private static final String UNDERLAY_STRING = "UNDERLAY";

    static {
        EXTENSION_ID = "decorators";
        ATT_LABEL = "label";
        ATT_ADAPTABLE = "adaptable";
        ATT_ID = "id";
        ATT_DESCRIPTION = "description";
        ATT_ICON = "icon";
        ATT_QUADRANT = "quadrant";
        ATT_LOCATION = "location";
        ATT_ENABLED = "state";
        CHILD_ENABLEMENT = "enablement";
        P_TRUE = "true";
        ATT_OBJECT_CLASS = "objectClass";
        ATT_LIGHTWEIGHT = "lightweight";
    }

    protected DecoratorRegistryReader() {
    }

    protected boolean readElement(IConfigurationElement element) {
        boolean noClass;
        ActionExpression enablementExpression;
        String name = element.getAttribute(ATT_LABEL);
        String id = element.getAttribute(ATT_ID);
        if (ids.contains(id)) {
            this.logDuplicateId(element);
            return false;
        }
        ids.add(id);
        String description = "";
        IConfigurationElement[] descriptions = element.getChildren(ATT_DESCRIPTION);
        if (descriptions.length > 0) {
            description = descriptions[0].getValue();
        }
        boolean adaptable = P_TRUE.equals(element.getAttribute(ATT_ADAPTABLE));
        boolean enabled = P_TRUE.equals(element.getAttribute(ATT_ENABLED));
        IConfigurationElement[] enablement = element.getChildren(CHILD_ENABLEMENT);
        if (enablement.length == 0) {
            String className = element.getAttribute(ATT_OBJECT_CLASS);
            if (className == null) {
                this.logMissingElement(element, CHILD_ENABLEMENT);
                return false;
            }
            enablementExpression = new ActionExpression(ATT_OBJECT_CLASS, className);
        } else {
            enablementExpression = new ActionExpression(enablement[0]);
        }
        boolean bl = noClass = element.getAttribute("class") == null;
        if (P_TRUE.equals(element.getAttribute(ATT_LIGHTWEIGHT)) || noClass) {
            int quadrant = this.getLocationConstant(element.getAttribute(ATT_LOCATION), element);
            String iconPath = element.getAttribute(ATT_ICON);
            if (noClass && iconPath == null) {
                this.logMissingElement(element, ATT_ICON);
                return false;
            }
            values.add(new LightweightDecoratorDefinition(id, name, description, enablementExpression, adaptable, enabled, quadrant, iconPath, element));
        } else {
            values.add(new FullDecoratorDefinition(id, name, description, enablementExpression, adaptable, enabled, element));
        }
        return true;
    }

    Collection readRegistry(IPluginRegistry in) {
        values = new ArrayList();
        ids = new HashSet();
        this.readRegistry(in, "org.eclipse.ui", EXTENSION_ID);
        return values;
    }

    private int getLocationConstant(String locationDefinition, IConfigurationElement element) {
        if (locationDefinition == null) {
            locationDefinition = element.getAttribute(ATT_QUADRANT);
        }
        if (TOP_RIGHT_STRING.equals(locationDefinition)) {
            return 1;
        }
        if (TOP_LEFT_STRING.equals(locationDefinition)) {
            return 0;
        }
        if (BOTTOM_LEFT_STRING.equals(locationDefinition)) {
            return 2;
        }
        if (UNDERLAY_STRING.equals(locationDefinition)) {
            return 4;
        }
        return 3;
    }

    protected void logDuplicateId(IConfigurationElement element) {
        this.logError(element, "Duplicate id found: " + element.getAttribute(ATT_ID));
    }
}

