/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferencePage;

public class EditorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private String defaultEnc;
    private Button defaultEncodingButton;
    private Button otherEncodingButton;
    private Combo encodingCombo;
    private Button editorListPullDown;
    private Composite editorReuseGroup;
    private Button reuseEditors;
    private Button closeEditorsOnExit;
    private Composite editorReuseIndentGroup;
    private Composite editorReuseThresholdGroup;
    private IntegerFieldEditor reuseEditorsThreshold;
    private Group dirtyEditorReuseGroup;
    private Button openNewEditor;
    private Button promptToReuseEditor;
    private Button editorTabSpanMultipleLines;
    private Group editorTabCompressionGroup;
    private Button editorTabCompressionNone;
    private Button editorTabCompressionLow;
    private Button editorTabCompressionMedium;
    private Button editorTabCompressionHigh;
    private int editorTabCompression = 3;
    private static final int EDITOR_TAB_COMPRESSION_NONE = 30;
    private static final int EDITOR_TAB_COMPRESSION_LOW = 9;
    private static final int EDITOR_TAB_COMPRESSION_MEDIUM = 6;
    private static final int EDITOR_TAB_COMPRESSION_HIGH = 3;
    private static final int REUSE_INDENT = 10;
    private IntegerFieldEditor recentFilesEditor;
    private Hashtable namesToConfiguration;
    private String activeAcceleratorConfigurationName;
    private IPropertyChangeListener validityChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                EditorsPreferencePage.this.updateValidState();
            }
        }
    };

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createEditorHistoryGroup(composite);
        WorkbenchPreferencePage.createSpace(composite);
        IPreferenceStore store = this.getPreferenceStore();
        this.editorListPullDown = new Button(composite, 32);
        this.editorListPullDown.setText(WorkbenchMessages.getString("WorkbenchPreference.editorsListButton"));
        this.editorListPullDown.setFont(composite.getFont());
        this.editorListPullDown.setSelection(store.getBoolean("EDITOR_LIST_PULLDOWN_ACTIVE"));
        this.setButtonLayoutData(this.editorListPullDown);
        this.closeEditorsOnExit = new Button(composite, 32);
        this.closeEditorsOnExit.setText(WorkbenchMessages.getString("WorkbenchPreference.closeEditorsButton"));
        this.closeEditorsOnExit.setFont(composite.getFont());
        this.closeEditorsOnExit.setSelection(store.getBoolean("CLOSE_EDITORS_ON_EXIT"));
        this.setButtonLayoutData(this.closeEditorsOnExit);
        this.createEditorReuseGroup(composite);
        WorkbenchPreferencePage.createSpace(composite);
        this.createEditorTabCompressionGroup(composite);
        WorkbenchPreferencePage.createSpace(composite);
        this.createEncodingGroup(composite);
        this.updateValidState();
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.workbench_editor_preference_page_context");
        return composite;
    }

    public void init(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.updateEncodingState(true);
        this.editorListPullDown.setSelection(store.getDefaultBoolean("EDITOR_LIST_PULLDOWN_ACTIVE"));
        this.closeEditorsOnExit.setSelection(store.getDefaultBoolean("CLOSE_EDITORS_ON_EXIT"));
        this.reuseEditors.setSelection(store.getDefaultBoolean("REUSE_OPEN_EDITORS_BOOLEAN"));
        this.dirtyEditorReuseGroup.setEnabled(this.reuseEditors.getSelection());
        this.openNewEditor.setSelection(!store.getDefaultBoolean("REUSE_DIRTY_EDITORS"));
        this.openNewEditor.setEnabled(this.reuseEditors.getSelection());
        this.promptToReuseEditor.setSelection(store.getDefaultBoolean("REUSE_DIRTY_EDITORS"));
        this.promptToReuseEditor.setEnabled(this.reuseEditors.getSelection());
        this.reuseEditorsThreshold.loadDefault();
        this.reuseEditorsThreshold.getLabelControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
        this.reuseEditorsThreshold.getTextControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
        this.recentFilesEditor.loadDefault();
        this.updateEditorTabCompressionState(store.getDefaultInt("EDITOR_TAB_WIDTH_SCALAR"));
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        Preferences resourcePrefs = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (this.defaultEncodingButton.getSelection()) {
            resourcePrefs.setToDefault("encoding");
        } else {
            String enc = this.encodingCombo.getText();
            resourcePrefs.setValue("encoding", enc);
        }
        ResourcesPlugin.getPlugin().savePluginPreferences();
        store.setValue("EDITOR_LIST_PULLDOWN_ACTIVE", this.editorListPullDown.getSelection());
        store.setValue("CLOSE_EDITORS_ON_EXIT", this.closeEditorsOnExit.getSelection());
        store.setValue("REUSE_OPEN_EDITORS_BOOLEAN", this.reuseEditors.getSelection());
        store.setValue("REUSE_DIRTY_EDITORS", this.promptToReuseEditor.getSelection());
        this.reuseEditorsThreshold.store();
        this.recentFilesEditor.store();
        store.setValue("EDITOR_TAB_WIDTH_SCALAR", this.editorTabCompression);
        return super.performOk();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    private void createEncodingGroup(Composite parent) {
        String enc;
        boolean isDefault;
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(WorkbenchMessages.getString("WorkbenchPreference.encoding"));
        group.setFont(font);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorsPreferencePage.this.updateEncodingState(EditorsPreferencePage.this.defaultEncodingButton.getSelection());
                EditorsPreferencePage.this.updateValidState();
            }
        };
        this.defaultEncodingButton = new Button((Composite)group, 16);
        this.defaultEnc = System.getProperty("file.encoding", "UTF-8");
        this.defaultEncodingButton.setText(WorkbenchMessages.format("WorkbenchPreference.defaultEncoding", new String[]{this.defaultEnc}));
        data = new GridData();
        data.horizontalSpan = 2;
        this.defaultEncodingButton.setLayoutData((Object)data);
        this.defaultEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.defaultEncodingButton.setFont(font);
        this.otherEncodingButton = new Button((Composite)group, 16);
        this.otherEncodingButton.setText(WorkbenchMessages.getString("WorkbenchPreference.otherEncoding"));
        this.otherEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this.otherEncodingButton.setFont(font);
        this.encodingCombo = new Combo((Composite)group, 0);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(15);
        this.encodingCombo.setFont(font);
        this.encodingCombo.setLayoutData((Object)data);
        this.encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditorsPreferencePage.this.updateValidState();
            }
        });
        ArrayList<String> encodings = new ArrayList<String>();
        int n = 0;
        try {
            n = Integer.parseInt(WorkbenchMessages.getString("WorkbenchPreference.numDefaultEncodings"));
        }
        catch (NumberFormatException numberFormatException) {}
        int i = 0;
        while (i < n) {
            String enc2 = WorkbenchMessages.getString("WorkbenchPreference.defaultEncoding" + (i + 1), null);
            if (enc2 != null) {
                encodings.add(enc2);
            }
            ++i;
        }
        if (!encodings.contains(this.defaultEnc)) {
            encodings.add(this.defaultEnc);
        }
        boolean bl = isDefault = (enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding")) == null || enc.length() == 0;
        if (!isDefault && !encodings.contains(enc)) {
            encodings.add(enc);
        }
        Collections.sort(encodings);
        int i2 = 0;
        while (i2 < encodings.size()) {
            this.encodingCombo.add((String)encodings.get(i2));
            ++i2;
        }
        this.encodingCombo.setText(isDefault ? this.defaultEnc : enc);
        this.updateEncodingState(isDefault);
    }

    private void updateValidState() {
        if (!this.recentFilesEditor.isValid()) {
            this.setErrorMessage(this.recentFilesEditor.getErrorMessage());
            this.setValid(false);
        } else if (!this.reuseEditorsThreshold.isValid()) {
            this.setErrorMessage(this.reuseEditorsThreshold.getErrorMessage());
            this.setValid(false);
        } else if (!this.isEncodingValid()) {
            this.setErrorMessage(WorkbenchMessages.getString("WorkbenchPreference.unsupportedEncoding"));
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private boolean isEncodingValid() {
        return this.defaultEncodingButton.getSelection() || this.isValidEncoding(this.encodingCombo.getText());
    }

    private boolean isValidEncoding(String enc) {
        try {
            new String(new byte[0], enc);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    private void updateEncodingState(boolean useDefault) {
        this.defaultEncodingButton.setSelection(useDefault);
        this.otherEncodingButton.setSelection(!useDefault);
        this.encodingCombo.setEnabled(!useDefault);
        this.updateValidState();
    }

    private void createEditorReuseGroup(Composite composite) {
        Font font = composite.getFont();
        this.editorReuseGroup = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.editorReuseGroup.setLayout((Layout)layout);
        this.editorReuseGroup.setLayoutData((Object)new GridData(768));
        this.editorReuseGroup.setFont(font);
        this.reuseEditors = new Button(this.editorReuseGroup, 32);
        this.reuseEditors.setText(WorkbenchMessages.getString("WorkbenchPreference.reuseEditors"));
        this.reuseEditors.setLayoutData((Object)new GridData());
        this.reuseEditors.setFont(font);
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.reuseEditors.setSelection(store.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN"));
        this.reuseEditors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorsPreferencePage.this.reuseEditorsThreshold.getLabelControl(EditorsPreferencePage.this.editorReuseThresholdGroup).setEnabled(EditorsPreferencePage.this.reuseEditors.getSelection());
                EditorsPreferencePage.this.reuseEditorsThreshold.getTextControl(EditorsPreferencePage.this.editorReuseThresholdGroup).setEnabled(EditorsPreferencePage.this.reuseEditors.getSelection());
                EditorsPreferencePage.this.dirtyEditorReuseGroup.setEnabled(EditorsPreferencePage.this.reuseEditors.getSelection());
                EditorsPreferencePage.this.openNewEditor.setEnabled(EditorsPreferencePage.this.reuseEditors.getSelection());
                EditorsPreferencePage.this.promptToReuseEditor.setEnabled(EditorsPreferencePage.this.reuseEditors.getSelection());
            }
        });
        this.editorReuseIndentGroup = new Composite(this.editorReuseGroup, 16384);
        GridLayout indentLayout = new GridLayout();
        indentLayout.marginWidth = 10;
        this.editorReuseIndentGroup.setLayout((Layout)indentLayout);
        this.editorReuseIndentGroup.setLayoutData((Object)new GridData(768));
        this.editorReuseThresholdGroup = new Composite(this.editorReuseIndentGroup, 16384);
        this.editorReuseThresholdGroup.setLayout((Layout)new GridLayout());
        this.editorReuseThresholdGroup.setLayoutData((Object)new GridData(768));
        this.editorReuseThresholdGroup.setFont(font);
        this.reuseEditorsThreshold = new IntegerFieldEditor("REUSE_OPEN_EDITORS", WorkbenchMessages.getString("WorkbenchPreference.reuseEditorsThreshold"), this.editorReuseThresholdGroup);
        this.reuseEditorsThreshold.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
        this.reuseEditorsThreshold.setPreferencePage((PreferencePage)this);
        this.reuseEditorsThreshold.setTextLimit(2);
        this.reuseEditorsThreshold.setErrorMessage(WorkbenchMessages.getString("WorkbenchPreference.reuseEditorsThresholdError"));
        this.reuseEditorsThreshold.setValidateStrategy(0);
        this.reuseEditorsThreshold.setValidRange(1, 99);
        this.reuseEditorsThreshold.load();
        this.reuseEditorsThreshold.getLabelControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
        this.reuseEditorsThreshold.getTextControl(this.editorReuseThresholdGroup).setEnabled(this.reuseEditors.getSelection());
        this.reuseEditorsThreshold.setPropertyChangeListener(this.validityChangeListener);
        this.dirtyEditorReuseGroup = new Group(this.editorReuseIndentGroup, 0);
        this.dirtyEditorReuseGroup.setLayout((Layout)new GridLayout());
        this.dirtyEditorReuseGroup.setLayoutData((Object)new GridData(768));
        this.dirtyEditorReuseGroup.setText(WorkbenchMessages.getString("WorkbenchPreference.reuseDirtyEditorGroupTitle"));
        this.dirtyEditorReuseGroup.setFont(font);
        this.dirtyEditorReuseGroup.setEnabled(this.reuseEditors.getSelection());
        this.promptToReuseEditor = new Button((Composite)this.dirtyEditorReuseGroup, 16);
        this.promptToReuseEditor.setText(WorkbenchMessages.getString("WorkbenchPreference.promptToReuseEditor"));
        this.promptToReuseEditor.setFont(font);
        this.promptToReuseEditor.setSelection(store.getBoolean("REUSE_DIRTY_EDITORS"));
        this.promptToReuseEditor.setEnabled(this.reuseEditors.getSelection());
        this.openNewEditor = new Button((Composite)this.dirtyEditorReuseGroup, 16);
        this.openNewEditor.setText(WorkbenchMessages.getString("WorkbenchPreference.openNewEditor"));
        this.openNewEditor.setFont(font);
        this.openNewEditor.setSelection(!store.getBoolean("REUSE_DIRTY_EDITORS"));
        this.openNewEditor.setEnabled(this.reuseEditors.getSelection());
    }

    private void createEditorHistoryGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        groupComposite.setFont(composite.getFont());
        this.recentFilesEditor = new IntegerFieldEditor("RECENT_FILES", WorkbenchMessages.getString("WorkbenchPreference.recentFiles"), groupComposite);
        int recentFilesMax = 15;
        this.recentFilesEditor.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
        this.recentFilesEditor.setPreferencePage((PreferencePage)this);
        this.recentFilesEditor.setTextLimit(Integer.toString(recentFilesMax).length());
        this.recentFilesEditor.setErrorMessage(WorkbenchMessages.format("WorkbenchPreference.recentFilesError", new Object[]{new Integer(recentFilesMax)}));
        this.recentFilesEditor.setValidateStrategy(0);
        this.recentFilesEditor.setValidRange(0, recentFilesMax);
        this.recentFilesEditor.load();
        this.recentFilesEditor.setPropertyChangeListener(this.validityChangeListener);
    }

    private void updateEditorTabCompressionState(int scalar) {
        this.editorTabCompression = scalar;
        this.editorTabCompressionNone.setSelection(scalar == 30);
        this.editorTabCompressionLow.setSelection(scalar == 9);
        this.editorTabCompressionMedium.setSelection(scalar == 6);
        this.editorTabCompressionHigh.setSelection(scalar == 3);
    }

    private void createEditorTabCompressionGroup(Composite composite) {
        Font font = composite.getFont();
        this.editorTabCompressionGroup = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.editorTabCompressionGroup.setLayout((Layout)gridLayout);
        this.editorTabCompressionGroup.setLayoutData((Object)new GridData(272));
        this.editorTabCompressionGroup.setText(WorkbenchMessages.getString("WorkbenchPreference.editorTabCompression"));
        this.editorTabCompressionGroup.setFont(font);
        this.editorTabCompressionNone = new Button((Composite)this.editorTabCompressionGroup, 16);
        this.editorTabCompressionNone.setText(WorkbenchMessages.getString("WorkbenchPreference.editorTabCompressionNone"));
        this.editorTabCompressionNone.setFont(font);
        this.editorTabCompressionLow = new Button((Composite)this.editorTabCompressionGroup, 16);
        this.editorTabCompressionLow.setText(WorkbenchMessages.getString("WorkbenchPreference.editorTabCompressionLow"));
        this.editorTabCompressionLow.setFont(font);
        this.editorTabCompressionMedium = new Button((Composite)this.editorTabCompressionGroup, 16);
        this.editorTabCompressionMedium.setText(WorkbenchMessages.getString("WorkbenchPreference.editorTabCompressionMedium"));
        this.editorTabCompressionMedium.setFont(font);
        this.editorTabCompressionHigh = new Button((Composite)this.editorTabCompressionGroup, 16);
        this.editorTabCompressionHigh.setText(WorkbenchMessages.getString("WorkbenchPreference.editorTabCompressionHigh"));
        this.editorTabCompressionHigh.setFont(font);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!((Button)event.widget).getSelection()) {
                    return;
                }
                if (EditorsPreferencePage.this.editorTabCompressionNone == null) {
                    EditorsPreferencePage.this.editorTabCompression = 3;
                    return;
                }
                if (EditorsPreferencePage.this.editorTabCompressionNone.getSelection()) {
                    EditorsPreferencePage.this.editorTabCompression = 30;
                    return;
                }
                if (EditorsPreferencePage.this.editorTabCompressionLow.getSelection()) {
                    EditorsPreferencePage.this.editorTabCompression = 9;
                    return;
                }
                if (EditorsPreferencePage.this.editorTabCompressionMedium.getSelection()) {
                    EditorsPreferencePage.this.editorTabCompression = 6;
                    return;
                }
                if (EditorsPreferencePage.this.editorTabCompressionHigh.getSelection()) {
                    EditorsPreferencePage.this.editorTabCompression = 3;
                    return;
                }
            }
        };
        this.editorTabCompressionNone.addSelectionListener((SelectionListener)selectionListener);
        this.editorTabCompressionLow.addSelectionListener((SelectionListener)selectionListener);
        this.editorTabCompressionMedium.addSelectionListener((SelectionListener)selectionListener);
        this.editorTabCompressionHigh.addSelectionListener((SelectionListener)selectionListener);
        IPreferenceStore store = this.getPreferenceStore();
        this.updateEditorTabCompressionState(store.getInt("EDITOR_TAB_WIDTH_SCALAR"));
    }
}

