/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.swt.widgets.Display;

public class EventLoopProgressMonitor
extends ProgressMonitorWrapper {
    private static int T_THRESH = 100;
    private static int T_MAX = 50;
    private long lastTime = System.currentTimeMillis();

    public EventLoopProgressMonitor(IProgressMonitor monitor) {
        super(monitor);
    }

    public void beginTask(String name, int totalWork) {
        super.beginTask(name, totalWork);
        this.runEventLoop();
    }

    public void done() {
        super.done();
        this.runEventLoop();
    }

    public void internalWorked(double work) {
        super.internalWorked(work);
        this.runEventLoop();
    }

    public boolean isCanceled() {
        this.runEventLoop();
        return super.isCanceled();
    }

    private void runEventLoop() {
        long t = System.currentTimeMillis();
        if (t - this.lastTime < (long)T_THRESH) {
            return;
        }
        this.lastTime = t;
        Display disp = Display.getDefault();
        if (disp == null) {
            return;
        }
        while (disp.readAndDispatch() && System.currentTimeMillis() - t <= (long)T_MAX) {
        }
    }

    public void setCanceled(boolean b) {
        super.setCanceled(b);
        this.runEventLoop();
    }

    public void setTaskName(String name) {
        super.setTaskName(name);
        this.runEventLoop();
    }

    public void subTask(String name) {
        super.subTask(name);
        this.runEventLoop();
    }

    public void worked(int work) {
        super.worked(work);
        this.runEventLoop();
    }
}

