/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PathVariablesGroup;

public class PathVariableSelectionDialog
extends SelectionDialog {
    private PathVariablesGroup pathVariablesGroup;

    public PathVariableSelectionDialog(Shell parentShell, int variableType) {
        super(parentShell);
        this.setTitle(WorkbenchMessages.getString("PathVariableSelectionDialog.title"));
        this.pathVariablesGroup = new PathVariablesGroup(false, variableType);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.path_variable_selection_dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.pathVariablesGroup.createContents(dialogArea);
        return dialogArea;
    }

    public boolean close() {
        this.pathVariablesGroup.dispose();
        return super.close();
    }

    protected void okPressed() {
        if (this.pathVariablesGroup.performOk()) {
            Object[] variableNames = this.pathVariablesGroup.getSelection();
            this.setSelectionResult(variableNames);
        } else {
            this.setSelectionResult(null);
        }
        super.okPressed();
    }
}

