/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button editorTopButton;
    private Button editorBottomButton;
    private Button viewTopButton;
    private Button viewBottomButton;
    private BooleanFieldEditor colorIconsEditor;
    private ColorFieldEditor errorColorEditor;
    private ColorFieldEditor hyperlinkColorEditor;
    private ColorFieldEditor activeHyperlinkColorEditor;
    private int editorAlignment;
    private int viewAlignment;
    private static final String COLOUR_ICONS_TITLE = WorkbenchMessages.getString("ViewsPreference.colorIcons");
    private static final String EDITORS_TITLE = WorkbenchMessages.getString("ViewsPreference.editors");
    private static final String EDITORS_TOP_TITLE = WorkbenchMessages.getString("ViewsPreference.editors.top");
    private static final String EDITORS_BOTTOM_TITLE = WorkbenchMessages.getString("ViewsPreference.editors.bottom");
    private static final String VIEWS_TITLE = WorkbenchMessages.getString("ViewsPreference.views");
    private static final String VIEWS_TOP_TITLE = WorkbenchMessages.getString("ViewsPreference.views.top");
    private static final String VIEWS_BOTTOM_TITLE = WorkbenchMessages.getString("ViewsPreference.views.bottom");
    private static final String NOTE_LABEL = WorkbenchMessages.getString("Preference.note");
    private static final String APPLY_MESSAGE = WorkbenchMessages.getString("ViewsPreference.applyMessage");

    private Group createButtonGroup(Composite composite, String title) {
        Group buttonComposite = new Group(composite, 0x1000000);
        buttonComposite.setText(title);
        buttonComposite.setFont(composite.getFont());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        return buttonComposite;
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.views_preference_page_context");
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.editorAlignment = store.getInt("EDITOR_TAB_POSITION");
        this.viewAlignment = store.getInt("VIEW_TAB_POSITION");
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        Composite colorIconsComposite = new Composite(composite, 0);
        colorIconsComposite.setFont(font);
        this.colorIconsEditor = new BooleanFieldEditor("COLOR_ICONS", COLOUR_ICONS_TITLE, colorIconsComposite);
        this.colorIconsEditor.setPreferencePage((PreferencePage)this);
        this.colorIconsEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.colorIconsEditor.load();
        this.createEditorTabButtonGroup(composite);
        this.createViewTabButtonGroup(composite);
        this.createNoteComposite(font, composite, NOTE_LABEL, APPLY_MESSAGE);
        Group colorComposite = new Group(composite, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        colorComposite.setText(WorkbenchMessages.getString("ViewsPreference.ColorsTitle"));
        colorComposite.setFont(font);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        colorComposite.setLayoutData((Object)data);
        Composite spacingComposite = new Composite((Composite)colorComposite, 0);
        GridLayout spacingLayout = new GridLayout();
        spacingLayout.numColumns = 4;
        spacingComposite.setLayout((Layout)spacingLayout);
        spacingComposite.setFont(font);
        this.errorColorEditor = new ColorFieldEditor("ERROR_COLOR", WorkbenchMessages.getString("ViewsPreference.ErrorText"), spacingComposite);
        this.errorColorEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.errorColorEditor.load();
        this.hyperlinkColorEditor = new ColorFieldEditor("HYPERLINK_COLOR", WorkbenchMessages.getString("ViewsPreference.HyperlinkText"), spacingComposite);
        this.hyperlinkColorEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.hyperlinkColorEditor.load();
        this.activeHyperlinkColorEditor = new ColorFieldEditor("ACTIVE_HYPERLINK_COLOR", WorkbenchMessages.getString("ViewsPreference.ActiveHyperlinkText"), spacingComposite);
        this.activeHyperlinkColorEditor.setPreferenceStore(this.doGetPreferenceStore());
        this.activeHyperlinkColorEditor.load();
        return composite;
    }

    private void createEditorTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, EDITORS_TITLE);
        this.editorTopButton = new Button((Composite)buttonComposite, 16);
        this.editorTopButton.setText(EDITORS_TOP_TITLE);
        this.editorTopButton.setSelection(this.editorAlignment == 128);
        this.editorTopButton.setFont(font);
        this.editorTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.editorAlignment = 128;
            }
        });
        this.editorTopButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = EDITORS_TITLE;
            }
        });
        this.editorBottomButton = new Button((Composite)buttonComposite, 16);
        this.editorBottomButton.setText(EDITORS_BOTTOM_TITLE);
        this.editorBottomButton.setSelection(this.editorAlignment == 1024);
        this.editorBottomButton.setFont(font);
        this.editorBottomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.editorAlignment = 1024;
            }
        });
        this.attachControls((Control)this.editorTopButton, (Control)this.editorBottomButton);
    }

    private void createViewTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, VIEWS_TITLE);
        buttonComposite.setFont(font);
        this.viewTopButton = new Button((Composite)buttonComposite, 16);
        this.viewTopButton.setText(VIEWS_TOP_TITLE);
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewTopButton.setFont(font);
        this.viewTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.viewAlignment = 128;
            }
        });
        this.viewBottomButton = new Button((Composite)buttonComposite, 16);
        this.viewBottomButton.setText(VIEWS_BOTTOM_TITLE);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        this.viewBottomButton.setFont(font);
        this.viewBottomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.viewAlignment = 1024;
            }
        });
        this.attachControls((Control)this.viewTopButton, (Control)this.viewBottomButton);
    }

    private void attachControls(Control leftControl, Control rightControl) {
        FormData leftData = new FormData();
        leftData.left = new FormAttachment(0, 0);
        FormData rightData = new FormData();
        rightData.left = new FormAttachment(leftControl, 5);
        leftControl.setLayoutData((Object)leftData);
        rightControl.setLayoutData((Object)rightData);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        int editorTopValue = store.getDefaultInt("EDITOR_TAB_POSITION");
        this.editorTopButton.setSelection(editorTopValue == 128);
        this.editorBottomButton.setSelection(editorTopValue == 1024);
        this.editorAlignment = editorTopValue;
        int viewTopValue = store.getDefaultInt("VIEW_TAB_POSITION");
        this.viewTopButton.setSelection(viewTopValue == 128);
        this.viewBottomButton.setSelection(viewTopValue == 1024);
        this.viewAlignment = viewTopValue;
        this.colorIconsEditor.loadDefault();
        this.errorColorEditor.loadDefault();
        this.hyperlinkColorEditor.loadDefault();
        this.activeHyperlinkColorEditor.loadDefault();
        WorkbenchPlugin.getDefault().savePluginPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("EDITOR_TAB_POSITION", this.editorAlignment);
        store.setValue("VIEW_TAB_POSITION", this.viewAlignment);
        this.colorIconsEditor.store();
        this.errorColorEditor.store();
        this.hyperlinkColorEditor.store();
        this.activeHyperlinkColorEditor.store();
        return true;
    }
}

